/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.utils;

import com.zeitheron.thaumicadditions.tiles.TileAspectCombiner;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class AspectOperator {
    public final EnumAOP function;
    public final int ticks;
    public final Aspect a;
    public final Aspect b;
    public int ticksRunnin = 0;

    public AspectOperator(int ticks, Aspect aspect) {
        this.a = aspect;
        this.b = null;
        this.function = EnumAOP.DISSOLVE;
        this.ticks = ticks;
    }

    public AspectOperator(int ticks, Aspect a, Aspect b) {
        this.a = a;
        this.b = b;
        this.function = EnumAOP.COMBINE;
        this.ticks = ticks;
    }

    public AspectList update() {
        if (this.ticksRunnin >= this.ticks) {
            return this.getResult();
        }
        ++this.ticksRunnin;
        return null;
    }

    public AspectList getResult() {
        AspectList al = new AspectList();
        if (this.function == EnumAOP.DISSOLVE) {
            if (this.a != null) {
                al.add(this.a, 1);
            }
            return AspectHelper.reduceToPrimals((AspectList)al);
        }
        if (this.function == EnumAOP.COMBINE) {
            Aspect res = TileAspectCombiner.getOutput(this.a, this.b);
            if (res != null) {
                al.add(res, 1);
            } else {
                if (this.a != null) {
                    al.add(this.a, 1);
                }
                if (this.b != null) {
                    al.add(this.b, 1);
                }
            }
        }
        return al;
    }

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.a != null) {
            nbt.func_74778_a("a", this.a.getTag());
        }
        if (this.b != null) {
            nbt.func_74778_a("b", this.b.getTag());
        }
        nbt.func_74768_a("t", this.ticksRunnin);
        nbt.func_74768_a("tt", this.ticks);
        return nbt;
    }

    public static AspectOperator read(NBTTagCompound nbt) {
        AspectOperator ao;
        Aspect a = Aspect.getAspect((String)nbt.func_74779_i("a"));
        Aspect b = Aspect.getAspect((String)nbt.func_74779_i("b"));
        int time = nbt.func_74762_e("t");
        int tt = nbt.func_74762_e("tt");
        AspectOperator aspectOperator = a != null && b == null ? new AspectOperator(tt, a) : (ao = a != null && b != null ? new AspectOperator(tt, a, b) : null);
        if (ao != null) {
            ao.ticksRunnin = time;
        }
        return ao;
    }

    public static enum EnumAOP {
        DISSOLVE,
        COMBINE;

    }
}

