/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import com.zeitheron.thaumicadditions.api.ShadowEnchantment;
import com.zeitheron.thaumicadditions.inventory.container.ContainerShadowEnchanter;
import com.zeitheron.thaumicadditions.inventory.gui.GuiShadowEnchanter;
import com.zeitheron.thaumicadditions.net.PacketShadowFX;
import com.zeitheron.thaumicadditions.utils.ListHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileShadowEnchanter
extends TileSyncableTickable
implements ITileDroppable {
    public final InventoryDummy items = new InventoryDummy(2);
    public List<EnchantmentData> enchants = new ArrayList<EnchantmentData>();
    public boolean infusing = false;
    public AspectList pending;
    public int craftTimer;
    public int brainCD;

    public void tick() {
        this.enchants.removeIf(e -> !this.isAplicable(e.field_76302_b));
        if (this.infusing && this.items.func_70301_a(1).func_190926_b()) {
            if (this.pending == null || this.items.func_70301_a(0).func_190926_b()) {
                if (!this.field_145850_b.field_72995_K) {
                    SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.craftfail.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
                }
                this.infusing = false;
                this.craftTimer = 0;
                this.enchants.clear();
                this.pending = null;
                this.sendChangesToNearby();
                return;
            }
            if (!this.field_145850_b.field_72995_K) {
                ++this.craftTimer;
                if (this.brainCD > 0) {
                    --this.brainCD;
                }
                if (this.brainCD <= 0) {
                    SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.brain.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)0.2f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
                    this.brainCD += 35 + this.getRNG().nextInt(50);
                }
                if (this.pending.visSize() == 0) {
                    ItemStack stack = this.items.func_70301_a(0).func_77946_l();
                    this.enchants.forEach(ed -> stack.func_77966_a(ed.field_76302_b, ed.field_76303_c));
                    this.items.func_70299_a(1, stack);
                    this.items.func_70301_a(0).func_190918_g(1);
                    SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.poof.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
                    this.enchants.clear();
                    this.infusing = false;
                    this.craftTimer = 0;
                    this.sendChangesToNearby();
                    return;
                }
                Aspect a = this.pending.getAspectsSortedByName()[0];
                if (this.atTickRate(6)) {
                    if (EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)a, null, (int)12, (int)1)) {
                        this.pending.remove(a, 1);
                        HCNet.INSTANCE.sendToAllAround((IPacket)PacketShadowFX.create(this, a.getColor()), this.getSyncPoint(100));
                        this.sendChangesToNearby();
                        this.brainCD = Math.min(this.brainCD, 50);
                    } else {
                        this.brainCD = 10000;
                    }
                }
            }
        }
    }

    public AspectList calculateAspects() {
        AspectList al = new AspectList();
        for (AspectList list : this.enchants.stream().map(ed -> {
            ShadowEnchantment se = ShadowEnchantment.pick(ed.field_76302_b);
            if (se != null) {
                return se.getAspects(ed.field_76303_c);
            }
            return null;
        }).collect(Collectors.toList())) {
            if (list != null) {
                al.add(list);
                continue;
            }
            return null;
        }
        return al;
    }

    public void startCraft() {
        if (!this.infusing && !this.enchants.isEmpty() && this.items.func_70301_a(1).func_190926_b()) {
            AspectList al = this.calculateAspects();
            if (al == null || al.size() > 32) {
                return;
            }
            this.infusing = true;
            this.craftTimer = 0;
            this.pending = al;
            SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.craftstart.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)0.2f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
            this.sendChangesToNearby();
        }
    }

    public boolean isAplicable(Enchantment ench) {
        if (this.enchants.stream().filter(ed -> ed.field_76302_b != ench && !ed.field_76302_b.func_191560_c(ench)).findAny().isPresent()) {
            return false;
        }
        ItemStack s = this.items.func_70301_a(0);
        return !s.func_190926_b() && s.func_77956_u() && ench.func_92089_a(s);
    }

    public boolean isAplicableBy(Enchantment ench, EntityPlayer player) {
        if (!this.isAplicable(ench)) {
            return false;
        }
        ShadowEnchantment e = ShadowEnchantment.pick(ench);
        return e != null && e.canBeAppliedBy(player);
    }

    public void upLvl(Enchantment ench, EntityPlayer player) {
        if (!this.isAplicableBy(ench, player) || this.infusing) {
            return;
        }
        if (ListHelper.replace(this.enchants, e -> e.field_76302_b == ench, k -> new EnchantmentData(ench, Math.max(ench.func_77319_d(), Math.min(k.field_76303_c + 1, ench.func_77325_b())))) == 0) {
            this.enchants.add(new EnchantmentData(ench, ench.func_77319_d()));
        }
        this.sendChangesToNearby();
    }

    public void downLvl(Enchantment ench, EntityPlayer player) {
        if (!this.infusing && ListHelper.replace(this.enchants, e -> e.field_76302_b == ench, k -> {
            if (k.field_76303_c == ench.func_77319_d()) {
                return null;
            }
            return new EnchantmentData(ench, Math.max(ench.func_77319_d(), Math.min(k.field_76303_c - 1, ench.func_77325_b())));
        }) > 0) {
            this.sendChangesToNearby();
        }
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiShadowEnchanter(new ContainerShadowEnchanter(player, this));
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerShadowEnchanter(player, this);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)this.items.writeToNBT(new NBTTagCompound()));
        NBTTagList ench = new NBTTagList();
        this.enchants.forEach(d -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", d.field_76302_b.getRegistryName().toString());
            tag.func_74768_a("lvl", d.field_76303_c);
            ench.func_74742_a((NBTBase)tag);
        });
        nbt.func_74782_a("Enchantments", (NBTBase)ench);
        nbt.func_74757_a("Infusing", this.infusing);
        nbt.func_74768_a("Timer", this.craftTimer);
        if (this.pending != null) {
            this.pending.writeToNBT(nbt, "Aspects");
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        this.items.readFromNBT(nbt.func_74775_l("Items"));
        this.infusing = nbt.func_74767_n("Infusing");
        this.craftTimer = nbt.func_74762_e("Timer");
        NBTTagList ench = nbt.func_150295_c("Enchantments", 10);
        this.enchants.clear();
        for (int i = 0; i < ench.func_74745_c(); ++i) {
            NBTTagCompound tag = ench.func_150305_b(i);
            Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag.func_74779_i("id")));
            int lvl = tag.func_74762_e("lvl");
            this.enchants.add(new EnchantmentData(e, lvl));
        }
        if (nbt.func_74764_b("Aspects")) {
            this.pending = new AspectList();
            this.pending.readFromNBT(nbt, "Aspects");
        } else {
            this.pending = null;
        }
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.items.drop(world, pos);
        this.items.func_174888_l();
    }
}

