/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import com.zeitheron.thaumicadditions.blocks.BlockCraftingFurnace;
import com.zeitheron.thaumicadditions.inventory.container.ContainerCraftingFurnace;
import com.zeitheron.thaumicadditions.inventory.gui.GuiCraftingFurnace;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.MathHelper;

public class TileCraftingFurnace
extends TileSyncableTickable {
    public final InventoryDummy inv = new InventoryDummy(3);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    public String furnaceCustomName;

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("BurnTime", this.furnaceBurnTime);
        nbt.func_74768_a("CurrentBurnTime", this.currentItemBurnTime);
        nbt.func_74768_a("CookTime", this.cookTime);
        nbt.func_74768_a("TotalCookTime", this.totalCookTime);
        if (this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty()) {
            nbt.func_74778_a("CustomName", this.furnaceCustomName);
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
        this.furnaceBurnTime = nbt.func_74762_e("BurnTime");
        this.currentItemBurnTime = nbt.func_74762_e("CurrentBurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.totalCookTime = nbt.func_74762_e("TotalCookTime");
        if (nbt.func_74764_b("CustomName")) {
            this.furnaceCustomName = nbt.func_74779_i("CustomName");
        }
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiCraftingFurnace(player, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerCraftingFurnace(player, this);
    }

    public void tick() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        this.cookTime = this.isBurning() && this.canSmelt() ? ++this.cookTime : 0;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = this.inv.func_70301_a(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !this.inv.func_70301_a(0).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.inv.func_70299_a(1, item1);
                            }
                        }
                    }
                    this.sendChangesToNearby();
                }
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 0;
                    this.totalCookTime = this.getCookTime(this.inv.func_70301_a(0));
                    this.smeltItem();
                    flag1 = true;
                    this.sendChangesToNearby();
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockCraftingFurnace.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canSmelt() {
        if (this.inv.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.inv.func_70301_a(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = this.inv.func_70301_a(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.inv.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = this.inv.func_70301_a(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = this.inv.func_70301_a(2);
            if (itemstack2.func_190926_b()) {
                this.inv.func_70299_a(2, itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !this.inv.func_70301_a(1).func_190926_b() && this.inv.func_70301_a(1).func_77973_b() == Items.field_151133_ar) {
                this.inv.func_70299_a(1, new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public void setCustomInventoryName(String displayName) {
        this.furnaceCustomName = displayName;
    }
}

