/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.lib.zlib.utils.IndexedMap;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.PositionedSearching;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.thaumicadditions.utils.AspectOperator;
import com.zeitheron.thaumicadditions.utils.AspectRule;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class TileAspectFactory
extends TileSyncableTickable
implements IAspectContainer {
    public final AspectList contained = new AspectList();
    public final AspectList toDissolve = new AspectList();
    public final IndexedMap<Aspect, AspectRule> rules = new IndexedMap();
    public PositionedSearching<TileJarFillable> jars;
    public AspectOperator currentOperation = null;
    public int speed = 40;

    public void tick() {
        AspectList al;
        Aspect[] as;
        if (this.jars == null) {
            this.jars = new PositionedSearching(pos -> (TileJarFillable)Cast.cast((Object)this.field_145850_b.func_175625_s(pos), TileJarFillable.class), te -> te != null && !te.func_145837_r(), TileJarFillable.class);
            this.jars.setCenter(this.field_174879_c);
            this.jars.setRadius(8, 3, 8);
        }
        this.jars.update(4);
        if (this.atTickRate(20)) {
            AspectList left = TileAspectFactory.addAspects(this.jars.located, this.contained, this.rules);
            this.contained.aspects.clear();
            this.contained.add(left);
            AspectList al2 = TileAspectFactory.getAspects(this.jars.located);
            for (Aspect a : al2.getAspectsSortedByAmount()) {
                AspectRule ar = (AspectRule)this.rules.get((Object)a);
                if (ar == null) continue;
                int amt = al2.getAmount(a);
                if (amt > ar.max) {
                    boolean cd;
                    boolean bl = cd = !a.isPrimal();
                    if (!ar.voidExcess && !cd) continue;
                    int overfill = amt - ar.max;
                    int newOverfill = TileAspectFactory.takeAspect(this.jars.located, a, overfill);
                    int taken = overfill - newOverfill;
                    if (!cd) continue;
                    this.toDissolve.add(a, taken);
                    continue;
                }
                if (amt < ar.min && a.isPrimal()) continue;
            }
        }
        if (this.currentOperation == null && this.toDissolve != null && this.toDissolve.visSize() > 0 && (as = this.toDissolve.getAspectsSortedByAmount()) != null && as.length > 0) {
            Aspect dissolven = as[as.length - 1];
            this.toDissolve.remove(dissolven, 1);
            this.currentOperation = new AspectOperator(this.speed, dissolven);
        }
        if (this.currentOperation != null && (al = this.currentOperation.update()) != null) {
            this.currentOperation = null;
            this.contained.add(al);
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        this.contained.writeToNBT(nbt, "Aspects");
        this.toDissolve.writeToNBT(nbt, "Disolve");
        if (this.currentOperation != null) {
            nbt.func_74782_a("CurrentOperation", (NBTBase)this.currentOperation.write());
        }
        NBTTagList list = new NBTTagList();
        for (Aspect a : this.rules.getKeys()) {
            AspectRule ar = (AspectRule)this.rules.get((Object)a);
            if (ar == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Aspect", a.getTag());
            ar.write(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Rules", (NBTBase)list);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.contained.readFromNBT(nbt, "Aspects");
        this.toDissolve.readFromNBT(nbt, "Disolve");
        if (nbt.func_74764_b("CurrentOperation")) {
            this.currentOperation = AspectOperator.read(nbt.func_74775_l("CurrentOperation"));
        }
        this.rules.clear();
        NBTTagList list = nbt.func_150295_c("Rules", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Aspect a = Aspect.getAspect((String)tag.func_74779_i("Aspect"));
            if (a == null) continue;
            this.rules.put((Object)a, (Object)new AspectRule().read(tag));
        }
    }

    public AspectList getAspects() {
        return this.contained.copy().add(this.toDissolve);
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.contained.getAmount(tag) >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        for (Aspect a : ot.aspects.keySet()) {
            if (this.doesContainerContainAmount(a, ot.getAmount(a))) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect tag) {
        return this.contained.getAmount(tag);
    }

    public static AspectList getAspects(List<TileJarFillable> jars) {
        AspectList al = new AspectList();
        for (TileJarFillable tjf : jars) {
            if (tjf.aspect == null || tjf.amount <= 0) continue;
            al.add(tjf.aspect, tjf.amount);
        }
        return al;
    }

    public static int takeAspect(List<TileJarFillable> jars, Aspect a, int amount) {
        for (TileJarFillable tjf : jars) {
            if (tjf.aspect == null || tjf.amount <= 0) continue;
            int aboutToTake = Math.min(tjf.amount, amount);
            tjf.amount -= aboutToTake;
            amount -= aboutToTake;
            if (tjf.amount <= 0) {
                tjf.aspect = null;
                tjf.amount = 0;
            }
            if (amount > 0) continue;
            return 0;
        }
        return amount;
    }

    public static AspectList takeAspects(List<TileJarFillable> jars, AspectList list) {
        list = list.copy();
        for (TileJarFillable tjf : jars) {
            if (tjf.aspect == null || tjf.amount <= 0 || list.getAmount(tjf.aspect) <= 0) continue;
            int aboutToTake = Math.min(tjf.amount, list.getAmount(tjf.aspect));
            tjf.amount -= aboutToTake;
            list.remove(tjf.aspect, aboutToTake);
            if (tjf.amount > 0) continue;
            tjf.aspect = null;
            tjf.amount = 0;
        }
        return list;
    }

    public static int addAspect(List<TileJarFillable> jars, Aspect a, int amount, AspectRule rule) {
        for (TileJarFillable tjf : jars) {
            int left;
            amount = left = tjf.addToContainer(a, amount);
            if (left > 0) continue;
            break;
        }
        return rule != null && rule.voidExcess ? 0 : amount;
    }

    public static AspectList addAspects(List<TileJarFillable> jars, AspectList list, Map<Aspect, AspectRule> rules) {
        block4: {
            list = list.copy();
            for (TileJarFillable tjf : jars) {
                if (tjf.aspect != null && list.getAmount(tjf.aspect) > 0) {
                    int amount = list.getAmount(tjf.aspect);
                    int left = tjf.addToContainer(tjf.aspect, amount);
                    int used = amount - left;
                    list.remove(tjf.aspect, used);
                }
                if (list.visSize() > 0) continue;
                break block4;
            }
            for (Aspect key : list.aspects.keySet()) {
                AspectRule ar = rules.get(key);
                if (ar == null || !ar.voidExcess) continue;
                list.aspects.remove(key);
            }
            for (Aspect a : list.getAspectsSortedByAmount()) {
                int pval = list.getAmount(a);
                int val = TileAspectFactory.addAspect(jars, a, pval, rules.get(a));
                int use = pval - val;
                list.remove(a, use);
            }
        }
        return list;
    }
}

