/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.seals.magic;

import com.google.common.base.Objects;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.TeleporterDimPos;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.thaumicadditions.api.seals.SealCombination;
import com.zeitheron.thaumicadditions.api.seals.SealInstance;
import com.zeitheron.thaumicadditions.client.seal.PortalRenderer;
import com.zeitheron.thaumicadditions.entity.EntitySealViewer;
import com.zeitheron.thaumicadditions.net.PacketReorientPlayer;
import com.zeitheron.thaumicadditions.net.PacketTP;
import com.zeitheron.thaumicadditions.seals.SealChunkLoader;
import com.zeitheron.thaumicadditions.tiles.TileSeal;
import com.zeitheron.thaumicadditions.utils.TP;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;

public class SealPortal
extends SealInstance
implements IGlowingEntity {
    public static Set<Long> CHUNKS = new HashSet<Long>();
    public static final Map<Side, Map<String, Map<Aspect, Map<Integer, List<Long>>>>> NETWORKS = new HashMap<Side, Map<String, Map<Aspect, Map<Integer, List<Long>>>>>();
    public Object txRender;
    public ItemStack target;
    public EntitySealViewer viewer;
    public int cooldown;
    public int holeSize;
    public int targetHoleSize;
    public Long bound;
    public Long lastbound;

    public static List<Long> getNetwork(Aspect item, World world, String player) {
        List<Long> parts;
        Map<Integer, List<Long>> nets;
        Map<Aspect, Map<Integer, List<Long>>> lnets;
        Side s = world.field_72995_K ? Side.CLIENT : Side.SERVER;
        Map<String, Map<Aspect, Map<Integer, List<Long>>>> NT = NETWORKS.get(s);
        if (NT == null) {
            NT = new HashMap<String, Map<Aspect, Map<Integer, List<Long>>>>();
            NETWORKS.put(s, NT);
        }
        if ((lnets = NT.get(player)) == null) {
            lnets = new HashMap<Aspect, Map<Integer, List<Long>>>();
            NT.put(player, lnets);
        }
        if ((nets = lnets.get(item)) == null) {
            nets = new HashMap<Integer, List<Long>>();
            lnets.put(item, nets);
        }
        if ((parts = nets.get(world.field_73011_w.getDimension())) == null) {
            parts = new ArrayList<Long>();
            nets.put(world.field_73011_w.getDimension(), parts);
        }
        return parts;
    }

    public SealPortal(TileSeal seal) {
        super(seal);
    }

    @SideOnly(value=Side.CLIENT)
    public void acceptChunks() {
        int cz;
        int cx;
        if (this.bound == null) {
            return;
        }
        World w = this.seal.func_145831_w();
        if (!w.field_72995_K) {
            return;
        }
        BlockPos rp = BlockPos.func_177969_a((long)this.bound);
        ChunkProviderClient cpc = (ChunkProviderClient)w.func_72863_F();
        if (rp != null && this.holeSize > 0 && (!cpc.func_191062_e(cx = rp.func_177958_n() >> 4, cz = rp.func_177952_p() >> 4) || cpc.func_186025_d(cx, cz).func_76621_g())) {
            cpc.func_73158_c(cx, cz);
            CHUNKS.add(ChunkPos.func_77272_a((int)cx, (int)cz));
        }
    }

    @Override
    public void onEntityCollisionWithSeal(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        WorldLocation loc;
        TileSeal tile;
        if (entityIn instanceof EntitySealViewer) {
            return;
        }
        if (entityIn.func_174813_aQ().func_72326_a(state.func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos).func_186662_g(0.4)) && this.cooldown <= 0 && this.bound != null && (tile = (TileSeal)(loc = new WorldLocation(worldIn, BlockPos.func_177969_a((long)this.bound))).getTileOfType(TileSeal.class)) != null) {
            SealInstance combo;
            EnumFacing towards = tile.orientation;
            BlockPos tp = tile.func_174877_v().func_177972_a(towards);
            double x = (double)tp.func_177958_n() + 0.5;
            double y = tp.func_177956_o() - 1;
            double z = (double)tp.func_177952_p() + 0.5;
            BlockPos target = new BlockPos(x, y, z);
            if (!tile.func_145831_w().func_175623_d(target)) {
                y += 1.0;
            }
            float yaw = entityIn.field_70177_z;
            switch (towards.ordinal()) {
                case 2: {
                    yaw = 180.0f;
                    break;
                }
                case 3: {
                    yaw = 0.0f;
                    break;
                }
                case 4: {
                    yaw = 90.0f;
                    break;
                }
                case 5: {
                    yaw = 270.0f;
                    break;
                }
            }
            entityIn.field_70177_z = yaw;
            if (!worldIn.field_72995_K) {
                if (entityIn instanceof EntityPlayer) {
                    if (entityIn instanceof EntityPlayerMP) {
                        EntityPlayerMP mp = (EntityPlayerMP)entityIn;
                        PacketTP tpp = new PacketTP();
                        tpp.target = new Vec3d(x, y, z);
                        HCNet.INSTANCE.sendTo((IPacket)tpp, mp);
                        PacketReorientPlayer prp = new PacketReorientPlayer();
                        prp.yaw = yaw;
                        HCNet.INSTANCE.sendTo((IPacket)prp, mp);
                    } else {
                        TP.teleport((EntityPlayer)entityIn, x, y, z);
                    }
                } else {
                    TeleporterDimPos.of((double)x, (double)y, (double)z, (int)worldIn.field_73011_w.getDimension()).teleport(entityIn);
                }
            }
            if ((combo = tile.instance) instanceof SealPortal) {
                SealPortal portal = (SealPortal)combo;
                portal.cooldown = 60;
                portal.holeSize = 0;
            }
            this.cooldown = 60;
            this.holeSize = 0;
            SoundUtil.playSoundEffect((WorldLocation)this.seal.getLocation(), (String)"minecraft:entity.endermen.teleport", (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
            SoundUtil.playSoundEffect((WorldLocation)tile.getLocation(), (String)"minecraft:entity.endermen.teleport", (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
            this.seal.sync();
            tile.sync();
        }
    }

    @Override
    public boolean onSealActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        List<Long> positions = SealPortal.getNetwork(this.seal.getSymbol(2), this.seal.func_145831_w(), this.seal.placer.get());
        while (positions.contains(null)) {
            positions.remove(null);
        }
        Long oldbound = this.bound;
        int j = positions.indexOf(this.bound);
        boolean ok = false;
        for (int attempts = positions.size() + 2; attempts > 0; --attempts) {
            ++j;
            this.bound = positions.get(j %= positions.size());
            if (positions.indexOf(this.bound) == -1 || this.bound == null || Objects.equal((Object)this.bound, (Object)oldbound) || Objects.equal((Object)pos.func_177986_g(), (Object)positions.get(j))) continue;
            ok = true;
            this.cooldown += 5;
            break;
        }
        this.seal.sync();
        HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)hand);
        SoundUtil.playSoundEffect((WorldLocation)this.seal.getLocation(), (String)"thaumadditions:pclose", (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
        return true;
    }

    @Override
    public void onSealBreak() {
        if (this.viewer != null) {
            this.viewer.func_70106_y();
            this.viewer = null;
            SealChunkLoader.INSTANCE.relaxChunk(this.seal.func_145831_w().field_73011_w.getDimension(), this.seal.getLocation().getChunk().field_76635_g, this.seal.getLocation().getChunk().field_76647_h);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.cooldown = nbt.func_74762_e("Cooldown");
        this.target = new ItemStack(nbt.func_74775_l("Target"));
        this.targetHoleSize = nbt.func_74762_e("TargetHoleSize");
        this.bound = nbt.func_150297_b("Bound", 4) ? Long.valueOf(nbt.func_74763_f("Bound")) : null;
    }

    @SideOnly(value=Side.CLIENT)
    private void render() {
        if (this.txRender != null) {
            try {
                ((PortalRenderer)this.txRender).doRender = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void tick() {
        SealPortal portal;
        float spreadPosY;
        float spreadPosX;
        float spreadNegZ;
        float spreadNegY;
        float spreadNegX;
        if (this.seal.getLocation().getRedstone() > 0) {
            this.cooldown = 2;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 0) {
                this.seal.sendChangesToNearby();
            }
        }
        if (!Objects.equal((Object)this.lastbound, (Object)this.bound) && this.viewer != null) {
            this.viewer.func_70106_y();
            this.viewer = null;
        }
        this.lastbound = this.bound;
        BlockPos pos = this.seal.func_174877_v();
        EnumFacing face = this.seal.orientation;
        float f = face.func_176740_k() != EnumFacing.Axis.X ? 1.0f : (spreadNegX = face == EnumFacing.WEST ? 0.5f : 0.0f);
        float f2 = face.func_176740_k() != EnumFacing.Axis.Y ? 1.0f : (spreadNegY = face == EnumFacing.DOWN ? 0.5f : 0.0f);
        float f3 = face.func_176740_k() != EnumFacing.Axis.Z ? 1.0f : (spreadNegZ = face == EnumFacing.NORTH ? 0.5f : 0.0f);
        float f4 = face.func_176740_k() != EnumFacing.Axis.X ? 1.0f : (spreadPosX = face == EnumFacing.EAST ? 0.5f : 0.0f);
        float f5 = face.func_176740_k() != EnumFacing.Axis.Y ? 1.0f : (spreadPosY = face == EnumFacing.UP ? 0.5f : 0.0f);
        float spreadPosZ = face.func_176740_k() != EnumFacing.Axis.Z ? 1.0f : (face == EnumFacing.SOUTH ? 0.5f : 0.0f);
        World w = this.seal.func_145831_w();
        List ents = this.seal.func_145831_w().func_175647_a(Entity.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - spreadNegX), (double)((float)pos.func_177956_o() - spreadNegY), (double)((float)pos.func_177952_p() - spreadNegZ), (double)((float)pos.func_177958_n() + spreadPosX + 1.0f), (double)((float)pos.func_177956_o() + spreadPosY + 1.0f), (double)((float)pos.func_177952_p() + spreadPosZ + 1.0f)), e -> !(e instanceof EntitySealViewer));
        int prevHoleSize = this.holeSize;
        int ths = this.targetHoleSize;
        if (!w.field_72995_K) {
            int n = this.targetHoleSize = ents.isEmpty() || this.cooldown > 0 ? 0 : 5;
            if (ths != this.targetHoleSize) {
                this.seal.sendChangesToNearby();
            }
        }
        this.holeSize += Math.min(Math.max(-1, this.targetHoleSize - this.holeSize), 1);
        List<Long> positions = SealPortal.getNetwork(this.seal.getSymbol(2), this.seal.func_145831_w(), this.seal.placer.get());
        while (positions.contains(null)) {
            positions.remove(null);
        }
        long lpos = pos.func_177986_g();
        if (!positions.contains(lpos)) {
            positions.add(lpos);
        }
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos rp = BlockPos.func_177969_a((long)positions.get(i));
            TileSeal seal = (TileSeal)((Object)Cast.cast((Object)w.func_175625_s(rp), TileSeal.class));
            if (seal != null && seal.instance instanceof SealPortal) continue;
            positions.remove(i);
        }
        if (prevHoleSize == 0 && this.holeSize > 0 && !w.field_72995_K) {
            SoundUtil.playSoundEffect((WorldLocation)this.seal.getLocation(), (String)"thaumadditions:popen", (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
        }
        if (prevHoleSize > 0 && this.holeSize == 0 && !w.field_72995_K) {
            SoundUtil.playSoundEffect((WorldLocation)this.seal.getLocation(), (String)"thaumadditions:pclose", (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
        }
        if (this.bound == null || positions.indexOf(this.bound) == -1 || Objects.equal((Object)this.bound, (Object)this.seal.func_174877_v().func_177986_g())) {
            try {
                for (Long l : positions) {
                    if (l == null) continue;
                    WorldLocation loc = new WorldLocation(this.seal.func_145831_w(), BlockPos.func_177969_a((long)l));
                    if (Objects.equal((Object)l, (Object)this.seal.func_174877_v().func_177986_g())) continue;
                    this.bound = l;
                    break;
                }
            }
            catch (ConcurrentModificationException i) {
                // empty catch block
            }
        }
        if (w.field_72995_K) {
            try {
                this.render();
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (!w.field_72995_K) {
            SealChunkLoader.INSTANCE.forceChunk(this.seal.func_145831_w().field_73011_w.getDimension(), this.seal.getLocation().getChunk().field_76635_g, this.seal.getLocation().getChunk().field_76647_h);
        }
        if (!w.field_72995_K && this.bound != null) {
            BlockPos rpos = BlockPos.func_177969_a((long)this.bound);
            TileSeal seal = (TileSeal)((Object)Cast.cast((Object)w.func_175625_s(rpos), TileSeal.class));
            if (seal != null) {
                boolean changed;
                portal = (SealPortal)Cast.cast((Object)seal.instance, SealPortal.class);
                boolean bl = changed = this.target == null || seal.stack.get().func_77969_a(this.target);
                if (portal != null) {
                    this.target = seal.stack.get();
                }
                if (changed) {
                    seal.sendChangesToNearby();
                }
            } else {
                this.bound = null;
            }
        }
        if (w.field_72995_K && this.bound != null) {
            BlockPos rp = BlockPos.func_177969_a((long)this.bound);
            TileSeal remote = (TileSeal)((Object)Cast.cast((Object)w.func_175625_s(rp), TileSeal.class));
            if (remote != null && this.viewer == null) {
                portal = (SealPortal)Cast.cast((Object)remote.instance, SealPortal.class);
                if (portal != null) {
                    this.viewer = new EntitySealViewer(w, remote.func_174877_v().func_177958_n(), remote.func_174877_v().func_177956_o(), remote.func_174877_v().func_177952_p(), remote.orientation);
                    w.func_72838_d((Entity)this.viewer);
                }
            } else {
                this.acceptChunks();
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Cooldown", this.cooldown);
        nbt.func_74768_a("TargetHoleSize", this.targetHoleSize);
        if (this.target != null) {
            nbt.func_74782_a("Target", (NBTBase)this.target.serializeNBT());
        }
        if (this.bound != null) {
            nbt.func_74772_a("Bound", this.bound.longValue());
        }
        return nbt;
    }

    public ColoredLight produceColoredLight(float partialTicks) {
        float rad = this.targetHoleSize > 0 ? Math.min((float)this.holeSize + partialTicks, 5.0f) : Math.max((float)this.holeSize - partialTicks, 0.0f);
        return ColoredLight.builder().pos(this.seal.func_174877_v()).color(0xCCFFFF, false).radius(rad).build();
    }

    public static class PortalSealCombination
    extends SealCombination {
        public PortalSealCombination() {
            super(null, null, null);
        }

        @Override
        public String getRender(TileSeal seal, int index) {
            return "com.zeitheron.thaumicadditions.client.seal.TARSealRenders.renderPortal";
        }

        @Override
        public boolean isValid(TileSeal seal) {
            return seal.getSymbol(0) == Aspect.MAGIC && seal.getSymbol(1) == Aspect.AIR;
        }

        @Override
        public String toString() {
            return Aspect.MAGIC.getName() + ", " + Aspect.AIR.getName() + ", Any";
        }

        @Override
        public String getDescription(TileSeal seal) {
            Aspect a = seal.getSymbol(2);
            if (a != null) {
                return I18n.func_135052_a((String)"seal.thaumadditions:portalb", (Object[])new Object[]{a.getName()});
            }
            return I18n.func_135052_a((String)"seal.thaumadditions:portala", (Object[])new Object[0]);
        }
    }
}

