/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.items.weapons;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.VecDir;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import com.zeitheron.thaumicadditions.api.items.IAspectChargableItem;
import com.zeitheron.thaumicadditions.net.PacketSyncRotationAndShootShadowBeamStaff;
import com.zeitheron.thaumicadditions.net.fxh.FXShadowBeamParticle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ItemShadowBeamStaff
extends Item
implements IAspectChargableItem {
    public ItemShadowBeamStaff() {
        this.func_77655_b("shadow_beam_staff");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int count = this.getHeldAspects(stack).getAmount(Aspect.ELDRITCH);
        tooltip.add(String.format(Aspect.ELDRITCH.getName() + ": %,d/%,d", count, 500));
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            HCNet.INSTANCE.sendToServer((IPacket)PacketSyncRotationAndShootShadowBeamStaff.create(playerIn, handIn));
            playerIn.func_184609_a(handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void handleRightClick(EntityPlayer playerIn, EnumHand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        AspectList al = IAspectChargableItem.AspectChargableItemHelper.getAspects(held);
        int alienis = al.getAmount(Aspect.ELDRITCH);
        if (!playerIn.field_70170_p.field_72995_K && (alienis > 0 || playerIn.field_71075_bZ.field_75098_d)) {
            ArrayList<Vec3d> positions = new ArrayList<Vec3d>();
            double cx = 0.0;
            double cy = 0.0;
            double cz = 0.0;
            ItemShadowBeamStaff.recursiveLoop(playerIn, 1.0f, positions, 80.0);
            Vec3d v = (Vec3d)positions.get(0);
            positions.set(0, new Vec3d(v.field_72450_a, v.field_72448_b - 0.5, v.field_72449_c));
            for (int i = 0; i < positions.size(); ++i) {
                Vec3d s = (Vec3d)positions.get(i);
                cx += s.field_72450_a;
                cy += s.field_72448_b;
                cz += s.field_72449_c;
            }
            cx /= (double)positions.size();
            cy /= (double)positions.size();
            cz /= (double)positions.size();
            HashMap<Entity, Integer> strikes = new HashMap<Entity, Integer>();
            for (int i = 0; i < positions.size() - 1; ++i) {
                Vec3d s = (Vec3d)positions.get(i);
                Vec3d e = (Vec3d)positions.get(i + 1);
                Vec3d dir = e.func_178788_d(s).func_72432_b();
                double dist = s.func_72438_d(e);
                new VecDir(s, dir, dist).getEntitiesWithinDir(playerIn.field_70170_p, EntityLivingBase.class).forEach(ent -> strikes.put((Entity)ent, strikes.computeIfAbsent((Entity)ent, e2 -> 0) + 1));
            }
            strikes.remove(playerIn);
            strikes.forEach((ent, count) -> ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)playerIn), (float)(5 * count)));
            HCNet.INSTANCE.sendToAllAround((IPacket)FXShadowBeamParticle.create(positions), new NetworkRegistry.TargetPoint(playerIn.field_70170_p.field_73011_w.getDimension(), cx, cy, cz, 256.0));
            SoundUtil.playSoundEffect((World)playerIn.field_70170_p, (String)"thaumadditions:shadow_beam", (double)cx, (double)cy, (double)cz, (float)5.0f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                al.remove(Aspect.ELDRITCH, 1);
                IAspectChargableItem.AspectChargableItemHelper.setAspects(held, al);
            }
        }
        playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
    }

    public static void recursiveLoop(EntityPlayer player, float partialTime, List<Vec3d> positions, double distance) {
        Vector3 v = new Vector3(player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTime, player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTime, player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTime);
        v.y += (double)player.func_70047_e();
        Vec3d headVec = v.vec3();
        positions.add(headVec);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d endVec = headVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        RayTraceResult res = player.field_70170_p.func_147447_a(headVec, endVec, false, true, true);
        if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
            Vec3d end = res.field_72307_f;
            positions.add(end);
            distance -= positions.get(0).func_72438_d(end);
            boolean hasChanged = true;
            while (hasChanged) {
                hasChanged = false;
                Vec3d start = positions.get(positions.size() - 1);
                Vec3d dir = start.func_178788_d(positions.get(positions.size() - 2)).func_72432_b();
                EnumFacing.Axis axe = res.field_178784_b.func_176740_k();
                if (axe == EnumFacing.Axis.X) {
                    dir = new Vec3d(-dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                }
                if (axe == EnumFacing.Axis.Y) {
                    dir = new Vec3d(dir.field_72450_a, -dir.field_72448_b, dir.field_72449_c);
                }
                if (axe == EnumFacing.Axis.Z) {
                    dir = new Vec3d(dir.field_72450_a, dir.field_72448_b, -dir.field_72449_c);
                }
                end = start.func_178787_e(dir.func_186678_a(distance));
                res = player.field_70170_p.func_147447_a(start.func_178787_e(dir.func_186678_a(0.01)), end, false, true, true);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
                    end = res.field_72307_f;
                    positions.add(end);
                    distance -= start.func_72438_d(end);
                    hasChanged = true;
                    continue;
                }
                positions.add(end);
                break;
            }
        } else {
            positions.add(endVec);
        }
    }

    @Override
    public AspectList getHeldAspects(ItemStack stack) {
        return IAspectChargableItem.AspectChargableItemHelper.getAspects(stack);
    }

    @Override
    public boolean canAcceptAspect(ItemStack stack, Aspect aspect) {
        return aspect == Aspect.ELDRITCH;
    }

    @Override
    public int getMaxAspectCount(ItemStack stack, Aspect aspect) {
        return 500;
    }

    @Override
    public int acceptAspect(ItemStack stack, Aspect aspect, int amount) {
        if (aspect == Aspect.ELDRITCH) {
            AspectList al = this.getHeldAspects(stack);
            amount = Math.min(500 - al.getAmount(aspect), amount);
            al.add(aspect, amount);
            IAspectChargableItem.AspectChargableItemHelper.setAspects(stack, al);
            return amount;
        }
        return 0;
    }

    @Override
    public int extractAspect(ItemStack stack, Aspect aspect, int amount) {
        if (aspect == Aspect.ELDRITCH) {
            AspectList al = this.getHeldAspects(stack);
            amount = Math.min(al.getAmount(aspect), amount);
            al.remove(aspect, amount);
            IAspectChargableItem.AspectChargableItemHelper.setAspects(stack, al);
            return amount;
        }
        return 0;
    }

    @Override
    public Aspect getCurrentRequest(ItemStack stack) {
        return Aspect.ELDRITCH;
    }
}

