/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.compat.lux;

import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.mod.ModuleLoader;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.lux.api.LuxManager;
import com.zeitheron.thaumicadditions.TAReconstructed;
import com.zeitheron.thaumicadditions.compat.ITARC;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.world.ore.BlockCrystal;

@ModuleLoader(requiredModid="lux")
public class TARCLux
implements ITARC {
    public static final NoiseGeneratorSimplex SIMPLEX = new NoiseGeneratorSimplex();

    @Override
    public void init() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            Block blk = (Block)BlocksTC.nitor.get(dye);
            int color = dye.func_193350_e();
            LuxManager.registerBlockLight((Block)blk, (world, pos, state, e) -> {
                float flicker = (float)SIMPLEX.func_151605_a((double)(pos.func_177958_n() * 80) + (double)ManagementFactory.getRuntimeMXBean().getUptime() / 500.0, (double)(160 * pos.func_177952_p() * pos.func_177956_o())) + 1.0f;
                e.add(ColoredLight.builder().pos(pos).color(color, false).radius(15.0f + flicker / 2.0f).build());
            });
        }
        HashMap<Block, Integer> crystals = new HashMap<Block, Integer>();
        crystals.put(BlocksTC.crystalAir, Aspect.AIR.getColor());
        crystals.put(BlocksTC.crystalEarth, Aspect.EARTH.getColor());
        crystals.put(BlocksTC.crystalEntropy, Aspect.ENTROPY.getColor());
        crystals.put(BlocksTC.crystalFire, Aspect.FIRE.getColor());
        crystals.put(BlocksTC.crystalOrder, Aspect.ORDER.getColor());
        crystals.put(BlocksTC.crystalTaint, Aspect.FLUX.getColor());
        crystals.put(BlocksTC.crystalWater, Aspect.WATER.getColor());
        for (Block crystal : crystals.keySet()) {
            BlockCrystal c = (BlockCrystal)Cast.cast((Object)crystal, BlockCrystal.class);
            if (c == null) continue;
            int color = (Integer)crystals.get(crystal);
            LuxManager.registerBlockLight((Block)c, (world, pos, state, e) -> {
                boolean r = false;
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    if (world.func_180495_p(pos.func_177972_a(f)).isSideSolid((IBlockAccess)world, pos.func_177972_a(f), f.func_176734_d())) continue;
                    r = true;
                    break;
                }
                if (!r) {
                    return;
                }
                int size = (Integer)state.func_177229_b((IProperty)BlockCrystal.SIZE);
                float flicker = (float)SIMPLEX.func_151605_a((double)(pos.func_177958_n() * 80) + (double)ManagementFactory.getRuntimeMXBean().getUptime() / 2000.0, (double)(160 * pos.func_177952_p() * pos.func_177956_o())) * 2.0f;
                e.add(ColoredLight.builder().pos(pos).color(color, false).radius(flicker / 2.0f * (float)size + (float)(size + 1) * 1.5f).build());
            });
        }
        LuxManager.registerBlockLight((Block)BlocksTC.shimmerleaf, (world, pos, state, e) -> {
            float flicker = (float)SIMPLEX.func_151605_a((double)(80 * pos.func_177958_n()) + (double)ManagementFactory.getRuntimeMXBean().getUptime() / 2000.0, (double)(160 * pos.func_177952_p() * pos.func_177956_o())) + 1.0f;
            e.add(ColoredLight.builder().pos(pos).color(0.1f, 0.3f, 0.3f, 1.0f).radius(flicker * 2.0f + 3.0f).build());
        });
        LuxManager.registerBlockLight((Block)BlocksTC.vishroom, (world, pos, state, e) -> {
            float flicker = (float)SIMPLEX.func_151605_a((double)(80 * pos.func_177958_n()) + (double)ManagementFactory.getRuntimeMXBean().getUptime() / 2000.0, (double)(160 * pos.func_177952_p() * pos.func_177956_o())) + 1.0f;
            e.add(ColoredLight.builder().pos(pos).color(0.4f, 0.0f, 0.4f, 1.0f).radius(flicker * 2.0f + 3.0f).build());
        });
        LuxManager.registerBlockLight((Block)BlocksTC.cinderpearl, (world, pos, state, e) -> {
            float flicker = (float)SIMPLEX.func_151605_a((double)(80 * pos.func_177958_n()) + (double)ManagementFactory.getRuntimeMXBean().getUptime() / 2000.0, (double)(160 * pos.func_177952_p() * pos.func_177956_o())) + 1.0f;
            e.add(ColoredLight.builder().pos(pos).color(0.5f, 0.3f, 0.0f, 1.0f).radius(flicker * 2.0f + 5.0f).build());
        });
        TAReconstructed.LOG.info("ColoredLux compat initialized.");
    }
}

