/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.blocks.plants;

import com.zeitheron.hammercore.api.INoItemBlock;
import com.zeitheron.thaumicadditions.api.seals.ISealFertilizable;
import com.zeitheron.thaumicadditions.items.ItemVisPod;
import com.zeitheron.thaumicadditions.items.seed.ItemVisSeeds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.tools.ItemElementalHoe;

public class BlockVisCrop
extends BlockCrops
implements INoItemBlock,
ISealFertilizable {
    public static final PropertyInteger AGE_5 = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
    public final Aspect aspect;

    public BlockVisCrop(Aspect aspect) {
        this.aspect = aspect;
        this.func_149663_c("vis_crop/" + aspect.getTag());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        drops.add((Object)ItemVisSeeds.create(this.aspect, 1));
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if (this.func_185525_y(state)) {
            int i;
            int count = 1 + rand.nextInt(2);
            for (i = 0; i < count; ++i) {
                drops.add((Object)ItemVisPod.create(this.aspect, 1));
            }
            for (i = 0; i < Math.min(4, 1 + fortune); ++i) {
                if (rand.nextInt(20) != 0) continue;
                drops.add((Object)ItemVisSeeds.create(this.aspect, 1));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = playerIn.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemElementalHoe) {
            int j;
            int i = this.func_185527_x(state) + 1 + worldIn.field_73012_v.nextInt(2);
            if (i > (j = this.func_185526_g())) {
                i = j;
                return true;
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, this.func_185528_e(i), 2);
                worldIn.func_175669_a(2005, pos, 0);
                playerIn.func_184586_b(hand).func_77972_a(3, (EntityLivingBase)playerIn);
            } else {
                FXDispatcher.INSTANCE.drawBlockMistParticles(pos, 0x40FF40);
            }
            return true;
        }
        return false;
    }

    public int getColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (tintIndex == 1) {
            return this.aspect.getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean fertilize(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int a = this.func_185527_x(state);
        int na = Math.min(this.func_185526_g(), a + 1 + world.field_73012_v.nextInt(2));
        if (na != a) {
            world.func_180501_a(pos, this.func_185528_e(na), 2);
        }
        return na != a;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    protected PropertyInteger func_185524_e() {
        return AGE_5;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e()});
    }

    public int func_185526_g() {
        return 4;
    }

    protected int func_185529_b(World worldIn) {
        return 1;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemVisSeeds.create(this.aspect, 1);
    }
}

