/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.blocks;

import com.zeitheron.hammercore.internal.GuiManager;
import com.zeitheron.hammercore.internal.blocks.base.BlockDeviceHC;
import com.zeitheron.hammercore.internal.blocks.base.IBlockEnableable;
import com.zeitheron.hammercore.internal.blocks.base.IBlockHorizontal;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.thaumicadditions.tiles.TileAbstractSmelter;
import com.zeitheron.thaumicadditions.tiles.TileSmelterImpl;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.tiles.essentia.TileSmelter;

public class BlockAbstractSmelter
extends BlockDeviceHC<TileSmelterImpl>
implements IBlockEnableable,
IBlockHorizontal {
    public float efficiency;
    public int speed;
    public int capacity;

    public BlockAbstractSmelter(String name, float efficiency, int speed, int capacity) {
        super(Material.field_151573_f, TileSmelterImpl.class, name);
        this.efficiency = efficiency;
        this.capacity = capacity;
        this.speed = speed;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public Class<TileSmelterImpl> getTileClass() {
        return TileSmelterImpl.class;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSmelterImpl(this.efficiency, this.speed, this.capacity);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)IBlockHorizontal.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(false));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos pos2) {
        TileSmelter te = (TileSmelter)Cast.cast((Object)worldIn.func_175625_s(pos), TileSmelter.class);
        if (te != null) {
            te.checkNeighbours();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        GuiManager.openGui((EntityPlayer)player, (TileSyncable)((TileSyncable)Cast.cast((Object)world.func_175625_s(pos), TileSyncable.class)));
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return WorldUtil.isEnabled((int)world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos))) ? 13 : super.getLightValue(state, world, pos);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        IInventory te = (IInventory)Cast.cast((Object)world.func_175625_s(pos), IInventory.class);
        if (te != null) {
            return Container.func_94526_b((IInventory)te);
        }
        return 0;
    }

    public static void setFurnaceState(World world, BlockPos pos, boolean state) {
        if (state == WorldUtil.isEnabled((IBlockState)world.func_180495_p(pos))) {
            return;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        keepInventory = true;
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)IBlockEnableable.ENABLED, (Comparable)Boolean.valueOf(state)), 3);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
        keepInventory = false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileAbstractSmelter tileentity = (TileAbstractSmelter)((Object)Cast.cast((Object)worldIn.func_175625_s(pos), TileAbstractSmelter.class));
        if (tileentity != null && !worldIn.field_72995_K && tileentity.vis > 0) {
            int ess = tileentity.vis;
            tileentity.inv.drop(worldIn, pos);
            AuraHelper.polluteAura((World)worldIn, (BlockPos)pos, (float)ess, (boolean)true);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        if (WorldUtil.isEnabled((IBlockState)state)) {
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.2f + r.nextFloat() * 5.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = r.nextFloat() * 0.5f - 0.25f;
            if (WorldUtil.getFacing((IBlockState)state) == EnumFacing.WEST) {
                w.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                w.func_175688_a(EnumParticleTypes.FLAME, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
            }
            if (WorldUtil.getFacing((IBlockState)state) == EnumFacing.EAST) {
                w.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                w.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
            }
            if (WorldUtil.getFacing((IBlockState)state) == EnumFacing.NORTH) {
                w.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                w.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
            }
            if (WorldUtil.getFacing((IBlockState)state) == EnumFacing.SOUTH) {
                w.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                w.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

