/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RecipesFluxConcentrator {
    private static final Map<IBlockState, FluxConcentratorOutput> HANDLERS = new HashMap<IBlockState, FluxConcentratorOutput>();

    public static void handle(IBlockState src, FluxConcentratorOutput target) {
        if (target == null) {
            throw new NullPointerException("target must not be null.");
        }
        HANDLERS.put(src, target);
    }

    public static boolean handle(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (HANDLERS.containsKey(state)) {
            return HANDLERS.get(state).test(world, pos);
        }
        return false;
    }

    public static FluxConcentratorOutput output(IBlockState state) {
        return new FluxConcentratorOutput(state);
    }

    public static Stream<Map.Entry<IBlockState, FluxConcentratorOutput>> listRecipes() {
        return HANDLERS.entrySet().stream();
    }

    public static ItemStack stackFromState(IBlockState state) {
        Item drop = state.func_177230_c().func_180660_a(state, (Random)ThreadLocalRandom.current(), 0);
        int meta = state.func_177230_c().func_180651_a(state);
        if (drop != null && drop != Items.field_190931_a) {
            return new ItemStack(drop, 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static class FluxConcentratorOutput
    implements BiPredicate<World, BlockPos> {
        protected final IBlockState state;

        public FluxConcentratorOutput(IBlockState state) {
            this.state = state;
        }

        public IBlockState getOutState() {
            return this.state;
        }

        public ItemStack getOutStack() {
            return RecipesFluxConcentrator.stackFromState(this.getOutState());
        }

        @Override
        public boolean test(World world, BlockPos pos) {
            return world.func_180501_a(pos, this.getOutState(), 2);
        }
    }
}

