/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.tonics.BasicTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class CompositeTonicRecipe
extends ShapedOreRecipe {
    CompositeTonicRecipe(ShapedOreRecipe template) {
        super(null, template.func_77571_b(), MinecraftGlue.JR.primerFrom(template));
    }

    static final List<PotionEffect> splitEffects(List<PotionEffect> effects, int spread) {
        if (spread > 1) {
            ListIterator<PotionEffect> litr = effects.listIterator();
            while (litr.hasNext()) {
                PotionEffect e = litr.next();
                if (e.func_188419_a().func_76403_b() && e.func_188419_a() != MinecraftGlue.Potion_saturation) {
                    litr.remove();
                    continue;
                }
                int duration = Math.max(1, e.func_76459_b() / spread);
                PotionEffect new_e = new PotionEffect(e.func_188419_a(), duration, e.func_76458_c(), e.func_82720_e(), e.func_188418_e());
                litr.set(new_e);
            }
        }
        return effects;
    }

    private List<PotionEffect> normalizedEffects(List<PotionEffect> effects, boolean fortified) {
        LinkedHashMap<Potion, MinecraftGlue.StubbornPotionEffect> hits = new LinkedHashMap<Potion, MinecraftGlue.StubbornPotionEffect>();
        for (PotionEffect e_next : effects) {
            Potion p = e_next.func_188419_a();
            PotionEffect e_curr = (PotionEffect)hits.get(p);
            if (e_curr != null) {
                e_curr.func_76452_a(e_next);
                continue;
            }
            hits.put(p, MinecraftGlue.StubbornPotionEffect.from(e_next));
        }
        effects.clear();
        if (hits.size() <= VfpConfig.getInstance().maxMoonshineMixCapacity()) {
            for (PotionEffect e_next : hits.values()) {
                if (!fortified) {
                    effects.add(new PotionEffect(e_next));
                    continue;
                }
                effects.add(e_next);
            }
        }
        hits.clear();
        return effects;
    }

    private List<PotionEffect> mergeEffects(InventoryCrafting grid, List<Integer> slots, MutableObject<String> type_id, boolean fortified) {
        NBTTagCompound holdNbt = new NBTTagCompound();
        ArrayList<String> registered_types = new ArrayList<String>();
        int n_valid = 0;
        for (int slotindex : slots) {
            String type_id0;
            ItemStack from = grid.func_70301_a(slotindex);
            List<PotionEffect> additional = MinecraftGlue.Potions.getEffects(from, true);
            MinecraftGlue.Potions.addCustomEffects(holdNbt, false, additional);
            if (!additional.isEmpty() && (type_id0 = MinecraftGlue.Potions.getTypeTranslationKeyOrNull(from, "potion.effect.")) != null) {
                ++n_valid;
                if (!registered_types.contains(type_id0)) {
                    registered_types.add(type_id0);
                }
            }
            additional.clear();
        }
        if (n_valid == slots.size() && registered_types.size() == 1) {
            type_id.setValue(registered_types.get(0));
        }
        return this.normalizedEffects(PotionUtils.func_185192_b((NBTTagCompound)holdNbt), fortified);
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        if (!VfpConfig.getInstance().allowMoonshineMixing() || VfpConfig.getInstance().maxMoonshineMixCapacity() <= 1) {
            return out;
        }
        ArrayList<Integer> source_slots = new ArrayList<Integer>();
        int n_spread = 0;
        boolean fortified = false;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            if (MinecraftGlue.RID.matches(next, "itemEmptyBottle", VfpObj.Our_Empty_Bottle_obj)) {
                ++n_spread;
                continue;
            }
            if (MinecraftGlue.Potions.isa(next, true)) {
                source_slots.add(i);
                continue;
            }
            if (!MinecraftGlue.RID.matches(next, "ingredientVinegar")) continue;
            fortified = true;
        }
        if (n_spread == 1 && !source_slots.isEmpty()) {
            MutableObject type_id = new MutableObject();
            List<PotionEffect> final_effect = this.mergeEffects(grid, source_slots, (MutableObject<String>)type_id, fortified);
            out = TonicDrink.create(final_effect, null, (String)type_id.getValue());
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe impl = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new CompositeTonicRecipe(impl);
        }
    }
}

