/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrups;
import org.jwaresoftware.mcmods.vfp.sugar.FizzyDrinks;
import org.jwaresoftware.mcmods.vfp.sugar.FruitPreservesJar;
import org.jwaresoftware.mcmods.vfp.sugar.GoldenSugar;
import org.jwaresoftware.mcmods.vfp.sugar.Seedmush;
import org.jwaresoftware.mcmods.vfp.sugar.SimpleCookies;

public final class SugarExtrasBuildHelper
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "SugarExtras";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        int mush_maxstack = VfpCapacity.FULL_BUCKET_STACK.count();
        VfpObj.Hardened_Sugar_obj = VfpBuilder.newFood(VfpOid.Hardened_Sugar, LikeFood.hardened_sugar);
        VfpObj.Golden_Sugar_obj = new GoldenSugar().autoregister();
        VfpObj.Molasses_Ball_obj = VfpBuilder.newFood(VfpOid.Molasses_Ball, LikeFood.hardened_sugar);
        VfpObj.Taffy_Blob_obj = VfpBuilder.newFood(VfpOid.Taffy_Blob, LikeFood.sugar);
        VfpObj.Hardened_Sugar_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Hardened_Sugar_Pantry_Block, MinecraftGlue.Blocks_sand, VfpObj.Hardened_Sugar_obj, null);
        VfpObj.Compacted_Seeds_obj = VfpBuilder.newItem(VfpOid.Compacted_Seeds);
        VfpObj.Seedmush_obj = Seedmush.makeObjects();
        VfpObj.Carrot_Jam_Mush_obj = VfpBuilder.newMisc(VfpOid.Carrot_Jam_Mush).func_77642_a(MinecraftGlue.Items_bucket).func_77625_d(mush_maxstack);
        VfpObj.Apple_Jelly_Mush_obj = VfpBuilder.newMisc(VfpOid.Apple_Jelly_Mush).func_77642_a(MinecraftGlue.Items_bucket).func_77625_d(mush_maxstack);
        VfpObj.ChorusFruit_Jelly_Mush_obj = VfpBuilder.newMisc(VfpOid.ChorusFruit_Jelly_Mush).func_77642_a(MinecraftGlue.Items_bucket).func_77625_d(mush_maxstack);
        VfpObj.Raw_Caffeine_obj = VfpBuilder.newItem(VfpOid.Raw_Caffeine).func_77642_a(VfpObj.Empty_Bottle_obj);
        VfpObj.Carrot_Jam_obj = FruitPreservesJar.newJar(VfpOid.Carrot_Jam, 16744969);
        VfpObj.Apple_Jelly_obj = FruitPreservesJar.newJar(VfpOid.Apple_Jelly, 15769948);
        VfpObj.ChorusFruit_Jelly_obj = FruitPreservesJar.newJar(VfpOid.ChorusFruit_Jelly, 11168687);
        VfpObj.Drink_Syrup_obj = DrinkSyrups.makeObjects();
        SimpleCookies.register("sugar", SimpleCookies.SUGAR_COOKIE_ID, VfpObj.Portion_Butter_obj);
        SimpleCookies.register("molasses", SimpleCookies.MOLASSES_COOKIE_ID, VfpObj.Molasses_Ball_obj);
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isDrinkFlavor()) continue;
            FizzyDrinks.register(powder);
        }
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.hardened_sugar.food().item(VfpObj.Hardened_Sugar_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"ingredientCaffeine", (Item)VfpObj.Raw_Caffeine_obj);
        OreDictionary.registerOre((String)"foodCurative", (Item)VfpObj.Golden_Sugar_obj);
        OreDictionary.registerOre((String)"foodCurativeSedation", (Item)VfpObj.Golden_Sugar_obj);
        OreDictionary.registerOre((String)"ingredientCraftyPreserve", (Item)VfpObj.Carrot_Jam_obj);
        OreDictionary.registerOre((String)"ingredientCraftyPreserve", (Item)VfpObj.Apple_Jelly_obj);
        OreDictionary.registerOre((String)"ingredientCraftyPreserve", (Item)VfpObj.ChorusFruit_Jelly_obj);
        DrinkSyrups.addDictionaryEntries((DrinkSyrups)VfpObj.Drink_Syrup_obj);
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        if (runtime.getConfig().includePotionBrewing()) {
            MinecraftGlue.BrewEffect.addWaterConversionFor(VfpObj.Golden_Sugar_obj, 0, VfpPotionTypes.SUGAR_BOMBED);
            MinecraftGlue.BrewEffect.addRecipeFor(VfpObj.Golden_Sugar_obj, 0, VfpPotionTypes.SUGAR_BOMBED);
        }
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Hardened_Sugar.fmlid(), VfpCapacity.HALF_TRAY, (Object)VfpObj.Sugarcane_obj, new ItemStack(VfpObj.Hardened_Sugar_obj), VfpObj.Drying_Agent_obj, (ItemStack)null);
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Sugar_obj, VfpCapacity.PORTABLE.count()), new Object[]{VfpObj.Hardened_Sugar_obj}).setRegistryName(ModInfo.r(VfpOid.Hardened_Sugar.fmlid() + "_unpack")));
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Hardened_Sugar_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Hardened_Sugar_obj, VfpObj.Hardened_Sugar_Pantry_Block_obj, VfpObj.Hardened_Sugar_obj);
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Golden_Sugar_obj), new Object[]{"sg", "gg", Character.valueOf('g'), "nuggetGold", Character.valueOf('s'), VfpObj.Hardened_Sugar_obj}).setRegistryName(ModInfo.r(VfpOid.Golden_Sugar.fmlid())));
        Seedmush.buildRecipes(runtime.getConfig(), recipes);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(null, new ItemStack(VfpObj.Fizzing_Agent_obj, 2), new Object[]{VfpObj.Hardened_Sugar_obj, VfpObj.Hardened_Sugar_obj, "ingredientCaffeine"}).setRegistryName(ModInfo.r(VfpOid.Fizzing_Agent.fmlid())), VfpOid.Fizzing_Agent.craftingXp()));
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Fizzing_Agent_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Fizzing_Agent_obj, VfpObj.Fizzing_Agent_Pantry_Block_obj, VfpObj.Fizzing_Agent_obj);
        GameRegistry.addSmelting((Item)VfpObj.Hardened_Sugar_obj, (ItemStack)new ItemStack(VfpObj.Molasses_Ball_obj, 2), (float)LikeFood.hardened_sugar.smeltExperience());
        GameRegistry.addSmelting((Block)VfpObj.Hardened_Sugar_Pantry_Block_obj, (ItemStack)new ItemStack(VfpObj.Molasses_Ball_obj, 2 * VfpCapacity.STANDARD_BLOCK.count()), (float)(LikeFood.hardened_sugar.smeltExperience() * 9.0f));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Taffy_Blob_obj, VfpCapacity.TAFFY_BATCH.count()), new Object[]{"SSS", "HsH", "tWh", Character.valueOf('S'), FoodPowders.get(FoodPowders.Type.SYRUP, 1), Character.valueOf('H'), VfpObj.Hardened_Sugar_obj, Character.valueOf('s'), "portionSaltSmall", Character.valueOf('t'), "ingredientStarch", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r(VfpOid.Taffy_Blob.fmlid() + "_batch")), VfpOid.Taffy_Blob.craftingXp()));
        DrinkSyrups.buildRecipes(recipes);
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Hardened_Sugar, VfpObj.Hardened_Sugar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Golden_Sugar, VfpObj.Golden_Sugar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Hardened_Sugar_Pantry_Block, VfpObj.Hardened_Sugar_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Molasses_Ball, VfpObj.Molasses_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Taffy_Blob, VfpObj.Taffy_Blob_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Compacted_Seeds, VfpObj.Compacted_Seeds_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Seedmush, VfpObj.Seedmush_obj, Seedmush.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Carrot_Jam_Mush, VfpObj.Carrot_Jam_Mush_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Apple_Jelly_Mush, VfpObj.Apple_Jelly_Mush_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.ChorusFruit_Jelly_Mush, VfpObj.ChorusFruit_Jelly_Mush_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Raw_Caffeine, VfpObj.Raw_Caffeine_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Preserves_Jar, VfpObj.Carrot_Jam_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Preserves_Jar, VfpObj.Apple_Jelly_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Preserves_Jar, VfpObj.ChorusFruit_Jelly_obj);
            DrinkSyrups syrup = (DrinkSyrups)VfpObj.Drink_Syrup_obj;
            runtime.doRenderSetupOrFail(VfpOid.Drink_Syrup, syrup, DrinkSyrups.getUsesRenderNames(), DrinkSyrups.getUsesRenderMetas());
        }
    }
}

