/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class FizzyDrinks
extends VfpLiquidMultiItem {
    private static int BUZZED_EFFECT_DURATION_SECS = 90;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static FizzyDrinks INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient flavor) {
        return FizzyDrinks.register(flavor, VARIANT_FLAVORS, "fizzy drinks");
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a fizzy drink", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowders.Type.CARROT ? "orange" : (flavor == FoodPowders.Type.COCOA ? "cola" : (flavor == FoodPowders.Type.DANDELION ? "dandy" : (flavor == FoodPowders.Type.POPPY ? "poppy" : (flavor == FoodPowders.Type.CACTUS ? "klingon" : flavor.name_lowercased()))));
        return FizzyDrinks.register(FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, name));
    }

    public FizzyDrinks(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, LiquidType.FIZZY, tab);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? BUZZED_EFFECT_DURATION_SECS : super.getPotionEffectDurationSecs(good);
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 33731;
        }
        return colorValue;
    }

    public static final FizzyDrinks makeObjects() {
        if (INSTANCE == null && VARIANT_FLAVORS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(41);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                LikeFood like = ingredient.isEnabled() ? LikeFood.hardened_sugar : null;
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, like, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.FizzyDrink, FizzyDrinks.class);
        }
        return INSTANCE;
    }

    public static void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_fizzy_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_fizzy_drink);
            }
        }
    }

    public static final void buildRecipes(IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(41);
            ItemStack water_bottle = Water.fizzy(1);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                Ingredient ingredient = VARIANT_ARRAY[i].datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack a_fizzy_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                String recipeitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                recipes.register(new ShapedOreRecipe(null, a_fizzy_drink, new Object[]{"xf", "b ", Character.valueOf('x'), recipeitem, Character.valueOf('f'), VfpObj.Fizzing_Agent_obj, Character.valueOf('b'), water_bottle}).setRegistryName(ModInfo.r("fizzydrink_" + ingredient.name())));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.FizzyDrink, (Class)FizzyDrinks.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

