/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;

public final class ReheatFoodRecipe
extends VfpRecipe {
    private final int _required_heatUps;
    private ItemStack _output = ItemStack.field_190927_a;

    ReheatFoodRecipe(int min) {
        this._required_heatUps = Math.max(1, min);
    }

    public ReheatFoodRecipe(ItemStack out) {
        this(1);
        this._output = out;
    }

    private boolean canHeat(Item item, ItemStack stack) {
        boolean yes = false;
        if (item instanceof IReheatable) {
            yes = !((IReheatable)item).isCooled(stack);
        }
        return yes;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        int n_items = 0;
        int n_heatups = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            Item item = next.func_77973_b();
            if (item == VfpObj.Heat_Portion_obj) {
                ++n_heatups;
            } else if (this.canHeat(item, next)) {
                ++n_items;
            } else {
                return false;
            }
            if (n_items <= true) continue;
            return false;
        }
        return n_items == 1 && n_heatups >= this._required_heatUps;
    }

    public ItemStack func_77571_b() {
        return this._output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            Item item;
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next) || (item = next.func_77973_b()) == VfpObj.Heat_Portion_obj) continue;
            IReheatable api = (IReheatable)item;
            ItemStack heated = MinecraftGlue.ItemStacks_copyItemStackSingle(next);
            api.setHeated(heated);
            if (!api.isHeated(heated)) break;
            out = heated;
            break;
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return MinecraftGlue.emptyNonNullItemStackList(grid.func_70302_i_());
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            int min = JsonUtils.func_151208_a((JsonObject)json, (String)"required_heat", (int)-1);
            return new ReheatFoodRecipe(min);
        }
    }
}

