/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSoakableFood;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.tonics.SoakFoodShapedRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.SoakFoodShapelessRecipe;

public final class Gelos
extends VfpSoakableFood {
    private static final List<Ingredient> VARIANT_INGREDIENTS = new ArrayList<Ingredient>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Gelos INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null ingredient is required for an edible gelo", (Object[])new Object[0]);
        boolean added = false;
        if (!VARIANT_INGREDIENTS.contains(ingredient)) {
            VARIANT_INGREDIENTS.add(ingredient);
            added = true;
        }
        return added;
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for an edible gelo", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowders.Type.CARROT ? "orange" : (flavor == FoodPowders.Type.DANDELION ? "dandy" : (flavor == FoodPowders.Type.POPPY ? "poppy" : (flavor == FoodPowders.Type.CACTUS ? "klingon" : (flavor == FoodPowders.Type.INK ? "midnight" : (flavor == FoodPowders.Type.SYRUP ? "sugarbomb" : (flavor == FoodPowders.Type.UGLI_FRUIT ? "ugli" : flavor.name_lowercased()))))));
        return Gelos.register(FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, name));
    }

    public Gelos(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_ARRAY, tab);
    }

    @Override
    public int getPortionFoodPoints(ItemStack stack) {
        int fp = super.getPortionFoodPoints(stack);
        if (this.isSoaked(stack)) {
            fp = LikeFood.soaked_gelo.healAmount();
        }
        return fp;
    }

    @Override
    public float func_150906_h(ItemStack stack) {
        float sm = super.func_150906_h(stack);
        if (this.isSoaked(stack)) {
            sm = LikeFood.soaked_gelo.saturationModifier();
        }
        return sm;
    }

    static final Gelos makeObjects() {
        if (INSTANCE == null && VARIANT_INGREDIENTS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(31);
            String basename = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                String fmlid = basename + "_" + ingredient.name().toLowerCase(Locale.US);
                variants.add(new VfpTransientVariant(ingredient.id(), fmlid, LikeFood.sugar, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Gelo, Gelos.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_gelo = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodJello", (ItemStack)a_gelo);
            }
        }
    }

    static final void buildRecipes(VfpConfig config, @Nonnull IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            ItemStack gel_powder = FoodPowders.get(FoodPowders.Type.GELATIN, 1);
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(31);
            boolean soakable = config.allowMoonshineMixing();
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                VfpVariant variant = VARIANT_ARRAY[i];
                Ingredient ingredient = variant.datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack gelo_ball = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                Object ingredient_obj = ingredient.recipeitem();
                if (ingredient.isClassifier()) {
                    ingredient_obj = ingredient.recipeitemName();
                }
                recipes.register(new ShapedOreRecipe(null, gelo_ball, new Object[]{"gs", "Iw", Character.valueOf('g'), gel_powder, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('I'), ingredient_obj, Character.valueOf('w'), "portionWaterSmall"}).setRegistryName(ModInfo.r(variant.fmlid())));
                if (!soakable) continue;
                recipes.register(new SoakFoodShapelessRecipe(gelo_ball, gelo_ball, "itemPotionBottle").setRegistryName(ModInfo.r("soaked_" + variant.fmlid())));
                recipes.register(new SoakFoodShapedRecipe(gelo_ball, "xxx", "xPx", "xxx", Character.valueOf('x'), gelo_ball, Character.valueOf('P'), "itemPotionBottle").setRegistryName(ModInfo.r("soaked_" + variant.fmlid() + "_x8")));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Gelo, (Class)Gelos.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

