/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.misc.DefinedDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.EdibleCactus;
import org.jwaresoftware.mcmods.vfp.misc.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.KingDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.RoastedSeeds;
import org.jwaresoftware.mcmods.vfp.misc.Sandwiches;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

public final class DeckerSandwiches
extends VfpPantryMultiItem {
    private static final String _SAMPLE_TAG = "SAMPLE";
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Decker, DeckerSandwiches.class, "type");
    private static final int _GENERIC = 0;
    private static final int _CHIKIN = 1;
    private static final int _OSTEAK = 2;
    private static final int _MUTTON = 3;
    private static final int _LUMBERJACK = 4;
    private static final int _KINGED = 5;
    private static final int _CUBAN = 6;
    private static final int _CSTEAK = 7;
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Decker.fmlid(), LikeFood.decker, VARIANT_SET, true), new VfpVariant(1, VfpOid.Decker_Chicken.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(2, VfpOid.Decker_Steak.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(3, VfpOid.Decker_Mutton.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(4, VfpOid.Decker_Lumberjack.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(5, VfpOid.Decker_Kinged.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(6, VfpOid.Decker_Cuban.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(7, VfpOid.Decker_Cheesesteak.fmlid(), LikeFood.decker, VARIANT_SET, false)};
    static NonNullList<ItemStack> SAMPLES_ARRAY = NonNullList.func_191197_a((int)VARIANT_ARRAY.length, (Object)MinecraftGlue.ItemStacks_NULLSTACK());
    private static DeckerSandwiches INSTANCE;
    private static final int _MAX_INGREDIENTS;
    private static final int _BONUS_EFFORT_THRESHOLD = 4;

    public DeckerSandwiches(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.TYPICAL_FOOD_PORTION.healAmount();
    }

    @Override
    public float func_150906_h(ItemStack stack) {
        float saturation = super.func_150906_h(stack);
        NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
        if (instr != null && instr.func_150297_b("FoodSaturation", 5)) {
            saturation = instr.func_74760_g("FoodSaturation");
        }
        return saturation;
    }

    @Override
    protected void addFoodPointsInformation_(ItemStack stack, World world, List<String> tooltip, boolean advanced) {
        String uitip;
        super.addFoodPointsInformation_(stack, world, tooltip, true);
        NBTTagCompound instr = null;
        if ((advanced || VfpConfig.getInstance().showDeckerIngredients()) && (instr = MinecraftGlue.Instructions.get(stack)) != null && !(uitip = instr.func_74779_i("UiTip")).isEmpty()) {
            String[] lines = StringUtils.split((String)uitip, (String)"\n", (int)9);
            for (int i = 0; i < lines.length; ++i) {
                tooltip.add(" + " + TextFormatting.DARK_GRAY + lines[i] + TextFormatting.RESET);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String displayName = super.func_77653_i(stack);
        if (stack.func_77973_b() == this && stack.func_77942_o() && stack.func_77978_p().func_74767_n(_SAMPLE_TAG)) {
            displayName = displayName + " " + MinecraftGlue.Strings.translate("item.vfp_sample.marker");
        }
        return displayName;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.addAll(DeckerSandwiches.deckerSamples());
        }
    }

    public static final DeckerSandwiches makeObjects() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Decker, DeckerSandwiches.class);
        }
        return INSTANCE;
    }

    private static void buildSamples() {
        ItemStack french_bread = LikeFood.french_bread.sample(1);
        ItemStack steak = LikeFood.beef.sample(1);
        SAMPLES_ARRAY.set(1, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.chicken.sample(1), new ItemStack(VfpObj.Portion_Roasted_Veg_obj)), 1, LikeFood.chicken.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(2, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), new ItemStack(VfpObj.Caramelized_Alliums_obj)), 2, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(7, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.cheese_portion.sample(1), new ItemStack(VfpObj.Sauteed_Alliums_Mushrooms_obj)), 7, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(3, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.mutton.sample(1)), 3, LikeFood.fried_egg.healAmount(), -1, 0.0f)));
        SAMPLES_ARRAY.set(6, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), LikeFood.pork.sample(1), LikeFood.salt_pork.sample(1), LikeFood.cheese_portion.sample(1), new ItemStack(VfpObj.Caramelized_Alliums_obj)), 6, -1, -1, LikeFood.meat_pie.saturationModifier())));
        SAMPLES_ARRAY.set(4, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(french_bread.func_77946_l(), steak.func_77946_l(), LikeFood.mashed_potato.sample(), LikeFood.fried_egg.sample(), LikeFood.fried_egg.sample(), EdibleCactus.roasted_slice(1)), 4, -1, -1, LikeFood.golden_carrot.saturationModifier())));
        SAMPLES_ARRAY.set(0, (Object)DeckerSandwiches.marksample(DeckerSandwiches.create(new FixedIItemHandler(LikeFood.sandwich_bread.sample(), LikeFood.roast_veg_medley.sample(), LikeFood.cheese_portion.sample(), new ItemStack(VfpObj.Caramelized_Alliums_obj), RoastedSeeds.sunflower(1)), 0, 0, -1, 0.0f)));
        SAMPLES_ARRAY.set(5, (Object)DeckerSandwiches.marksample(DeckerSandwiches.kingme(new FixedIItemHandler(DoughBallType.cookedEgg(1), new ItemStack(VfpObj.Bat_CheeseBurger_obj), Sandwiches.spamAndEgg(1)))));
    }

    static final void buildRecipes(@Nonnull IForgeRegistry<IRecipe> recipes) {
        DeckerSandwiches.buildSamples();
        recipes.register(new GenericDeckerSandwichRecipe().setRegistryName(ModInfo.r("generic_decker")));
        recipes.register(new KingDeckerSandwichRecipe().setRegistryName(ModInfo.r("kingme_decker")));
        recipes.register(new DefinedDeckerSandwichRecipe(1, LikeFood.chicken, new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(1), new Object[]{"Bm", "Cv", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('C'), "foodChickenCooked", Character.valueOf('m'), "portionMayo", Character.valueOf('v'), "ingredientSalad"})).setRegistryName(ModInfo.r("decker_chicken")));
        recipes.register(new DefinedDeckerSandwichRecipe(2, LikeFood.fried_egg, new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(2), new Object[]{"Bm", "Ko", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), "foodBeefsteakCooked", Character.valueOf('m'), "portionMayo", Character.valueOf('o'), VfpObj.Caramelized_Alliums_obj})).setRegistryName(ModInfo.r("decker_allium_steak")));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new DefinedDeckerSandwichRecipe(7, LikeFood.fried_egg, new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(7), new Object[]{"Bc", "Ko", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('c'), "foodCheese", Character.valueOf('K'), "foodBeefsteakCooked", Character.valueOf('o'), VfpObj.Sauteed_Alliums_Mushrooms_obj})).setRegistryName(ModInfo.r("decker_cheese_steak")), VfpOid.Decker_Cheesesteak.craftingXp()));
        recipes.register(new DefinedDeckerSandwichRecipe(3, LikeFood.fried_egg, new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(3), new Object[]{"Bm", "K ", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), MinecraftGlue.Items_cooked_mutton, Character.valueOf('m'), "portionMayo"})).setRegistryName(ModInfo.r("decker_mutton_steak")));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new DefinedDeckerSandwichRecipe(6, null, Float.valueOf(LikeFood.meat_pie.saturationModifier()), new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(6), new Object[]{"Bc ", "PH ", "ohp", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('c'), "foodCheese", Character.valueOf('P'), MinecraftGlue.Items_cooked_porkchop, Character.valueOf('H'), VfpObj.Cooked_Salt_Pork_obj, Character.valueOf('o'), VfpObj.Caramelized_Alliums_obj, Character.valueOf('h'), "portionHeatSmall", Character.valueOf('p'), VfpObj.Sandwich_Press_Plate_obj})).setRegistryName(ModInfo.r("decker_cuban")), VfpOid.Decker_Cuban.craftingXp()));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new DefinedDeckerSandwichRecipe(4, null, Float.valueOf(LikeFood.golden_carrot.saturationModifier()), new ShapedOreRecipe(null, (ItemStack)SAMPLES_ARRAY.get(4), new Object[]{"Bm ", "Kee", "vsp", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), "foodRedMeatCooked", Character.valueOf('m'), "foodMashedpotatoes", Character.valueOf('e'), "foodEggFried", Character.valueOf('v'), EdibleCactus.roasted_slice(1), Character.valueOf('s'), "portionSaltSmall", Character.valueOf('p'), VfpObj.Sandwich_Press_Plate_obj})).setRegistryName(ModInfo.r("decker_lumberjack")), VfpOid.Decker_Lumberjack.craftingXp()));
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack empty() {
        return new ItemStack((Item)INSTANCE, 1, 0);
    }

    static final int getIngredientFoodTotal(ItemFood food, ItemStack ingredient) {
        int ingredientTotal = food instanceof VfpPantryItem ? ((VfpPantryItem)food).getAvailableFoodPoints(ingredient) : food.func_150905_g(ingredient);
        return ingredientTotal;
    }

    private static final void addIngredients(ItemStack deckerSandwich, List<IngredientStats> ingredients, int foodTotal, int fpBonus, float saValue, int muscleBoost) {
        Collections.sort(ingredients);
        if (fpBonus > 0) {
            IngredientStats stat = new IngredientStats(fpBonus);
            ingredients.add(stat);
        }
        float saturation = 0.0f;
        StringBuilder sb = new StringBuilder(150);
        for (IngredientStats ingredient : ingredients) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(ingredient._foodDisplayName);
            saturation += (float)ingredient._foodPoints / (float)foodTotal * ingredient._foodSaturation;
        }
        if (saValue > 0.0f) {
            saturation = saValue;
        } else {
            if (saturation < LikeFood.decker.saturationModifier()) {
                saturation = LikeFood.decker.saturationModifier();
            }
            if (muscleBoost > 0) {
                saturation += LikeFood.muscle_boost.saturationModifier() * (float)muscleBoost;
            }
        }
        MinecraftGlue.Instructions.get(deckerSandwich).func_74776_a("FoodSaturation", saturation);
        MinecraftGlue.Instructions.get(deckerSandwich).func_74778_a("UiTip", sb.toString());
    }

    public static final ItemStack create(IItemHandler grid, int meta, int recipeBonus, int maxValue, float saturationValue) {
        Validate.notNull((Object)grid, (String)"A valid non-null IItemHandler is required", (Object[])new Object[0]);
        recipeBonus = MathHelper.func_76125_a((int)recipeBonus, (int)0, (int)LikeFood.beef.healAmount());
        ItemStack deckerSandwich = MinecraftGlue.ItemStacks_NULLSTACK();
        int foodTotal = 0;
        ArrayList<IngredientStats> stats = new ArrayList<IngredientStats>(_MAX_INGREDIENTS + 2);
        int effortBonus = 0;
        int muscleBoost = 0;
        String customName = null;
        int n = grid.getSlots();
        for (int i = 0; i < n; ++i) {
            int ingredientTotal;
            ItemStack ingredient = grid.getStackInSlot(i);
            ItemFood food = FoodPortion.toFood(ingredient);
            if (food == null) {
                if (ingredient.func_77973_b() != VfpObj.Sandwich_Press_Plate_obj || !ingredient.func_82837_s()) continue;
                customName = ingredient.func_82833_r();
                continue;
            }
            if (ingredient.func_77973_b() == VfpObj.Dollop_Muscle_obj) {
                ++muscleBoost;
            }
            if ((ingredientTotal = DeckerSandwiches.getIngredientFoodTotal(food, ingredient)) <= 0) continue;
            foodTotal += ingredientTotal;
            IngredientStats stat = new IngredientStats(ingredient, food);
            stat._foodPoints = ingredientTotal;
            stats.add(stat);
            if (stats.size() == _MAX_INGREDIENTS) break;
        }
        if (foodTotal > 0) {
            if (meta < 0 || meta >= VARIANT_ARRAY.length) {
                meta = 0;
            }
            if (stats.size() > 4) {
                effortBonus = stats.size() - 3;
                foodTotal += effortBonus;
            }
            if (maxValue < 1) {
                maxValue = MAX_TOTAL_FOOD_VALUE_ALLOWED;
            }
            foodTotal = MathHelper.func_76125_a((int)foodTotal, (int)LikeFood.decker.healAmount(), (int)maxValue);
            deckerSandwich = DeckerSandwiches.createMultiuseInstance((Item)INSTANCE, 1, meta, foodTotal + recipeBonus, LikeFood.TYPICAL_FOOD_PORTION.healAmount());
            DeckerSandwiches.addIngredients(deckerSandwich, stats, foodTotal, effortBonus, saturationValue, muscleBoost);
            if (customName != null) {
                deckerSandwich.func_151001_c(customName);
            }
        }
        return deckerSandwich;
    }

    public static final ItemStack create(IItemHandler grid) {
        return DeckerSandwiches.create(grid, 0, 0, -1, 0.0f);
    }

    static final ItemStack marksample(ItemStack stack) {
        stack.func_77983_a(_SAMPLE_TAG, (NBTBase)new NBTTagByte(1));
        return stack;
    }

    public static final ItemStack kingme(IItemHandler grid) {
        return DeckerSandwiches.create(grid, 5, 0, LikeFood.TOWERING_MEGAWICH.healAmount(), 0.0f);
    }

    public static final ItemStack genericDeckerSample() {
        return MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(0));
    }

    public static final NonNullList<ItemStack> definedDeckerSamples() {
        NonNullList samples = NonNullList.func_191196_a();
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(1)));
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(2)));
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(7)));
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(3)));
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(6)));
        samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(4)));
        return samples;
    }

    public static final ItemStack kingmeDeckerSample() {
        return MinecraftGlue.ItemStacks_copyItemStack((ItemStack)SAMPLES_ARRAY.get(5));
    }

    static final NonNullList<ItemStack> deckerSamples() {
        NonNullList samples = NonNullList.func_191196_a();
        for (ItemStack sample : SAMPLES_ARRAY) {
            if (MinecraftGlue.ItemStacks_isEmpty(sample)) continue;
            samples.add((Object)MinecraftGlue.ItemStacks_copyItemStack(sample));
        }
        return samples;
    }

    static {
        _MAX_INGREDIENTS = MinecraftGlue.TABLE_CRAFT_GRID_SIZE();
    }

    static final class FixedIItemHandler
    implements IItemHandler {
        private final ItemStack[] _items;

        FixedIItemHandler(ItemStack ... items) {
            this._items = items;
        }

        public int getSlotLimit(int slot) {
            return MinecraftGlue.MAX_STACK_SIZE();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return this._items.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 0 || slot > this._items.length ? ItemStack.field_190927_a : this._items[slot];
        }
    }

    private static final class IngredientStats
    implements Comparable<IngredientStats> {
        public String _foodDisplayName;
        public int _foodPoints;
        public float _foodSaturation;

        IngredientStats(int foodpoints) {
            this._foodDisplayName = MinecraftGlue.Strings.translate("item.decker.bonus.name");
            this._foodPoints = foodpoints;
            this._foodSaturation = 10.0f / (float)foodpoints;
        }

        IngredientStats(ItemStack stack, ItemFood food) {
            this._foodDisplayName = stack.func_82833_r();
            this._foodSaturation = food.func_150906_h(stack);
        }

        @Override
        public int compareTo(IngredientStats o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return this._foodDisplayName.compareTo(o._foodDisplayName);
        }
    }
}

