/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JJJJar;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.milk.DrinkableBucketOfLiquid;

final class CondensedMilkHelper
extends VfpBuildHelperSupport {
    static final LikeFood sweet_milk_bucket = new LikeFood(-1, LikeFood.milk_bucket, LikeFood.hardened_sugar, LikeFood.hardened_sugar).setSmeltExperience(1.0f);

    CondensedMilkHelper() {
    }

    @Override
    protected String categoryName() {
        return "CondensedMilk";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        DrinkableBucketOfLiquid rawCondensedMilk = DrinkableBucketOfLiquid.newBucket(VfpOid.Bucket_Sweetened_Milk, sweet_milk_bucket);
        MinecraftGlue.Potions.addPotionEffect(rawCondensedMilk, MinecraftGlue.Potion_moveSpeed, 180, 2, 1.0f);
        VfpObj.Bucket_Sweetened_Milk_obj = rawCondensedMilk;
        VfpObj.Bucket_Condensed_Milk_obj = VfpBuilder.newItem(VfpOid.Bucket_Condensed_Milk).func_77642_a(MinecraftGlue.Items_bucket);
        VfpObj.Bucket_Condensed_Milk_obj.func_77625_d(VfpCapacity.FULL_BUCKET_STACK.count());
        VfpObj.Condensed_Milk_Jar_obj = JJJJar.newJar(VfpOid.Condensed_Milk_Jar);
        VfpObj.Fudge_Portion_obj = VfpBuilder.newFood(VfpOid.Fudge_Portion, LikeFood.cookie);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        JJJJar.registerAllUnderDictEntry((JJJJar)VfpObj.Condensed_Milk_Jar_obj, "portionCondensedMilk");
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Bucket_Sweetened_Milk_obj), new Object[]{"sss", "sss", "Mb ", Character.valueOf('s'), FoodPowders.get(FoodPowders.Type.SYRUP, 1), Character.valueOf('M'), "portionMilkLarge", Character.valueOf('b'), MinecraftGlue.Items_bucket}).setRegistryName(ModInfo.r(VfpOid.Bucket_Sweetened_Milk.fmlid())));
        GameRegistry.addSmelting((Item)VfpObj.Bucket_Sweetened_Milk_obj, (ItemStack)new ItemStack(VfpObj.Bucket_Condensed_Milk_obj), (float)sweet_milk_bucket.smeltExperience());
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, JJJJar.full(VfpObj.Condensed_Milk_Jar_obj, 2), new Object[]{"B ", "jj", Character.valueOf('B'), VfpObj.Bucket_Condensed_Milk_obj, Character.valueOf('j'), VfpObj.Empty_Jar_obj}), 1.0f).setRegistryName(ModInfo.r(VfpOid.Condensed_Milk_Jar.fmlid())));
        ItemStack cocoa_powder = FoodPowders.get(FoodPowders.Type.COCOA, 1);
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Fudge_Portion_obj, VfpCapacity.TAFFY_BATCH.count() / 3), new Object[]{"portionCondensedMilk", cocoa_powder, cocoa_powder, cocoa_powder}).setRegistryName(ModInfo.r(VfpOid.Fudge_Portion.fmlid())));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(null, new ItemStack(VfpObj.Fudge_Portion_obj, 2 * VfpCapacity.TAFFY_BATCH.count()), new Object[]{VfpObj.Bucket_Condensed_Milk_obj, cocoa_powder, cocoa_powder, cocoa_powder, cocoa_powder, cocoa_powder, cocoa_powder}).setRegistryName(ModInfo.r(VfpOid.Fudge_Portion.fmlid() + "_batch")), VfpOid.Fudge_Portion.craftingXp()));
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bucket_Sweetened_Milk, VfpObj.Bucket_Sweetened_Milk_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bucket_Condensed_Milk, VfpObj.Bucket_Condensed_Milk_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fudge_Portion, VfpObj.Fudge_Portion_obj);
            JJJJar condensedmilk = (JJJJar)VfpObj.Condensed_Milk_Jar_obj;
            runtime.doRenderSetupOrFail(VfpOid.Condensed_Milk_Jar, condensedmilk, condensedmilk.getUsesRenderNames(), condensedmilk.getUsesRenderMetas());
        }
    }
}

