/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;

public final class UndeadCrunchies
extends VfpPlainItem {
    UndeadCrunchies() {
        super(VfpOid.Undead_Crunchies, false, MinecraftGlue.CreativeTabs_food);
        this.autoregister();
    }

    public EnumAction func_77661_b(ItemStack wotsit) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack wotsit) {
        return 0;
    }

    boolean isInstaEat(EntityPlayer player, ItemStack wotsit) {
        return player.func_70996_bM() || VfpConfig.getInstance().allowInstaEating();
    }

    private void feed(EntityPlayer player, ItemStack wotsit) {
        player.func_71024_bL().func_75122_a(4, 0.3f);
    }

    private void zeroExhaustion(EntityPlayer player, FoodStats food) {
        NBTTagCompound stats = new NBTTagCompound();
        food.func_75117_b(stats);
        int exhaustionLevel = stats.func_74762_e("foodExhaustionLevel");
        if (exhaustionLevel > 0) {
            player.func_71020_j((float)(exhaustionLevel *= -1));
        }
    }

    private void onWotsitConsumed(ItemStack original, ItemStack left, World world, EntityPlayer player) {
        if (MinecraftGlue.isaClientWorld((IBlockAccess)world) || world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        int paymentAmount = MinecraftGlue.PLAYER_ONE_FOOD_LEVEL();
        FoodStats food = player.func_71024_bL();
        float chance = 0.5f;
        boolean hunger = true;
        if (player.func_70996_bM()) {
            if (food.func_75116_a() > paymentAmount) {
                player.func_70691_i(MinecraftGlue.LIVING_ENTITY_ONE_HEALTH_LEVEL());
                this.zeroExhaustion(player, food);
                food.func_75119_b(0.0f);
                food.func_75114_a(food.func_75116_a() - paymentAmount);
                hunger = false;
            } else {
                this.feed(player, original);
            }
        } else {
            this.feed(player, original);
            chance = 0.8f;
        }
        if (hunger && player.func_70681_au().nextFloat() < chance) {
            MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, MinecraftGlue.Potion_hunger, 15, 0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack wotsit = player.func_184586_b(hand);
        wotsit = this.func_77654_b(wotsit, world, (EntityLivingBase)player);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)wotsit);
    }

    public ItemStack func_77654_b(ItemStack wotsit, World world, EntityLivingBase entity) {
        ItemStack original = MinecraftGlue.ItemStacks_copyItemStackSingle(wotsit);
        ItemStack remaining = wotsit;
        EntityPlayer player = MinecraftGlue.getPlayerOrNull((Entity)entity);
        if ((player == null || MinecraftGlue.getPlayerInSurvival(player)) && MinecraftGlue.ItemStacks_decrBy(wotsit, 1)) {
            remaining = MinecraftGlue.ItemStacks_NULLSTACK();
        }
        if (player != null) {
            MinecraftGlue.Effects.playFoodConsumed(world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            this.onWotsitConsumed(original, remaining, world, player);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, original);
            }
        }
        return remaining;
    }
}

