/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.crafting.EmptyBottlesLeftoverShapedOreRecipe;

public final class PigMeats
extends VfpPantryMultiItem {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Pork_Meat_Product, PigMeats.class, "type");
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(VfpOid.Hocks_Raw, LikeFood.uncooked_pork_hocks, VARIANT_SET), new VfpVariant(VfpOid.Hocks_Raw_Salted, LikeFood.uncooked_salt_pork, VARIANT_SET), new VfpVariant(VfpOid.Hocks_Smoked, LikeFood.smoked_pork_hocks, VARIANT_SET), new VfpVariant(VfpOid.Pigtail_Raw, LikeFood.uncooked_pigtail, VARIANT_SET), new VfpVariant(VfpOid.Pigtail_Salted, LikeFood.salt_pigtail, VARIANT_SET), new VfpVariant(VfpOid.Refried_Porkchop_Battered, LikeFood.pork, VARIANT_SET), new VfpVariant(VfpOid.Refried_Porkchop, LikeFood.pork, VARIANT_SET)};
    private static PigMeats INSTANCE;

    public PigMeats(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, true, VARIANT_ARRAY, tab);
    }

    static final PigMeats makeObjects() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Pork_Meat_Product, PigMeats.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (ItemStack)PigMeats.pigtail(1));
        OreDictionary.registerOre((String)"foodProteinCooked", (ItemStack)PigMeats.pork_bites(1));
        OreDictionary.registerOre((String)"foodProteinCooked", (ItemStack)PigMeats.smoked_hocks(1));
    }

    static final void buildRecipes(IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 1, Part.SALTED_HOCK.meta()), new Object[]{"hs", "s ", Character.valueOf('h'), new ItemStack((Item)INSTANCE, 1, Part.HOCK.meta()), Character.valueOf('s'), "ingredientSalt"}).setRegistryName(ModInfo.r(VfpOid.Hocks_Raw_Salted.fmlid())));
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)INSTANCE, 1, Part.SALTED_HOCK.meta()), (ItemStack)new ItemStack((Item)INSTANCE, 1, Part.SMOKED_HOCK.meta()), (float)LikeFood.uncooked_salt_pork.smeltExperience());
        recipes.register(new ShapedOreRecipe(null, new ItemStack((Item)INSTANCE, 1, Part.SALTED_TAIL.meta()), new Object[]{"ts", "s ", Character.valueOf('t'), new ItemStack((Item)INSTANCE, 1, Part.TAIL.meta()), Character.valueOf('s'), "ingredientSalt"}).setRegistryName(ModInfo.r(VfpOid.Pigtail_Salted.fmlid())));
        recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, PigMeats.battered_pork_bites(1), "px", "bw", Character.valueOf('p'), MinecraftGlue.Items_cooked_porkchop, Character.valueOf('x'), "itemFoodCutter", Character.valueOf('b'), FoodPowders.get(FoodPowders.Type.BATTER_MIX, 1), Character.valueOf('w'), "portionWater").setRegistryName(ModInfo.r(VfpOid.Refried_Porkchop_Battered.fmlid())));
        if (MinecraftGlue.ingredientDefinedLooking("foodPorkRoastSmall")) {
            recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, PigMeats.battered_pork_bites(2), "px", "bw", Character.valueOf('p'), "foodPorkRoastSmall", Character.valueOf('x'), "itemFoodCutter", Character.valueOf('b'), FoodPowders.get(FoodPowders.Type.BATTER_MIX, 1), Character.valueOf('w'), "portionWater").setRegistryName(ModInfo.r(VfpOid.Refried_Porkchop_Battered.fmlid() + "_from_smallroast")));
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)INSTANCE, 1, Part.REFRIED_CHOP_RAW.meta()), (ItemStack)new ItemStack((Item)INSTANCE, 1, Part.REFRIED_CHOP.meta()), (float)LikeFood.uncooked_pork.smeltExperience());
    }

    static final ItemStack part(int meta, int amount) {
        ItemStack stack = MinecraftGlue.ItemStacks_NULLSTACK();
        if (INSTANCE != null) {
            stack = new ItemStack((Item)INSTANCE, amount, meta);
        }
        return stack;
    }

    public static final ItemStack pigtail(int amount) {
        return PigMeats.part(Part.TAIL.meta(), amount);
    }

    public static final ItemStack salted_pigtail(int amount) {
        return PigMeats.part(Part.SALTED_TAIL.meta(), amount);
    }

    public static final ItemStack hocks(int amount) {
        return PigMeats.part(Part.HOCK.meta(), amount);
    }

    public static final ItemStack smoked_hocks(int amount) {
        return PigMeats.part(Part.SMOKED_HOCK.meta(), amount);
    }

    public static final ItemStack salted_hocks(int amount) {
        return PigMeats.part(Part.SALTED_HOCK.meta(), amount);
    }

    public static final ItemStack battered_pork_bites(int amount) {
        return PigMeats.part(Part.REFRIED_CHOP_RAW.meta(), amount);
    }

    public static final ItemStack pork_bites(int amount) {
        return PigMeats.part(Part.REFRIED_CHOP.meta(), amount);
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static enum Part {
        HOCK,
        SALTED_HOCK,
        SMOKED_HOCK,
        TAIL,
        SALTED_TAIL,
        REFRIED_CHOP_RAW,
        REFRIED_CHOP;


        public int meta() {
            return this.ordinal();
        }
    }
}

