/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.util.EnumHelper;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class FlintButcherAxe
extends ItemTool
implements VfpAware {
    private static final int MAX_USES = 96;
    private static final float MATERIAL_DAMAGE = 1.0f;
    private static final float TOOL_DAMAGE = 7.0f;
    private static final float MATERIAL_EFFICIENCY = 6.0f;
    private static final Set TOOL_EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{MinecraftGlue.Blocks_pumpkin, MinecraftGlue.Blocks_lit_pumpkin, MinecraftGlue.Blocks_melon_block, MinecraftGlue.Blocks_brown_mushroom_block, MinecraftGlue.Blocks_red_mushroom_block, MinecraftGlue.Blocks_web});
    private static final Material[] TOOL_EFFECTIVE_ON_MATERIALS = new Material[]{MinecraftGlue.Material_web, MinecraftGlue.Material_plants, MinecraftGlue.Material_vine, MinecraftGlue.Material_leaves, MinecraftGlue.Material_gourd, MinecraftGlue.Material_cloth, MinecraftGlue.Material_circuits, MinecraftGlue.Material_cactus, MinecraftGlue.Material_sponge};
    private static Item.ToolMaterial _FlintToolMaterial = EnumHelper.addToolMaterial((String)"FLINTCUTTOOL", (int)2, (int)96, (float)6.0f, (float)1.0f, (int)0).setRepairItem(new ItemStack(MinecraftGlue.Items_flint));
    private final VfpProfile _oid;

    public FlintButcherAxe(VfpProfile oid) {
        super(7.0f, -3.1f, _FlintToolMaterial, TOOL_EFFECTIVE_ON_BLOCKS);
        this._oid = oid;
        this.func_77655_b(oid.fmlid());
        this.setNoRepair();
        this.setHarvestLevel(MinecraftGlue.AXE_TOOLNAME(), MinecraftGlue.STONE_TOOL_LEVEL());
        this.setHarvestLevel(MinecraftGlue.KNIFE_TOOLNAME(), MinecraftGlue.STONE_TOOL_LEVEL());
        this.func_77637_a(VfpUtils.bestTab(oid, MinecraftGlue.CreativeTabs_tools));
    }

    @Override
    public VfpProfile vfplink() {
        return this._oid;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Block block = state.func_177230_c();
        if (block == MinecraftGlue.Blocks_web || block == MinecraftGlue.Blocks_brown_mushroom_block || block == MinecraftGlue.Blocks_red_mushroom_block) {
            return true;
        }
        if (block.getHarvestLevel(state) > MinecraftGlue.STONE_TOOL_LEVEL()) {
            return false;
        }
        Material material = state.func_185904_a();
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return true;
        }
        return super.canHarvestBlock(state, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (block == MinecraftGlue.Blocks_web) {
            return MinecraftGlue.MAX_TOOL_EFFICIENCY();
        }
        if (material == MinecraftGlue.Material_wood && block instanceof BlockHugeMushroom) {
            material = MinecraftGlue.Material_gourd;
        }
        for (Material next : TOOL_EFFECTIVE_ON_MATERIALS) {
            if (!next.equals(material)) continue;
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack original) {
        int damage = original.func_77952_i();
        ItemStack output = MinecraftGlue.ItemStacks_NULLSTACK();
        if (damage < original.func_77958_k()) {
            output = MinecraftGlue.ItemStacks_copyItemStackSingle(original);
            output.func_77964_b(damage + 1);
        }
        return output;
    }

    public final ItemTool autoregister() {
        VfpUtils.autoregisterItem((Item)this, this._oid.fmlid());
        return this;
    }
}

