/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraftforge.fml.common.Optional;
import org.jwaresoftware.mcmods.smarthoppers.apis.ISmartHopperRecipesBuilder;
import org.jwaresoftware.mcmods.smarthoppers.apis.ISmartHoppersRegistrar;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;
import org.jwaresoftware.mcmods.vfp.misc.Sandwiches;
import org.jwaresoftware.mcmods.vfp.misc.VfpCutterItem;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

@Optional.Interface(iface="org.jwaresoftware.mcmods.smarthoppers.apis.ISmartHopperRecipesBuilder", modid="smarthoppers")
public class ImplSMH
implements ISmartHopperRecipesBuilder {
    private void addSuppliesX(ISmartHoppersRegistrar smh, ItemStack output, Object ... inputs) {
        smh.addHopperRecipe1(ISmartHoppersRegistrar.Category.SUPPLIES, null, new ItemStack[]{output}, inputs);
    }

    private void addSuppliesY(ISmartHoppersRegistrar smh, ItemStack output, Item input, Item rui) {
        smh.addHopperRecipe2(ISmartHoppersRegistrar.Category.SUPPLIES, null, new ItemStack[]{new ItemStack(input), new ItemStack(rui)}, output);
    }

    private void addPantryBlock(ISmartHoppersRegistrar smh, ItemStack output, Object ... inputs) {
        smh.addHopperRecipe1(ISmartHoppersRegistrar.Category.STORAGE, null, new ItemStack[]{output}, inputs);
    }

    private void addSupplies(ISmartHoppersRegistrar smh) {
        this.addSuppliesX(smh, new ItemStack(VfpObj.Bit_Pipette_obj), "2#paneGlassColorless", MinecraftGlue.Items_bowl);
        this.addSuppliesX(smh, VfpCutterItem.gold(), "2#itemRawFlint");
        this.addSuppliesY(smh, new ItemStack(VfpObj.Heat_Portion_obj, 64), VfpObj.Bit_Pipette_obj, MinecraftGlue.Items_lava_bucket);
        smh.addHopperRecipe6(ISmartHoppersRegistrar.Category.SUPPLIES, null, new ItemStack(VfpObj.Lava_Sand_Portion_obj), new ItemStack(VfpObj.Heat_Portion_obj, 8));
        this.addSuppliesX(smh, new ItemStack(VfpObj.Heat_Portion_obj, 8), MinecraftGlue.Items_coal, VfpCutterItem.gold());
        this.addSuppliesX(smh, new ItemStack(VfpObj.Heat_Portion_obj, 8), VfpObj.Charcoal_obj, VfpCutterItem.gold());
        this.addSuppliesY(smh, new ItemStack(VfpObj.Water_Portion_obj, 64), VfpObj.Bit_Pipette_obj, MinecraftGlue.Items_water_bucket);
        this.addSuppliesX(smh, VfpObj.Water_Bottle_obj.func_77946_l(), Water.plain(1));
        this.addSuppliesX(smh, new ItemStack(VfpObj.Water_Portion_obj, 8), MinecraftGlue.Items_potion_water);
        this.addSuppliesX(smh, new ItemStack(VfpObj.Milk_Portion_obj, 8), new ItemStack(VfpObj.Water_Portion_obj, 8), FoodPowders.get(FoodPowders.Type.MILK, 1));
        this.addSuppliesX(smh, new ItemStack(VfpObj.Milk_Portion_obj, 8), MilkDrinks.plain(1));
        this.addSuppliesX(smh, new ItemStack(VfpObj.Lava_Sand_Portion_obj, 16), "2#sand", MinecraftGlue.Items_lava_bucket);
        this.addSuppliesX(smh, new ItemStack(MinecraftGlue.Items_blaze_rod), new ItemStack(VfpObj.Lava_Sand_Portion_obj, 2));
        this.addSuppliesX(smh, new ItemStack(VfpObj.Flour_Portion_obj, 2), new ItemStack(MinecraftGlue.Items_wheat, 2), "additiveDrying");
        this.addSuppliesX(smh, new ItemStack(VfpObj.Sticky_Paste_obj, 8), "foodFlour", VfpObj.Water_Portion_obj);
        this.addSuppliesX(smh, new ItemStack(VfpObj.Sticky_Paste_obj, 64), "8#foodFlour", "itemWaterBottle");
        this.addSuppliesX(smh, new ItemStack(VfpObj.Sticky_Paste_obj, 16), "slimeball", VfpObj.Water_Portion_obj);
        this.addSuppliesX(smh, new ItemStack(VfpObj.Empty_Jar_obj, 8), "5#blockGlassColorless", "smuggetIron");
        this.addSuppliesX(smh, new ItemStack(VfpObj.Our_Empty_Bottle_obj, 6), "3#blockGlassColorless", VfpObj.Water_Portion_obj);
        this.addSuppliesX(smh, new ItemStack(VfpObj.Empty_Paper_Bag_obj), "3#paper", VfpObj.Sticky_Paste_obj);
        this.addSuppliesX(smh, new ItemStack(VfpObj.Carton_Side_Blank_obj, 3), "18#paper", "slimeball");
        this.addSuppliesX(smh, new ItemStack(VfpObj.Empty_Carton_obj), new ItemStack(VfpObj.Carton_Side_Blank_obj, 6), "slimeball");
        this.addSuppliesX(smh, Water.plain(4), new ItemStack(VfpObj.Our_Empty_Bottle_obj, 4), MinecraftGlue.Items_water_bucket);
        this.addSuppliesX(smh, Water.plain(4), new ItemStack(VfpObj.Our_Empty_Bottle_obj, 4), MinecraftGlue.Blocks_ice);
        this.addSuppliesX(smh, MilkDrinks.plain(1), FoodPowders.get(FoodPowders.Type.MILK, 1), "itemWaterBottle");
        this.addSuppliesX(smh, MilkDrinks.heavy(1), FoodPowders.get(FoodPowders.Type.CREAM, 1), "itemWaterBottle");
    }

    private void addStorage(ISmartHoppersRegistrar smh) {
        this.addPantryBlock(smh, new ItemStack(VfpObj.Salt_Pantry_Block_obj), new ItemStack(VfpObj.Salt_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.RockSalt_Ingot_obj), new ItemStack(VfpObj.RockSalt_Crystals_obj, 4));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Natron_Ingot_obj), new ItemStack(VfpObj.Natron_Crystals_obj, 4));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Baking_Soda_Pantry_Block_obj), new ItemStack(VfpObj.Baking_Soda_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Flour_Pantry_Block_obj), new ItemStack(VfpObj.Flour_Portion_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Dough_Pantry_Block_obj), DoughBallType.plain(9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Hardened_Sugar_obj), new ItemStack(VfpObj.Sugarcane_obj, 4), "additiveDrying");
        this.addPantryBlock(smh, new ItemStack(VfpObj.Hardened_Sugar_Pantry_Block_obj), new ItemStack(VfpObj.Hardened_Sugar_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Fizzing_Agent_Pantry_Block_obj), new ItemStack(VfpObj.Fizzing_Agent_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Leavening_Agent_Ball_obj), new ItemStack(VfpObj.Leavening_Agent_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Leavening_Agent_Pantry_Block_obj), new ItemStack(VfpObj.Leavening_Agent_Ball_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Drying_Agent_Ball_obj), new ItemStack(VfpObj.Drying_Agent_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Drying_Agent_Pantry_Block_obj), new ItemStack(VfpObj.Drying_Agent_Ball_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Drying_Agent_Unprocessed_Ball_obj), new ItemStack(VfpObj.Drying_Agent_Unprocessed_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Lava_Sand_Pack_obj), new ItemStack(VfpObj.Lava_Sand_Portion_obj, 4));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Lava_Sand_Block_obj), new ItemStack(VfpObj.Lava_Sand_Pack_obj, 9));
        this.addPantryBlock(smh, new ItemStack(VfpObj.Gelatin_Pantry_Block_obj), new ItemStack(VfpObj.Gelatin_Ball_obj, 4));
        Map<ItemStack, ItemStack> bagDefs = BagsOf.autocraftables();
        for (Map.Entry<ItemStack, ItemStack> e : bagDefs.entrySet()) {
            this.addPantryBlock(smh, e.getKey(), e.getValue(), VfpObj.Empty_Paper_Bag_obj);
        }
        this.addPantryBlock(smh, new ItemStack(VfpObj.Ink_Jar_obj), new ItemStack(VfpObj.Ink_Sac_obj.func_77973_b(), 8, VfpObj.Ink_Sac_obj.func_77960_j()), VfpObj.Empty_Jar_obj);
    }

    private void addAutocraftXp(ISmartHoppersRegistrar smh) {
        Map<ItemStack, Float> xpMap = VfpRewards.getExperienceMap();
        for (Map.Entry<ItemStack, Float> e : xpMap.entrySet()) {
            smh.addXpRecipe(ISmartHoppersRegistrar.XpType.CRAFTING, e.getKey(), e.getValue().floatValue());
        }
    }

    private void addEzConcrete(ISmartHoppersRegistrar smh) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.addSuppliesX(smh, new ItemStack(MinecraftGlue.Blocks_concrete, 1, color.func_176765_a()), new ItemStack(MinecraftGlue.Blocks_concrete_powder, 1, color.func_176765_a()), VfpObj.Water_Portion_obj);
        }
    }

    public final void addSmartHopperRecipes(ISmartHoppersRegistrar smh) {
        this.addSupplies(smh);
        this.addStorage(smh);
        this.addAutocraftXp(smh);
        this.addEzConcrete(smh);
    }

    static final void registerLoot(VfpConfig config) {
        if (config.isModLoaded(Integrations.SMH)) {
            ResourceLocation loot_table;
            if (config.includeModDrops()) {
                Item[] raw_meats;
                loot_table = Integrations.SMH.resource("pouches/butcher");
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "misc", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:small_bones", new ItemStack(VfpObj.Small_Bone_obj), 2, 4, 4));
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bag_of_rawsteaks", new ItemStack(VfpObj.Bag_of_obj, 1, 6), 1, 2, 5));
                int i = 0;
                for (Item meat : raw_meats = new Item[]{VfpObj.Llama_Raw_obj, VfpObj.Horse_Raw_obj, VfpObj.Wolf_Raw_obj, VfpObj.Bat_Raw_obj, VfpObj.Wrapped_Egg_obj, VfpObj.Bear_Raw_obj}) {
                    ItemStack loot = new ItemStack(meat);
                    MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:rawmeat_" + i, loot, 2, 4, 14));
                    ++i;
                }
                loot_table = Integrations.SMH.resource("pouches/hunter");
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "special", (LootEntry)new LootEntryTable(new ResourceLocation("vanillafoodpantry", "gameplay/pouches/hunter"), 5, 0, MinecraftGlue.Loot._NOC, "vfp_hunter"));
                loot_table = Integrations.SMH.resource("pouches/fisherman");
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:rawfish_squidd", new ItemStack(VfpObj.Squid_Raw_obj), 2, 3, 6));
                MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:rawfish_guardian", new ItemStack(VfpObj.Guardian_Raw_obj), 2, 3, 3));
            }
            loot_table = Integrations.SMH.resource("pouches/grocer");
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:enriched_bread", Breads.enriched(1), 2, 3, 15));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:carrot_burger", new ItemStack(VfpObj.Carrot_Burger_obj), 2, 3, 13));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:squidd_stick", new ItemStack(VfpObj.Squid_OnStick_obj), 2, 4, 15));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:egg_rolls", DoughBallType.cookedEgg(1), 2, 3, 13));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bag_of_sandwiches", new ItemStack(VfpObj.Bag_of_obj, 1, 273), 1, 2, 10));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "meats", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bag_of_eggpies", new ItemStack(VfpObj.Bag_of_obj, 1, 277), 1, 2, 17));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "misc", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bag_of_raweggs", new ItemStack(VfpObj.Bag_of_obj, 1, 1), 1, 2, 6));
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "misc", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:bag_of_cookies", new ItemStack(VfpObj.Bag_of_obj, 1, 276), 1, 2, 3));
            loot_table = Integrations.SMH.resource("pouches/explorer");
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:sunbutta_sandwich", Sandwiches.sunButterAndApples(1), 2, 4, 6));
            loot_table = Integrations.SMH.resource("pouches/miner");
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", loot_table, "main", (LootEntry)MinecraftGlue.Loot.createEntryItem("vanillafoodpantry:sunbutta_sandwich", Sandwiches.sunButterAndJelly(1), 2, 4, 6));
        }
    }
}

