/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplNAT {
    ImplNAT() {
    }

    private static final ItemStack addItem(String itemid, int meta, String ... oreids) {
        ItemStack out = ItemStack.field_190927_a;
        Item item = Integrations.NaT.item(itemid);
        if (item != null) {
            out = new ItemStack(item, 1, meta);
            for (String oreid : oreids) {
                OreDictionary.registerOre((String)oreid, (ItemStack)out);
            }
        }
        return out;
    }

    private static final ItemStack addEdible(String oreid, int meta) {
        return ImplNAT.addItem("edibles", meta, oreid);
    }

    private static final ItemStack addMaterial(String oreid, int meta) {
        return ImplNAT.addItem("materials", meta, oreid);
    }

    static final void inferFoodDictionary(VfpConfig config, Collection<String> mappings) {
        if (config.isModLoaded(Integrations.NaT)) {
            mappings.add("foodBlueberry");
            mappings.add("foodRaspberry");
            mappings.add("foodBlackberry");
        }
    }

    static final void fixFoodDictionary(VfpConfig config) {
        if (config.isModLoaded(Integrations.NaT) && config.fixNaTFoodDictionary()) {
            ImplNAT.addEdible("foodRaspberry", 2);
            ImplNAT.addEdible("foodBlueberry", 3);
            ImplNAT.addEdible("foodBlackberry", 4);
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.NaT)) {
            ImplNAT.addMaterial("ingredientCereal", 0);
            ImplNAT.addEdible("additivePoisoner", 0);
            ImplNAT.addMaterial("portionHideSmall", 6);
            ImplNAT.addEdible("ingredientCondiment", 9);
            ImplNAT.addItem("overworld_seeds", 0, "greenLitterSeeds", "itemDryableSeed", "additiveScaffold");
            ImplNAT.addItem("overworld_seeds", 1, "greenLitterSeeds", "itemDryableSeed");
            IntegrationsImpl._registerMiscItem(Integrations.NaT, "greenLitterOther", "nether_sapling2", 0);
        }
    }
}

