/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.eggs;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.crafting.EmptyBottlesLeftoverShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;

public final class EggPies
extends VfpPantryMultiItem {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Egg_Pie, EggPies.class, "type");
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant((VfpProfile)VfpOid.Uncooked_Egg_Pie, LikeFood.uncooked_meat_pie, MinecraftGlue.CreativeTabs_materials, VARIANT_SET), new VfpVariant(VfpOid.Egg_Pie, LikeFood.meat_pie, VARIANT_SET), new VfpVariant((VfpProfile)VfpOid.Uncooked_Egg_Pie_Mushroom, LikeFood.uncooked_meat_pie, MinecraftGlue.CreativeTabs_materials, VARIANT_SET), new VfpVariant(VfpOid.Egg_Pie_Mushroom, LikeFood.meat_pie, VARIANT_SET), new VfpVariant((VfpProfile)VfpOid.Uncooked_Egg_Pie_Chicken, LikeFood.uncooked_meat_pie, MinecraftGlue.CreativeTabs_materials, VARIANT_SET), new VfpVariant(VfpOid.Egg_Pie_Chicken, LikeFood.meat_pie, VARIANT_SET), new VfpVariant((VfpProfile)VfpOid.Uncooked_Egg_Pie_Ham, LikeFood.uncooked_meat_pie, MinecraftGlue.CreativeTabs_materials, VARIANT_SET), new VfpVariant(VfpOid.Egg_Pie_Ham, LikeFood.meat_pie, VARIANT_SET), new VfpVariant((VfpProfile)VfpOid.Uncooked_Egg_Pie_Allium, LikeFood.uncooked_meat_pie, MinecraftGlue.CreativeTabs_materials, VARIANT_SET), new VfpVariant(VfpOid.Egg_Pie_Allium, LikeFood.egg_pie, VARIANT_SET)};
    private static final int _PLAIN_COOKED = 1;
    private static final int _CHIKIN_COOKED = 5;
    private static final int _GRANDMAS_COOKED = 7;
    private static EggPies INSTANCE;

    public EggPies(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    public ItemStack createInstance(Item item, int amount, int meta) {
        int addlPoints = meta == 5 || meta == 7 ? LikeFood.egg.healAmount() : 0;
        return EggPies.createMultiuseInstance(item, amount, meta, LikeFood.egg_pie.healAmount() + addlPoints, LikeFood.TYPICAL_FOOD_PORTION.healAmount());
    }

    private static ItemStack newCookedPie(int amount, int meta) {
        return INSTANCE.createInstance((Item)INSTANCE, amount, meta);
    }

    public static final EggPies makeObjects() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Egg_Pie, EggPies.class);
        }
        return INSTANCE;
    }

    public static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (int i = 1; i < VARIANT_ARRAY.length; i += 2) {
                VfpVariant variant = VARIANT_ARRAY[i];
                ItemStack a_pie = EggPies.newCookedPie(1, variant.metadata());
                OreDictionary.registerOre((String)"foodMeatPie", (ItemStack)a_pie);
            }
        }
    }

    private static final void addXEggPie(IForgeRegistry<IRecipe> recipes, int meta, Object x_ingredient, ItemStack uncooked_egg_pie) {
        ItemStack uncooked_x_pie = new ItemStack((Item)INSTANCE, 1, meta);
        VfpRewards.addRewardingCraftItem(uncooked_x_pie, LikeFood.uncooked_meat_pie.craftExperience());
        recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, uncooked_x_pie, "xhx", "eee", "pMd", Character.valueOf('x'), x_ingredient, Character.valueOf('h'), "ingredientCheese", Character.valueOf('e'), "ingredientEgg", Character.valueOf('p'), "foodPotato", Character.valueOf('M'), "portionMilk", Character.valueOf('d'), "foodDough").setRegistryName(ModInfo.r(VARIANT_ARRAY[meta].fmlid())));
        recipes.register(new ShapelessOreRecipe(null, uncooked_x_pie, new Object[]{uncooked_egg_pie, x_ingredient, x_ingredient}).setRegistryName(ModInfo.r(VARIANT_ARRAY[meta].fmlid() + "_compact")));
        GameRegistry.addSmelting((ItemStack)uncooked_x_pie.func_77946_l(), (ItemStack)EggPies.newCookedPie(1, meta + 1), (float)LikeFood.uncooked_meat_pie.smeltExperience());
    }

    public static final void buildRecipes(IForgeRegistry<IRecipe> recipes) {
        ItemStack uncooked_egg_pie = new ItemStack((Item)INSTANCE, 1, 0);
        recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, uncooked_egg_pie, " h ", "eee", "pMd", Character.valueOf('h'), "ingredientCheese", Character.valueOf('e'), "ingredientEgg", Character.valueOf('p'), "foodPotato", Character.valueOf('M'), "portionMilk", Character.valueOf('d'), "foodDough").setRegistryName(ModInfo.r(VfpOid.Uncooked_Egg_Pie.fmlid())));
        GameRegistry.addSmelting((ItemStack)uncooked_egg_pie.func_77946_l(), (ItemStack)EggPies.plain(), (float)LikeFood.uncooked_meat_pie.smeltExperience());
        VfpRewards.addRewardingCraftItem(uncooked_egg_pie, LikeFood.uncooked_meat_pie.craftExperience());
        EggPies.addXEggPie(recipes, 2, "ingredientMushroom", uncooked_egg_pie);
        EggPies.addXEggPie(recipes, 4, MeatPortions.get(PackagedFood.CHICKEN), uncooked_egg_pie);
        EggPies.addXEggPie(recipes, 6, VfpObj.Portion_Ham_obj, uncooked_egg_pie);
        EggPies.addXEggPie(recipes, 8, VfpObj.Caramelized_Alliums_obj, uncooked_egg_pie);
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack plain() {
        return EggPies.newCookedPie(1, VARIANT_ARRAY[1].metadata());
    }

    public static final ItemStack grandmas() {
        return EggPies.newCookedPie(1, VARIANT_ARRAY[7].metadata());
    }
}

