/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.core.crafting.LegacyShapelessOreRecipe;

public final class EmptyBottlesLeftoverShapelessOreRecipe
extends LegacyShapelessOreRecipe {
    private final boolean _keepJars;
    private final boolean _keepBowls;

    public EmptyBottlesLeftoverShapelessOreRecipe(boolean keepJars, boolean keepBowls, @Nonnull ItemStack result, Object ... recipe) {
        super(null, result, recipe);
        this._keepJars = keepJars;
        this._keepBowls = keepBowls;
    }

    public EmptyBottlesLeftoverShapelessOreRecipe(boolean keepJars, @Nonnull ItemStack result, Object ... recipe) {
        this(keepJars, false, result, recipe);
    }

    EmptyBottlesLeftoverShapelessOreRecipe(boolean keepJars, boolean keepBowls, ShapelessOreRecipe template) {
        super(null, (NonNullList<Ingredient>)template.func_192400_c(), template.func_77571_b());
        this._keepJars = keepJars;
        this._keepBowls = keepBowls;
    }

    @Nullable
    private static final ItemStack getEmptyContainer(ItemStack stack, boolean keepJars, boolean keepBowls) {
        ItemStack emptybottle = null;
        Item item = stack.func_77973_b();
        if (item == VfpObj.MilkDrinks_obj || item == VfpObj.Our_Water_Bottle_obj) {
            emptybottle = new ItemStack(VfpObj.Our_Empty_Bottle_obj);
        } else if (item == MinecraftGlue.Items_potion_water) {
            emptybottle = new ItemStack(MinecraftGlue.Items_empty_bottle);
        } else if (keepJars && (item == VfpObj.Empty_Jar_obj || item == VfpObj.Dark_Empty_Jar_obj || MinecraftGlue.RID.matches(stack, "itemEmptyJar"))) {
            emptybottle = MinecraftGlue.ItemStacks_copyItemStackSingle(stack);
        } else if (keepBowls && (item == MinecraftGlue.Items_bowl || MinecraftGlue.RID.matches(stack, "bowlWood"))) {
            emptybottle = MinecraftGlue.ItemStacks_copyItemStackSingle(stack);
        }
        return emptybottle;
    }

    static final NonNullList<ItemStack> getRemainingIncludingEmptyGlassBottles(InventoryCrafting grid, boolean keepJars, boolean keepBowls) {
        NonNullList out = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)grid);
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack empties = null;
            if (!((ItemStack)out.get(i)).func_190926_b() || (empties = EmptyBottlesLeftoverShapelessOreRecipe.getEmptyContainer(grid.func_70301_a(i), keepJars, keepBowls)) == null) continue;
            out.set(i, (Object)empties);
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return EmptyBottlesLeftoverShapelessOreRecipe.getRemainingIncludingEmptyGlassBottles(grid, this._keepJars, this._keepBowls);
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            boolean keepJars = JsonUtils.func_151209_a((JsonObject)json, (String)"keepjars", (boolean)false);
            boolean keepBowls = JsonUtils.func_151209_a((JsonObject)json, (String)"keepbowls", (boolean)false);
            return new EmptyBottlesLeftoverShapelessOreRecipe(keepJars, keepBowls, impl);
        }
    }
}

