/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import toughasnails.api.thirst.IDrink;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails")
public abstract class VfpLiquidNonFood
extends VfpPlainItem
implements IDrink {
    protected boolean _instaDrinkingAllowed = false;
    protected final LiquidType _drinkType;

    protected VfpLiquidNonFood(VfpProfile oid, LiquidType type, CreativeTabs tab) {
        super(oid, false, tab);
        this._drinkType = type;
        this.func_77625_d(this.getItemMaxStackSize().count());
        ItemStack c = this.getNewEmptyContainer();
        if (!c.func_190926_b()) {
            this.func_77642_a(c.func_77973_b());
        }
    }

    protected VfpLiquidNonFood(VfpProfile oid, LiquidType type) {
        this(oid, type, null);
    }

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Optional.Method(modid="toughasnails")
    public final int getThirst() {
        return this._drinkType.getThirst();
    }

    @Optional.Method(modid="toughasnails")
    public final float getHydration() {
        return this._drinkType.getHydration();
    }

    @Optional.Method(modid="toughasnails")
    public final float getPoisonChance() {
        return 0.0f;
    }

    protected boolean isDrinkable(ItemStack drinking) {
        return !drinking.func_190926_b();
    }

    protected boolean isInstaDrink(ItemStack drink) {
        return this.isDrinkable(drink) && this._instaDrinkingAllowed && VfpConfig.getInstance().allowInstaEating();
    }

    protected int getRegularItemUseDuration() {
        return MinecraftGlue.DEFAULT_FOOD_CONSUME_DURATION();
    }

    public int func_77626_a(ItemStack drink) {
        return this.isInstaDrink(drink) ? 0 : this.getRegularItemUseDuration();
    }

    protected EnumAction getRegularItemUseAction() {
        return EnumAction.DRINK;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isInstaDrink(stack) || !this.isDrinkable(stack) ? EnumAction.NONE : this.getRegularItemUseAction();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        EnumActionResult result;
        ItemStack helditem = player.func_184586_b(hand);
        EnumActionResult enumActionResult = result = this.isDrinkable(helditem) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        if (result == EnumActionResult.SUCCESS && this.isInstaDrink(helditem)) {
            helditem = this.func_77654_b(helditem, world, (EntityLivingBase)player);
        } else {
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((EnumActionResult)result, (Object)helditem);
    }

    public ItemStack func_77654_b(ItemStack drink, World world, EntityLivingBase entity) {
        ItemStack original = MinecraftGlue.ItemStacks_copyItemStackSingle(drink);
        ItemStack remaining = drink;
        EntityPlayer player = MinecraftGlue.getPlayerOrNull((Entity)entity);
        if ((player == null || MinecraftGlue.getPlayerInSurvival(player)) && MinecraftGlue.ItemStacks_decrBy(drink, 1)) {
            remaining = MinecraftGlue.ItemStacks_NULLSTACK();
        }
        if (player != null) {
            MinecraftGlue.Effects.playFoodConsumed(world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            this.onDrinkDrunk(original, drink, world, player);
            remaining = this.onItemConsumedFully(original, remaining, world, player);
        }
        return remaining;
    }

    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (MinecraftGlue.isaServerWorld((IBlockAccess)world)) {
            this.applyPotionEffectsOnDrunk(original, remaining, world, player);
        }
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, original);
        }
    }

    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        return VfpPantryItem.returnOrDropContainer(remaining, player, this.getNewEmptyContainer());
    }

    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            TANHelper.quenchThirst(player, this.getThirst(), this.getHydration(), this.getPoisonChance());
        }
    }
}

