/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.TANHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import toughasnails.api.thirst.IDrink;

@Optional.Interface(iface="toughasnails.api.thirst.IDrink", modid="toughasnails")
public abstract class VfpLiquidMultiItem
extends VfpPantryMultiItem
implements IMultiColored,
IDrink {
    protected final VfpVariantSet _variantset;
    protected final LiquidType _drinkType;

    protected static final synchronized boolean register(Ingredient flavor, List<Ingredient> variant_flavors, String typename) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for %s", (Object[])new Object[]{typename});
        boolean added = false;
        if (!variant_flavors.contains(flavor)) {
            added = variant_flavors.add(flavor);
        }
        return added;
    }

    protected VfpLiquidMultiItem(VfpProfile oid, VfpVariantSet set, LiquidType type, CreativeTabs tab) {
        super(oid, false, set.variants(), tab, true);
        this._variantset = set;
        this._drinkType = type;
        this.func_77625_d(this.getItemMaxStackSize().count());
        this.completeInit(oid);
    }

    protected abstract ItemStack getNewEmptyContainer();

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int tintIndex) {
        Integer colorValue = null;
        if (type != null) {
            int num;
            if (ingredient instanceof FoodColor) {
                int num2 = ((FoodColor)((Object)ingredient)).color(ingredient.recipeitem());
                if (num2 != 0xF1F1F1) {
                    colorValue = num2;
                }
            } else if (ingredient.recipeitem().func_77973_b() instanceof FoodColor) {
                int num3 = ((FoodColor)ingredient.recipeitem().func_77973_b()).color(ingredient.recipeitem());
                if (num3 != 0xF1F1F1) {
                    colorValue = num3;
                }
            } else if (ingredient.recipeitem().func_77973_b() instanceof IMultiColored && (num = ((IMultiColored)ingredient.recipeitem().func_77973_b()).getColorFrom(ingredient.recipeitem(), tintIndex)) != 0xFFFFFF) {
                colorValue = num;
            }
        }
        return colorValue;
    }

    protected int getColorFromMeta(int meta, int tintIndex) {
        Integer colorValue;
        Ingredient ingredient;
        int color_num = 0;
        VfpVariant type = this._variantset.lookup(meta);
        if (type != null && (ingredient = type.datadata(Ingredient.class)) != null && (colorValue = this.getVariantColorFromMeta(type, ingredient, tintIndex)) != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    @Override
    public int getColorFrom(ItemStack stack, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0 && (color_num = this.getColorFromMeta(stack.func_77960_j(), tintIndex)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        String name = MinecraftGlue.I18N_ITEM_KEY_PREFIX() + this._variantset.typeName();
        if (variant != null) {
            name = name + "_" + variant.datadata(Named.class).name();
        }
        return name;
    }

    @Override
    @Optional.Method(modid="toughasnails")
    protected boolean canConsume(ItemStack held, World world, EntityPlayer player) {
        boolean consume = super.canConsume(held, world, player);
        if (!consume && MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            IReheatable t_cap;
            boolean bl = consume = this.getThirstQuenched(held) > 0 && TANHelper.isThirsty(world, player);
            if (!consume && (t_cap = this.getTemperatureChangeCapability(held)) != null && t_cap.hasBonusTemperature(held)) {
                consume = TANHelper.isPlayerAtExtremeTemperature(player, t_cap.isCooled(held));
            }
        }
        return consume;
    }

    @Override
    @Optional.Method(modid="toughasnails")
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.isEnabled()) {
            TANHelper.quenchThirst(player, this.getThirstQuenched(original), this.getHydrationAdded(original), this.getThirstTriggerChance(original));
            IReheatable t_cap = this.getTemperatureChangeCapability(original);
            if (t_cap != null && t_cap.hasBonusTemperature(original)) {
                int ongoingTimesecs = t_cap.getBonusTemperatureTimeLeftForApply(original, -1);
                int modifier = this.getTemperatureModifier(original);
                if (t_cap.isHeated(original)) {
                    TANHelper.warmIfCold(player, modifier, ongoingTimesecs);
                } else {
                    TANHelper.coolIfHot(player, modifier, ongoingTimesecs);
                }
            }
        }
    }

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        return VfpLiquidMultiItem.returnOrDropContainer(remaining, player, this.getNewEmptyContainer());
    }

    @Optional.Method(modid="toughasnails")
    public final int getThirst() {
        return this.getThirstQuenched(ItemStack.field_190927_a);
    }

    public int getThirstQuenched(ItemStack liquid) {
        return this._drinkType.getThirst();
    }

    @Optional.Method(modid="toughasnails")
    public final float getHydration() {
        return this.getHydrationAdded(ItemStack.field_190927_a);
    }

    public float getHydrationAdded(ItemStack liquid) {
        return this._drinkType.getHydration();
    }

    @Optional.Method(modid="toughasnails")
    public final float getPoisonChance() {
        return this.getThirstTriggerChance(ItemStack.field_190927_a);
    }

    public float getThirstTriggerChance(ItemStack liquid) {
        return 0.0f;
    }

    public int getTemperatureModifier(ItemStack liquid) {
        return 1;
    }

    protected static abstract class VariantSet
    extends VfpVariantSet.ByMapInstance {
        protected VariantSet(VfpProfile typedef, Class<?> marker) {
            super(typedef, marker, "flavor");
        }

        @Override
        public String[] renderNames() {
            return new String[]{"vanillafoodpantry:" + this.typeName()};
        }
    }
}

