/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;

public class Ingredient
implements Named {
    private final String _name;
    private final int _meta;
    private final int _multiplier;
    private int _mask;
    private MinecraftGlue.ItemStackDef _itemdef;
    private final boolean _isBlock;
    private final boolean _isGroup;

    public Ingredient(String name, int id, MinecraftGlue.ItemStackDef itemdef) {
        this(name, id, itemdef, 1);
    }

    public Ingredient(String name, int id, MinecraftGlue.ItemStackDef itemDef, int multiplier) {
        boolean check = !StringUtils.isBlank((CharSequence)name) && itemDef != null && !itemDef.isEmpty();
        Validate.isTrue((boolean)check, (String)"Valid parameters for any ingredient are name and ingredient definition", (Object[])new Object[0]);
        this._meta = id;
        this._name = name;
        this._itemdef = itemDef;
        this._multiplier = Math.min(MinecraftGlue.TABLE_CRAFT_GRID_SIZE(), multiplier);
        this._isBlock = itemDef.item instanceof ItemBlock;
        this._isGroup = DictionaryNameItemAdaptor.isa(itemDef);
    }

    public Ingredient(String name, int id, String dictKey) {
        this(name, id, new MinecraftGlue.ItemStackDef(new DictionaryNameItemAdaptor(dictKey)));
    }

    public Ingredient(String name, int id, String dictKey, int amount, int multiplier) {
        this(name, id, new MinecraftGlue.ItemStackDef(new DictionaryNameItemAdaptor(dictKey), amount), multiplier);
    }

    public final int id() {
        return this._meta;
    }

    @Override
    @Nonnull
    public final String name() {
        return this._name;
    }

    @Nonnull
    public final ItemStack recipeitem() {
        return this._itemdef.get();
    }

    public final int multiplier() {
        return this._multiplier;
    }

    public final boolean isClassifier() {
        return this._isGroup;
    }

    @Nullable
    public final String recipeitemName() {
        return this._isGroup ? ((DictionaryNameItemAdaptor)this._itemdef.item).dictionaryName() : null;
    }

    public final int attributes() {
        return this._mask;
    }

    public final void attributes(int newmask) {
        this._mask = newmask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Ingredient) {
            boolean match;
            Ingredient other = (Ingredient)o;
            Item mine = this._itemdef.item;
            Item theirs = other._itemdef.item;
            boolean bl = match = this._isBlock == other._isBlock && this._isGroup == other._isGroup && this._itemdef.meta == other._itemdef.meta && this._itemdef.item.func_77658_a().equals(other._itemdef.item.func_77658_a());
            if (match) {
                match = this._isGroup ? this.recipeitemName().equals(other.recipeitemName()) : (this._isBlock ? ((ItemBlock)mine).func_179223_d().getClass().equals(((ItemBlock)theirs).func_179223_d().getClass()) : mine.getClass().equals(theirs.getClass()));
            }
        }
        return false;
    }

    public int hashCode() {
        return 32 * this._meta + this._itemdef.item.func_77658_a().hashCode();
    }

    public boolean isEnabled() {
        return !this._itemdef.isEmpty();
    }

    public boolean isPlaceholder() {
        return this._itemdef == MinecraftGlue.ItemStackDef.UNUSED || "unused".equals(this.recipeitemName());
    }

    public String toString() {
        if (this.isPlaceholder()) {
            return "*PLACEHOLDER*";
        }
        String enabled = this.isEnabled() ? "Y|" : "N|";
        return enabled + this._name + "@" + this._meta + "[grp=" + this._isGroup + "/x" + this._multiplier + ",itm=" + this._itemdef + "]";
    }
}

