/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;

public final class BaggedFoodDef {
    private final String _type_id;
    private final int _meta_offset;
    private List<PackagedFood> _exclusions;

    public BaggedFoodDef(String typeid, int meta_offset, PackagedFood ... exclusions) {
        Validate.notBlank((CharSequence)typeid, (String)"A non-blank type name is required", (Object[])new Object[0]);
        this._type_id = typeid;
        this._meta_offset = meta_offset;
        if (exclusions != null && exclusions.length > 0) {
            this._exclusions = Arrays.asList(exclusions);
        }
    }

    public BaggedFoodDef(PackagedFood.Type type, PackagedFood ... exclusions) {
        this(type.name(), type.shared_metaoffset(), exclusions);
    }

    public String groupId() {
        return this._type_id;
    }

    public int groupMetaoffset() {
        return this._meta_offset;
    }

    public List<PackagedFood> groupExclusions() {
        return this._exclusions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BaggedFoodDef) {
            BaggedFoodDef other = (BaggedFoodDef)o;
            return this.groupId().equals(other.groupId()) && this.groupMetaoffset() == other.groupMetaoffset();
        }
        return false;
    }

    public int hashCode() {
        return 32 * this._meta_offset + this._type_id.hashCode();
    }

    public static final BaggedFoodDef forMeat(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.meat, exclusions);
    }

    public static final BaggedFoodDef forCookedMeat(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.cooked_meat, exclusions);
    }

    public static final BaggedFoodDef forVegetables(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.vegetable, exclusions);
    }

    public static final BaggedFoodDef forBakery(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.bakery, exclusions);
    }

    public static final BaggedFoodDef forFruit(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.fruit, exclusions);
    }

    public static final BaggedFoodDef forMiscellaneous(PackagedFood ... exclusions) {
        return new BaggedFoodDef(PackagedFood.Type.general, exclusions);
    }
}

