/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.RockSaltOreWorldGenerator;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpOreBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

final class SaltBuildHelper
extends VfpBuildHelperSupport {
    private static final String _ANY_SALT = "dustSalt";

    SaltBuildHelper() {
    }

    @Override
    protected String categoryName() {
        return "Salt";
    }

    @Override
    public void installEventBusHandlers(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.isOreGenerationEnabled()) {
            RockSaltOreWorldGenerator wg = RockSaltOreWorldGenerator.create(config);
            GameRegistry.registerWorldGenerator((IWorldGenerator)wg, (int)wg.importance());
        }
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpObj.RockSalt_Crystals_obj = VfpBuilder.newItem(VfpOid.Rock_Salt_Crystals);
        VfpObj.RockSalt_Ingot_obj = VfpBuilder.newStorageItem(VfpOid.Rock_Salt_Ingot);
        VfpObj.RockSalt_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Rock_Salt_Ore, MinecraftGlue.Blocks_stone, new MinecraftGlue.ItemStackDef(VfpObj.RockSalt_Crystals_obj, 3), 2).autoregister();
        VfpObj.Nether_RockSalt_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Rock_Salt_Ore_Nether, MinecraftGlue.Blocks_netherrack, new MinecraftGlue.ItemStackDef(VfpObj.RockSalt_Crystals_obj, 4), 3).autoregister();
        VfpObj.Salt_obj = VfpBuilder.newAdditive(VfpOid.Salt);
        VfpObj.Portion_Salt_obj = VfpBuilder.newAdditive(VfpOid.Portion_Salt);
        VfpObj.Salt_Pantry_Block_obj = new VfpPantryBlock((VfpProfile)VfpOid.Salt_Pantry_Block, MinecraftGlue.Blocks_sand, VfpObj.Salt_obj).autoregister();
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"oreRockSalt", (Block)VfpObj.RockSalt_OreBlock_obj);
        OreDictionary.registerOre((String)"oreSalt", (Block)VfpObj.RockSalt_OreBlock_obj);
        OreDictionary.registerOre((String)"oreRockSalt", (Block)VfpObj.Nether_RockSalt_OreBlock_obj);
        OreDictionary.registerOre((String)"oreSalt", (Block)VfpObj.Nether_RockSalt_OreBlock_obj);
        OreDictionary.registerOre((String)"oreTrona", (Block)VfpObj.Trona_OreBlock_obj);
        OreDictionary.registerOre((String)"ingotRockSalt", (Item)VfpObj.RockSalt_Crystals_obj);
        OreDictionary.registerOre((String)"ingotSalt", (Item)VfpObj.RockSalt_Crystals_obj);
        OreDictionary.registerOre((String)"gemSalt", (Item)VfpObj.RockSalt_Crystals_obj);
        OreDictionary.registerOre((String)"ingredientSalt", (Item)VfpObj.Salt_obj);
        OreDictionary.registerOre((String)"portionSalt", (Item)VfpObj.Salt_obj);
        OreDictionary.registerOre((String)"portionSaltSmall", (Item)VfpObj.Portion_Salt_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Portion_Salt_obj);
        OreDictionary.registerOre((String)_ANY_SALT, (Item)VfpObj.Salt_obj);
        OreDictionary.registerOre((String)"dustRockSalt", (Item)VfpObj.Salt_obj);
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        VfpBuilder.autorecipe(recipes, "Salt", VfpOid.Rock_Salt_Ingot.fmlid(), VfpCapacity.PORTABLE, (Object)VfpObj.RockSalt_Crystals_obj, VfpObj.RockSalt_Ingot_obj, VfpObj.RockSalt_Crystals_obj);
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Salt_obj, VfpCapacity.CRYSTAL_BATCH.count()), new Object[]{VfpObj.RockSalt_Crystals_obj}).setRegistryName(ModInfo.r("salt_from_crystals")));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Portion_Salt_obj, VfpCapacity.PINCHES_BATCH.count()), new Object[]{_ANY_SALT, VfpObj.Bit_Pipette_obj}).setRegistryName(ModInfo.r("bit_salt")));
        if (!runtime.getConfig().isSuperCompatibilityMode()) {
            recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Portion_Salt_obj, VfpCapacity.PINCHES_BATCH.count()), new Object[]{_ANY_SALT}).setRegistryName("bit_salt_no_measure"));
        } else {
            recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Portion_Salt_obj, VfpCapacity.PINCHES_BATCH.count()), new Object[]{VfpObj.Salt_obj}).setRegistryName("bit_salt_no_measure"));
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Salt_obj), new Object[]{"xxx", "xxx", Character.valueOf('x'), VfpObj.Portion_Salt_obj}).setRegistryName(ModInfo.r("salt_from_pinches")));
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Salt_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Salt_obj, VfpObj.Salt_Pantry_Block_obj, VfpObj.Salt_obj);
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Crystals, VfpObj.RockSalt_Crystals_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ingot, VfpObj.RockSalt_Ingot_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ore, VfpObj.RockSalt_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Rock_Salt_Ore_Nether, VfpObj.Nether_RockSalt_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Salt, VfpObj.Salt_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Salt, VfpObj.Portion_Salt_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Salt_Pantry_Block, VfpObj.Salt_Pantry_Block_obj);
        }
    }
}

