/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.BucketOfPotableWater;
import org.jwaresoftware.mcmods.vfp.agents.CarbonationBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.agents.LavaSandFuelHandler;
import org.jwaresoftware.mcmods.vfp.agents.RennetBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.SaltBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.StarterYeast;
import org.jwaresoftware.mcmods.vfp.agents.WaterBottlesBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelper;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.milk.MilkPortion;

public final class AgentsBuildHelper
extends VfpBuildHelperSupport {
    private WaterBottlesBuildHelper _waterHelper = new WaterBottlesBuildHelper();
    private RennetBuildHelper _rennetHelper = new RennetBuildHelper();
    private SaltBuildHelper _saltHelper = new SaltBuildHelper();
    private CarbonationBuildHelper _carbHelper = new CarbonationBuildHelper();
    private JuJuExtensions _jujuHelper = new JuJuExtensions();
    private final VfpBuildHelper[] _subBuilders = new VfpBuildHelper[5];

    public AgentsBuildHelper() {
        this._subBuilders[0] = this._waterHelper;
        this._subBuilders[1] = this._saltHelper;
        this._subBuilders[2] = this._carbHelper;
        this._subBuilders[3] = this._rennetHelper;
        this._subBuilders[4] = this._jujuHelper;
    }

    @Override
    protected String categoryName() {
        return "Additives";
    }

    @Override
    public void installEventBusHandlers(VfpRuntime runtime) {
        MinecraftForge.EVENT_BUS.register((Object)new LavaSandFuelHandler());
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.installEventBusHandlers(runtime);
        }
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        VfpObj.Bit_Pipette_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Bit_Pipette);
        VfpObj.Water_Portion_obj = VfpBuilder.newAdditive(VfpOid.Water_Portion, MinecraftGlue.CreativeTabs_materials);
        VfpObj.Portion_Sugar_obj = VfpBuilder.newAdditive(VfpOid.Portion_Sugar);
        VfpObj.Dried_Seeds_obj = VfpBuilder.newItem(VfpOid.Dried_Seeds);
        VfpObj.Starter_Yeast_obj = new StarterYeast();
        VfpObj.Leavening_Agent_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent);
        VfpObj.Leavening_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent_Ball);
        VfpObj.Leavening_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Ball_obj);
        VfpObj.Drying_Agent_Unprocessed_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed);
        VfpObj.Drying_Agent_Unprocessed_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed_Ball);
        VfpObj.Drying_Agent_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent);
        VfpObj.Drying_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Ball);
        VfpObj.Drying_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Ball_obj);
        this._saltHelper.makeObjects(runtime);
        this._carbHelper.makeObjects(runtime);
        VfpObj.Milk_Portion_obj = new MilkPortion();
        this._rennetHelper.makeObjects(runtime);
        VfpObj.Heat_Portion_obj = VfpBuilder.newMisc(VfpOid.Heat_Portion);
        VfpObj.Lava_Sand_Portion_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand_Portion);
        VfpObj.Lava_Sand_Pack_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand_Pack);
        VfpObj.Lava_Sand_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Lava_Sand_Block, MinecraftGlue.Blocks_sand, VfpObj.Lava_Sand_Pack_obj, MinecraftGlue.CreativeTabs_misc);
        this.identifyOtherFoodPowders(runtime);
        this._waterHelper.makeObjects(runtime);
        VfpObj.Bucket_Potable_Water_obj = new BucketOfPotableWater();
        this._jujuHelper.makeObjects(runtime);
        VfpObj.Fizzing_Agent_obj = VfpBuilder.newAdditive(VfpOid.Fizzing_Agent);
        VfpObj.Fizzing_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Fizzing_Agent_Pantry_Block, MinecraftGlue.Blocks_sand, VfpObj.Fizzing_Agent_obj, null);
        VfpObj.Whisk_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Whisk);
        VfpObj.Fermenting_Bucket_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Fermenting_Bucket);
        VfpObj.FoodPowders_obj = FoodPowders.makeObjects(config);
    }

    @Override
    public void makeObjectsFinalPass(VfpRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.makeObjectsFinalPass(runtime);
        }
    }

    @Override
    public void linkObjects(VfpRuntime runtime) {
        VfpObj.Lava_Sand_BlockItem_obj = Item.func_150898_a((Block)VfpObj.Lava_Sand_Block_obj);
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkObjects(runtime);
        }
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkLikeFoods(runtime);
        }
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        Item[] seeds;
        VfpConfig config = runtime.getConfig();
        OreDictionary.registerOre((String)"itemBitMeasure", (Item)VfpObj.Bit_Pipette_obj);
        OreDictionary.registerOre((String)"additiveScaffold", (Item)VfpObj.Dried_Seeds_obj);
        OreDictionary.registerOre((String)"itemWhisk", (Item)VfpObj.Whisk_obj);
        OreDictionary.registerOre((String)"portionSugarSmall", (Item)VfpObj.Portion_Sugar_obj);
        OreDictionary.registerOre((String)"itemFermentingBucket", (Item)VfpObj.Fermenting_Bucket_obj);
        OreDictionary.registerOre((String)"foodApple", (Item)MinecraftGlue.Items_apple);
        OreDictionary.registerOre((String)"portionHeatSmall", (Item)VfpObj.Heat_Portion_obj);
        OreDictionary.registerOre((String)"portionHeat", (Item)VfpObj.Lava_Sand_Portion_obj);
        OreDictionary.registerOre((String)"portionHeatLarge", (Item)MinecraftGlue.Items_lava_bucket);
        OreDictionary.registerOre((String)"dustLava", (Item)VfpObj.Lava_Sand_Portion_obj);
        OreDictionary.registerOre((String)"portionWaterSmall", (Item)VfpObj.Water_Portion_obj);
        if (config.enablePotionWaterAsPlainWater()) {
            OreDictionary.registerOre((String)"portionWater", (ItemStack)VfpObj.Water_Bottle_obj);
        }
        OreDictionary.registerOre((String)"portionWaterLarge", (Item)VfpObj.Water_Bucket_obj);
        if (!config.useTreatedWaterRecipes()) {
            OreDictionary.registerOre((String)"portionPotableWaterLarge", (Item)VfpObj.Water_Bucket_obj);
        }
        OreDictionary.registerOre((String)"portionWaterLarge", (Item)VfpObj.Bucket_Potable_Water_obj);
        OreDictionary.registerOre((String)"portionPotableWaterLarge", (Item)VfpObj.Bucket_Potable_Water_obj);
        OreDictionary.registerOre((String)"itemEmptyBottle", (Item)VfpObj.Empty_Bottle_obj);
        if (config.enablePotionWaterAsPlainWater()) {
            OreDictionary.registerOre((String)"itemWaterBottle", (ItemStack)VfpObj.Water_Bottle_obj);
        }
        OreDictionary.registerOre((String)"foodCurative", (Item)VfpObj.Milk_Portion_obj);
        OreDictionary.registerOre((String)"foodCurative", (Item)VfpObj.Bucket_Potable_Water_obj);
        OreDictionary.registerOre((String)"additiveFermenting", (ItemStack)new ItemStack(VfpObj.Starter_Yeast_obj, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"additiveFermenting", (Block)MinecraftGlue.GameBlocks.brown_mushroom);
        OreDictionary.registerOre((String)"additiveFermenting", (Block)MinecraftGlue.GameBlocks.red_mushroom);
        for (Item seed : seeds = new Item[]{MinecraftGlue.Items_wheat_seeds, MinecraftGlue.Items_melon_seeds, MinecraftGlue.Items_pumpkin_seeds, MinecraftGlue.Items_beetroot_seeds}) {
            OreDictionary.registerOre((String)"additiveScaffold", (Item)seed);
            OreDictionary.registerOre((String)"itemDryableSeed", (Item)seed);
        }
        OreDictionary.registerOre((String)"blockLeaveningAgent", (Block)VfpObj.Leavening_Agent_Pantry_Block_obj);
        OreDictionary.registerOre((String)"ingotLeaveningAgent", (Item)VfpObj.Leavening_Agent_Ball_obj);
        OreDictionary.registerOre((String)"additiveLeavening", (Item)VfpObj.Leavening_Agent_obj);
        OreDictionary.registerOre((String)"itemPoisonousPotato", (Item)MinecraftGlue.Items_poisonous_potato);
        OreDictionary.registerOre((String)"additiveDrying", (Item)VfpObj.Drying_Agent_obj);
        OreDictionary.registerOre((String)"ingotDryingAgent", (Item)VfpObj.Drying_Agent_Ball_obj);
        OreDictionary.registerOre((String)"blockDryingAgent", (Block)VfpObj.Drying_Agent_Pantry_Block_obj);
        OreDictionary.registerOre((String)"bowlWood", (Item)MinecraftGlue.Items_bowl);
        OreDictionary.registerOre((String)"ingredientSweetener", (Item)VfpObj.Sugar_obj);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)MinecraftGlue.Items_egg);
        OreDictionary.registerOre((String)"foodSimpleEgg", (Item)MinecraftGlue.Items_egg);
        IntegrationsImpl.registerAsBread(MinecraftGlue.Items_bread, true, new String[0]);
        OreDictionary.registerOre((String)"ingredientInk", (ItemStack)VfpObj.Ink_Sac_obj);
        OreDictionary.registerOre((String)"foodBush", (ItemStack)new ItemStack(MinecraftGlue.Blocks_tallgrass, 1, BlockTallGrass.EnumType.FERN.func_177044_a()));
        OreDictionary.registerOre((String)"foodBush", (ItemStack)new ItemStack(MinecraftGlue.Blocks_tallgrass, 1, BlockTallGrass.EnumType.GRASS.func_177044_a()));
        OreDictionary.registerOre((String)"foodBeets", (Item)MinecraftGlue.Items_beetroot);
        OreDictionary.registerOre((String)"foodPotato", (Item)MinecraftGlue.Items_baked_potato);
        OreDictionary.registerOre((String)"foodCarrot", (Item)MinecraftGlue.Items_carrot);
        OreDictionary.registerOre((String)"rottenflesh", (Item)MinecraftGlue.Items_rotten_flesh);
        OreDictionary.registerOre((String)"ingredientCereal", (Item)MinecraftGlue.Items_wheat);
        OreDictionary.registerOre((String)"foodCookie", (Item)MinecraftGlue.Items_cookie);
        OreDictionary.registerOre((String)"ingredientChowderMain", (ItemStack)LikeFood.salmon.sample(1));
        OreDictionary.registerOre((String)"ingredientChowderFill", (ItemStack)LikeFood.fish.sample(1));
        OreDictionary.registerOre((String)"ingredientFishSausageMain", (ItemStack)LikeFood.uncooked_fish.sample(1));
        OreDictionary.registerOre((String)"portionMilkSmall", (Item)VfpObj.Milk_Portion_obj);
        OreDictionary.registerOre((String)"portionMilkLarge", (Item)MinecraftGlue.Items_milk_bucket);
        ItemStack arrow = new ItemStack(MinecraftGlue.Items_arrow, 1, Short.MAX_VALUE);
        if (!arrow.func_190926_b()) {
            OreDictionary.registerOre((String)"arrow", (ItemStack)arrow);
        }
        OreDictionary.registerOre((String)"itemWaterTreatment", (Item)VfpObj.Heat_Portion_obj);
        FoodPowders.addDictionaryEntries();
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addDictionaryEntries(runtime);
        }
        this.identifyDictMushrooms(config);
        this.identifyDictMeats(config);
        this.identifyDictKebabItems(config);
        this.identifyDictEdibleFlowers(config);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.addLootEntries(runtime);
        }
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        int additive_count = VfpCapacity.ADDITIVE_BATCH.count();
        VfpRewards.addRewardingCraftItem(new ItemStack(VfpObj.Leavening_Agent_obj, additive_count), VfpOid.Leavening_Agent.craftingXp());
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Leavening_Agent_Ball.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Leavening_Agent_obj, VfpObj.Leavening_Agent_Ball_obj, VfpObj.Leavening_Agent_obj);
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Leavening_Agent_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Leavening_Agent_Ball_obj, VfpObj.Leavening_Agent_Pantry_Block_obj, VfpObj.Leavening_Agent_Ball_obj);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Drying_Agent_Unprocessed_obj, additive_count), new Object[]{"xx", "pc", Character.valueOf('x'), "additiveScaffold", Character.valueOf('p'), "itemPoisonousPotato", Character.valueOf('c'), "blockCactus"}).setRegistryName(ModInfo.r(VfpOid.Drying_Agent_Unprocessed.fmlid())), VfpOid.Drying_Agent_Unprocessed.craftingXp()));
        GameRegistry.addSmelting((Item)VfpObj.Drying_Agent_Unprocessed_obj, (ItemStack)new ItemStack(VfpObj.Drying_Agent_obj), (float)LikeFood.seed.smeltExperience());
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Drying_Agent_Ball.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_obj, VfpObj.Drying_Agent_Ball_obj, VfpObj.Drying_Agent_obj);
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Drying_Agent_Pantry_Block.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_Ball_obj, VfpObj.Drying_Agent_Pantry_Block_obj, VfpObj.Drying_Agent_Ball_obj);
        VfpBuilder.autorecipe(recipes, this.categoryName(), VfpOid.Drying_Agent_Unprocessed_Ball.fmlid(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_Unprocessed_obj, VfpObj.Drying_Agent_Unprocessed_Ball_obj, VfpObj.Drying_Agent_Unprocessed_obj);
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Fermenting_Bucket_obj), new Object[]{"gg", "gb", Character.valueOf('g'), "blockGlass", Character.valueOf('b'), "itemEmptyBucket"}).setRegistryName(ModInfo.r(VfpOid.Fermenting_Bucket.fmlid())));
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Whisk_obj), new Object[]{"is", " i", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "smuggetIron"}).setRegistryName(ModInfo.r(VfpOid.Whisk.fmlid())));
        this._waterHelper.buildRecipes(runtime, recipes);
        this._saltHelper.buildRecipes(runtime, recipes);
        this._carbHelper.buildRecipes(runtime, recipes);
        FoodPowders.buildRecipes(runtime, recipes);
        this._rennetHelper.buildRecipes(runtime, recipes);
        this._jujuHelper.buildRecipes(runtime, recipes);
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bit_Pipette, VfpObj.Bit_Pipette_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dried_Seeds, VfpObj.Dried_Seeds_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fermenting_Bucket, VfpObj.Fermenting_Bucket_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Whisk, VfpObj.Whisk_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Heat_Portion, VfpObj.Heat_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Portion, VfpObj.Lava_Sand_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Pack, VfpObj.Lava_Sand_Pack_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Block, VfpObj.Lava_Sand_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Water_Portion, VfpObj.Water_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bucket_Potable_Water, VfpObj.Bucket_Potable_Water_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Milk_Portion, VfpObj.Milk_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Sugar, VfpObj.Portion_Sugar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Starter_Yeast, VfpObj.Starter_Yeast_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent, VfpObj.Leavening_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent_Ball, VfpObj.Leavening_Agent_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Unprocessed, VfpObj.Drying_Agent_Unprocessed_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent, VfpObj.Drying_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Ball, VfpObj.Drying_Agent_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Unprocessed_Ball, VfpObj.Drying_Agent_Unprocessed_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fizzing_Agent, VfpObj.Fizzing_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fizzing_Agent_Pantry_Block, VfpObj.Fizzing_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.FoodPowder, VfpObj.FoodPowders_obj, FoodPowders.variants());
        }
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.linkRenderModels(runtime);
        }
    }

    @Override
    public void sendApiMessages(FMLStateEvent state, VfpRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.sendApiMessages(state, runtime);
        }
    }

    @Override
    public void finish(VfpRuntime runtime) {
        for (VfpBuildHelper subBuilder : this._subBuilders) {
            subBuilder.finish(runtime);
        }
    }

    private void identifyOtherFoodPowders(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        boolean debug = config.isDebugMode();
        if (debug) {
            for (FoodPowders.Type fpt_ : FoodPowders.Type.orderedValues()) {
                runtime.getLog().info("ALL(a) FoodPowder: '{}'", (Object)fpt_);
            }
        }
        FoodPowders.Type.checkReservedPowderCount();
        IntegrationsImpl.registerFoodPowders(runtime);
        if (debug) {
            for (FoodPowders.Type fpt_ : FoodPowders.Type.orderedValues()) {
                runtime.getLog().info("ALL(b) FoodPowder: '{}'", (Object)fpt_);
            }
        }
    }

    private void identifyDictMushrooms(VfpConfig config) {
        OreDictionary.registerOre((String)"foodMushroom", (Block)MinecraftGlue.GameBlocks.brown_mushroom);
        OreDictionary.registerOre((String)"ingredientMushroom", (Block)MinecraftGlue.GameBlocks.brown_mushroom);
        OreDictionary.registerOre((String)"foodMushroom", (Block)MinecraftGlue.GameBlocks.red_mushroom);
        OreDictionary.registerOre((String)"ingredientMushroom", (Block)MinecraftGlue.GameBlocks.red_mushroom);
        IntegrationsImpl.registerDictMushrooms(config);
    }

    private void identifyDictMeats(VfpConfig config) {
        OreDictionary.registerOre((String)"foodChicken", (Item)MinecraftGlue.Items_chicken);
        OreDictionary.registerOre((String)"foodChickenCooked", (Item)MinecraftGlue.Items_cooked_chicken);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)MinecraftGlue.Items_beef);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodBeefsteakCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)MinecraftGlue.Items_mutton);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)MinecraftGlue.Items_cooked_mutton);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_mutton);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_rabbit);
        IntegrationsImpl.registerDictRedMeat(config);
    }

    private void identifyDictKebabItems(VfpConfig config) {
        OreDictionary.registerOre((String)"ingredientKebabFill", (Block)MinecraftGlue.GameBlocks.brown_mushroom);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Block)MinecraftGlue.GameBlocks.red_mushroom);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_carrot);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_potato);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_apple);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_beetroot);
        OreDictionary.registerOre((String)"ingredientKebabFruit", (Item)MinecraftGlue.Items_apple);
        OreDictionary.registerOre((String)"ingredientKebabFruit", (Item)MinecraftGlue.Items_melon);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)MinecraftGlue.Items_potato);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)MinecraftGlue.Items_baked_potato);
        IntegrationsImpl.registerDictKebabItems(config);
    }

    private void identifyDictEdibleFlowers(VfpConfig config) {
        BlockFlower.EnumFlowerType[] selections = new BlockFlower.EnumFlowerType[]{BlockFlower.EnumFlowerType.RED_TULIP, BlockFlower.EnumFlowerType.ORANGE_TULIP, BlockFlower.EnumFlowerType.WHITE_TULIP, BlockFlower.EnumFlowerType.PINK_TULIP};
        for (int i = 0; i < selections.length; ++i) {
            ItemStack flower = new ItemStack(MinecraftGlue.Blocks_red_flower, 1, selections[i].func_176968_b());
            OreDictionary.registerOre((String)"foodFlower", (ItemStack)flower);
            OreDictionary.registerOre((String)"ingredientFlower", (ItemStack)flower);
        }
        OreDictionary.registerOre((String)"foodRoseFlower", (ItemStack)VfpObj.Rose_plant_obj);
        OreDictionary.registerOre((String)"ingredientRoseFlower", (ItemStack)VfpObj.Rose_plant_obj);
        IntegrationsImpl.registerDictEdibleFlowers(config);
    }
}

