/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe.extreme;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import morph.avaritia.recipe.extreme.ExtremeRecipeBase;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class ExtremeShapedRecipe
extends ExtremeRecipeBase {
    private static final int MAX_CRAFT_GRID_WIDTH = 9;
    private static final int MAX_CRAFT_GRID_HEIGHT = 9;
    protected ItemStack output = ItemStack.field_190927_a;
    protected NonNullList<Ingredient> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public ExtremeShapedRecipe(@Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        this.output = result.func_77946_l();
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.mirrored = primer.mirrored;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public boolean matches(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 9 - this.width; ++x) {
            for (int y = 0; y <= 9 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                }
                if (target.apply(inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    @Override
    public boolean isShapedRecipe() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static ExtremeShapedRecipe fromJson(JsonContext context, JsonObject json) {
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = new HashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new ExtremeShapedRecipe(result, primer);
    }
}

