/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe.compressor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import morph.avaritia.recipe.compressor.ICompressorRecipe;
import morph.avaritia.util.CompressorBalanceCalculator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompressorRecipe
extends IForgeRegistryEntry.Impl<ICompressorRecipe>
implements ICompressorRecipe {
    protected ItemStack result;
    protected int cost;
    protected boolean absolute;
    protected List<Ingredient> ingredients;

    public CompressorRecipe(ItemStack result, int cost, boolean absolute, List<Ingredient> ingredients) {
        this.result = result;
        this.cost = cost;
        this.absolute = absolute;
        this.ingredients = ingredients;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public int getCost() {
        if (this.absolute) {
            return this.cost;
        }
        return CompressorBalanceCalculator.balanceCost(this.cost);
    }

    @Override
    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public static ICompressorRecipe fromJson(JsonContext context, JsonObject json) {
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        int cost = JsonUtils.func_151203_m((JsonObject)json, (String)"cost");
        boolean absolute = JsonUtils.func_151209_a((JsonObject)json, (String)"absolute", (boolean)false);
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            Ingredient i = CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context);
            if (i == Ingredient.field_193370_a) continue;
            ings.add((Object)i);
        }
        if (ings.isEmpty()) {
            return null;
        }
        return new CompressorRecipe(result, cost, absolute, (List<Ingredient>)ings);
    }
}

