/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item;

import codechicken.lib.item.ItemMultiType;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.util.TransformUtils;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import morph.avaritia.api.IHaloRenderItem;
import morph.avaritia.api.registration.IModelRegister;
import morph.avaritia.client.render.item.HaloRenderItem;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.init.AvaritiaTextures;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemResource
extends ItemMultiType
implements IHaloRenderItem,
IModelRegister {
    protected HashMap<Integer, EnumRarity> rarityMap = new HashMap();

    public ItemResource(CreativeTabs tab, String registryName) {
        super(tab, registryName);
    }

    public ItemStack registerItem(String name, EnumRarity rarity) {
        ItemStack stack = super.registerItem(name);
        for (Map.Entry entry : this.names.entrySet()) {
            if (!((String)entry.getValue()).equals(name)) continue;
            this.rarityMap.put((Integer)entry.getKey(), rarity);
            break;
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int meta = stack.func_77952_i();
        if (meta != 0) {
            tooltip.add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)("tooltip." + this.func_77667_c(stack) + ".desc")));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldDrawHalo(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta >= 2 && meta <= 6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getHaloTexture(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta == 2 || meta == 3 || meta == 4) {
            return AvaritiaTextures.HALO_NOISE;
        }
        return AvaritiaTextures.HALO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHaloSize(ItemStack stack) {
        int meta = stack.func_77952_i();
        switch (meta) {
            case 5: 
            case 6: {
                return 10;
            }
        }
        return 8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldDrawPulse(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta == 5 || meta == 6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHaloColour(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta == 2) {
            return 0x33FFFFFF;
        }
        if (meta == 3) {
            return 0x4DFFFFFF;
        }
        if (meta == 4) {
            return -1711276033;
        }
        return -16777216;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        int meta = stack.func_77952_i();
        return meta == 5 || meta == 6;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        return meta == 5 || meta == 6 ? new EntityImmortalItem(world, location, itemstack) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        HashSet toRegister = Sets.newHashSet((Object[])new Integer[]{2, 3, 4, 5, 6});
        Iterator iterator = toRegister.iterator();
        while (iterator.hasNext()) {
            int meta = (Integer)iterator.next();
            String name = (String)this.names.get(meta);
            ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "type=" + name);
            HaloRenderItem wrapped = new HaloRenderItem((IModelState)TransformUtils.DEFAULT_ITEM, modelRegistry -> (IBakedModel)modelRegistry.func_82594_a((Object)location));
            ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)wrapped);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarityMap.getOrDefault(stack.func_77960_j(), super.func_77613_e(stack));
    }
}

