/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item;

import codechicken.lib.util.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import morph.avaritia.init.ModItems;
import morph.avaritia.util.ItemStackWrapper;
import morph.avaritia.util.ToolHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMatterCluster
extends Item {
    protected static Random randy = new Random();
    public static final String MAINTAG = "clusteritems";
    public static final String LISTTAG = "items";
    public static final String ITEMTAG = "item";
    public static final String COUNTTAG = "count";
    public static final String MAINCOUNTTAG = "total";
    public static int CAPACITY = 4096;

    public ItemMatterCluster() {
        this.func_77625_d(1);
        this.func_77655_b("avaritia:matter_cluster");
        this.setRegistryName("matter_cluster");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(MAINTAG)) {
            return;
        }
        NBTTagCompound clustertag = stack.func_77978_p().func_74775_l(MAINTAG);
        tooltip.add(clustertag.func_74762_e(MAINCOUNTTAG) + "/" + CAPACITY + " " + I18n.func_135052_a((String)"tooltip.matter_cluster.counter", (Object[])new Object[0]));
        tooltip.add("");
        if (GuiScreen.func_146272_n()) {
            NBTTagList list = clustertag.func_150295_c(LISTTAG, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ItemStack countstack = new ItemStack(tag.func_74775_l(ITEMTAG));
                int count = tag.func_74762_e(COUNTTAG);
                tooltip.add(countstack.func_77973_b().func_77613_e((ItemStack)countstack).field_77937_e + countstack.func_82833_r() + TextFormatting.GRAY + " x " + count);
            }
        } else {
            tooltip.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tooltip.matter_cluster.desc", (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.matter_cluster.desc2", (Object[])new Object[0]));
        }
    }

    public static List<ItemStack> makeClusters(Set<ItemStack> input) {
        Map<ItemStackWrapper, Integer> items = ToolHelper.collateMatterCluster(input);
        ArrayList<ItemStack> clusters = new ArrayList<ItemStack>();
        ArrayList<Map.Entry<ItemStackWrapper, Integer>> itemlist = new ArrayList<Map.Entry<ItemStackWrapper, Integer>>();
        itemlist.addAll(items.entrySet());
        int currentTotal = 0;
        HashMap<ItemStackWrapper, Integer> currentItems = new HashMap<ItemStackWrapper, Integer>();
        while (!itemlist.isEmpty()) {
            Map.Entry e = (Map.Entry)itemlist.get(0);
            ItemStackWrapper wrap = (ItemStackWrapper)e.getKey();
            int wrapcount = (Integer)e.getValue();
            int count = Math.min(CAPACITY - currentTotal, wrapcount);
            if (!currentItems.containsKey(e.getKey())) {
                currentItems.put(wrap, count);
            } else {
                currentItems.put(wrap, (Integer)currentItems.get(wrap) + count);
            }
            currentTotal += count;
            e.setValue(wrapcount - count);
            if ((Integer)e.getValue() == 0) {
                itemlist.remove(0);
            }
            if (currentTotal != CAPACITY) continue;
            ItemStack cluster = ItemMatterCluster.makeCluster(currentItems);
            clusters.add(cluster);
            currentTotal = 0;
            currentItems = new HashMap();
        }
        if (currentTotal > 0) {
            ItemStack cluster = ItemMatterCluster.makeCluster(currentItems);
            clusters.add(cluster);
        }
        return clusters;
    }

    public static ItemStack makeCluster(Map<ItemStackWrapper, Integer> input) {
        ItemStack cluster = new ItemStack((Item)ModItems.matter_cluster);
        int total = 0;
        for (int num : input.values()) {
            total += num;
        }
        ItemMatterCluster.setClusterData(cluster, input, total);
        return cluster;
    }

    public static Map<ItemStackWrapper, Integer> getClusterData(ItemStack cluster) {
        if (!cluster.func_77942_o() || !cluster.func_77978_p().func_74764_b(MAINTAG)) {
            return null;
        }
        NBTTagCompound tag = cluster.func_77978_p().func_74775_l(MAINTAG);
        NBTTagList list = tag.func_150295_c(LISTTAG, 10);
        HashMap<ItemStackWrapper, Integer> data = new HashMap<ItemStackWrapper, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            ItemStackWrapper wrap = new ItemStackWrapper(new ItemStack(entry.func_74775_l(ITEMTAG)));
            int count = entry.func_74762_e(COUNTTAG);
            data.put(wrap, count);
        }
        return data;
    }

    public static int getClusterSize(ItemStack cluster) {
        if (!cluster.func_77942_o() || !cluster.func_77978_p().func_74764_b(MAINTAG)) {
            return 0;
        }
        return cluster.func_77978_p().func_74775_l(MAINTAG).func_74762_e(MAINCOUNTTAG);
    }

    public static void setClusterData(ItemStack stack, Map<ItemStackWrapper, Integer> data, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound clustertag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ItemStackWrapper, Integer> entry : data.entrySet()) {
            NBTTagCompound itemtag = new NBTTagCompound();
            itemtag.func_74782_a(ITEMTAG, (NBTBase)entry.getKey().stack.func_77955_b(new NBTTagCompound()));
            itemtag.func_74768_a(COUNTTAG, entry.getValue().intValue());
            list.func_74742_a((NBTBase)itemtag);
        }
        clustertag.func_74782_a(LISTTAG, (NBTBase)list);
        clustertag.func_74768_a(MAINCOUNTTAG, count);
        stack.func_77978_p().func_74782_a(MAINTAG, (NBTBase)clustertag);
    }

    public static void mergeClusters(ItemStack donor, ItemStack recipient) {
        int count;
        int recipientcount;
        int donorcount = ItemMatterCluster.getClusterSize(donor);
        if (donorcount == 0 || donorcount == CAPACITY || recipientcount == CAPACITY) {
            return;
        }
        Map<ItemStackWrapper, Integer> donordata = ItemMatterCluster.getClusterData(donor);
        Map<ItemStackWrapper, Integer> recipientdata = ItemMatterCluster.getClusterData(recipient);
        ArrayList<Map.Entry<ItemStackWrapper, Integer>> datalist = new ArrayList<Map.Entry<ItemStackWrapper, Integer>>();
        datalist.addAll(donordata.entrySet());
        for (recipientcount = ItemMatterCluster.getClusterSize(recipient); recipientcount < CAPACITY && donorcount > 0; donorcount -= count, recipientcount += count) {
            Map.Entry e = (Map.Entry)datalist.get(0);
            ItemStackWrapper wrap = (ItemStackWrapper)e.getKey();
            int wrapcount = (Integer)e.getValue();
            count = Math.min(CAPACITY - recipientcount, wrapcount);
            if (!recipientdata.containsKey(wrap)) {
                recipientdata.put(wrap, count);
            } else {
                recipientdata.put(wrap, recipientdata.get(wrap) + count);
            }
            if (wrapcount - count > 0) {
                e.setValue(wrapcount - count);
                continue;
            }
            donordata.remove(wrap);
            datalist.remove(0);
        }
        ItemMatterCluster.setClusterData(recipient, recipientdata, recipientcount);
        if (donorcount > 0) {
            ItemMatterCluster.setClusterData(donor, donordata, donorcount);
        } else {
            donor.func_77982_d(null);
            donor.func_190920_e(0);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            List<ItemStack> drops = ToolHelper.collateMatterClusterContents(ItemMatterCluster.getClusterData(stack));
            for (ItemStack drop : drops) {
                ItemUtils.dropItem((World)world, (BlockPos)player.func_180425_c(), (ItemStack)drop);
            }
        }
        stack.func_190920_e(0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

