/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import codechicken.lib.configuration.ConfigFile;
import codechicken.lib.configuration.ConfigTag;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.util.Lumberjack;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static final String CONFIG_VERSION = "1.0";
    public static ConfigFile config;
    private static String current_version;
    public static boolean endStone;
    public static boolean bedrockBreaker;
    public static boolean boringFood;
    public static boolean fracturedOres;
    public static boolean verboseCraftTweekerLogging;
    public static boolean copper;
    public static boolean tin;
    public static boolean silver;
    public static boolean lead;
    public static boolean steel;
    public static boolean nickel;
    public static boolean fluxed;
    public static boolean enderium;
    public static boolean darkSteel;
    public static boolean platinum;
    public static boolean iridium;
    public static int modifier;
    public static int multiplier;

    public static void init(File file) {
        config = new ConfigFile(file, false);
        try {
            config.load();
        }
        catch (Exception e) {
            Lumberjack.big(Level.WARN, "Found forge based Avaritia config, the config will be wiped and defaults will be used.", new Object[0]);
            config.clear();
            current_version = CONFIG_VERSION;
        }
        config.setTagVersion(CONFIG_VERSION);
        ConfigHandler.loadConfig();
    }

    public static void loadConfig() {
        ConfigTag general = config.getTag("general");
        general.setComment("General configuration of Avaritia components.");
        ConfigTag tag = general.getTag("use_end_stone");
        tag.setComment("Disable to remove end stone out of some of Avaritia's recipes.");
        endStone = tag.setDefaultBoolean(true).getBoolean();
        tag = general.getTag("break_bedrock");
        tag.setComment("Disable if you don't want the World Breaker to break unbreakable blocks.");
        bedrockBreaker = tag.setDefaultBoolean(true).getBoolean();
        tag = general.getTag("boring_food");
        tag.setComment("Enable to keep the Ultimate Stew and Cosmic Meatballs from grabbing more ingredients.");
        boringFood = tag.setDefaultBoolean(false).getBoolean();
        tag = general.getTag("fractured_ores");
        tag.setComment("Enable if you don't have RotaryCraft installed and want some buggy fractured ores.");
        fracturedOres = tag.setDefaultBoolean(false).getBoolean();
        tag = general.getTag("aoe_trash_defaults");
        tag.setComment("These are the OreDictionary ID's for default trashed items. These are synced from the server to the client. And will appear as defaults on the client also. Clients can override these, They are defaults not Musts.");
        Object[] defaults = new String[]{"dirt", "sand", "gravel", "cobblestone", "netherrack", "stoneGranite", "stoneDiorite", "stoneAndesite"};
        tag.setDefaultStringList((List)Lists.newArrayList((Object[])defaults));
        AvaritiaEventHandler.defaultTrashOres.clear();
        AvaritiaEventHandler.defaultTrashOres.addAll(tag.getStringList());
        tag = general.getTag("verbose_craft_tweaker_logging");
        tag.setComment("Enables verbose logging of actions taken on avaritia by CraftTweaker scripts. Only effects CraftTweakers script log file.");
        verboseCraftTweekerLogging = tag.setDefaultBoolean(false).getBoolean();
        ConfigTag materials = config.getTag("materials");
        materials.setComment("Disable to stop using that material in recipes. Useful if a mod adds unobtainable placeholder ores.");
        copper = materials.getTag("copper").setDefaultBoolean(true).getBoolean();
        tin = materials.getTag("tin").setDefaultBoolean(true).getBoolean();
        silver = materials.getTag("silver").setDefaultBoolean(true).getBoolean();
        lead = materials.getTag("lead").setDefaultBoolean(true).getBoolean();
        nickel = materials.getTag("nickel").setDefaultBoolean(true).getBoolean();
        steel = materials.getTag("steel").setDefaultBoolean(true).getBoolean();
        fluxed = materials.getTag("fluxed").setDefaultBoolean(true).getBoolean();
        enderium = materials.getTag("enderium").setDefaultBoolean(true).getBoolean();
        darkSteel = materials.getTag("dark_steel").setDefaultBoolean(true).getBoolean();
        platinum = materials.getTag("platinum").setDefaultBoolean(false).getBoolean();
        iridium = materials.getTag("iridium").setDefaultBoolean(false).getBoolean();
        ConfigTag balance = config.getTag("balance");
        balance.setComment("Balance modifications for the Compressor.");
        tag = balance.getTag("cost_modifier");
        tag.setComment("Added to the existing modifier to make prices more expensive or cheaper. Can be negative.");
        modifier = tag.setDefaultInt(0).getInt();
        tag = balance.getTag("cost_multiplier");
        tag.setComment("Added to the existing multiplier to make prices more expensive or cheaper. Can be negative.");
        multiplier = tag.setDefaultInt(0).getInt();
        config.save();
    }

    static {
        endStone = true;
        bedrockBreaker = true;
        boringFood = false;
        fracturedOres = false;
        verboseCraftTweekerLogging = false;
        copper = true;
        tin = true;
        silver = true;
        lead = true;
        steel = true;
        nickel = true;
        fluxed = true;
        enderium = true;
        darkSteel = true;
        platinum = true;
        iridium = true;
        modifier = 0;
        multiplier = 0;
    }
}

