/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import morph.avaritia.handler.AEOCrawlerTask;
import morph.avaritia.handler.ConfigHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemArmorInfinity;
import morph.avaritia.item.ItemFracturedOre;
import morph.avaritia.item.ItemMatterCluster;
import morph.avaritia.item.tools.ItemSwordInfinity;
import morph.avaritia.util.TextUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class AvaritiaEventHandler {
    private static Map<Integer, List<AEOCrawlerTask>> crawlerTasks = new HashMap<Integer, List<AEOCrawlerTask>>();
    private static Set<ItemStack> capturedDrops = new LinkedHashSet<ItemStack>();
    private static boolean doItemCapture = false;
    public static final Set<String> defaultTrashOres = new HashSet<String>();

    public static boolean isInfinite(EntityPlayer player) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !(stack = player.func_184582_a(slot)).func_190926_b() && stack.func_77973_b() instanceof ItemArmorInfinity) continue;
            return false;
        }
        return true;
    }

    public static void enableItemCapture() {
        doItemCapture = true;
    }

    public static void stopItemCapture() {
        doItemCapture = false;
    }

    public static boolean isItemCaptureEnabled() {
        return doItemCapture;
    }

    public static Set<ItemStack> getCapturedDrops() {
        LinkedHashSet<ItemStack> dropsCopy = new LinkedHashSet<ItemStack>(capturedDrops);
        capturedDrops.clear();
        return dropsCopy;
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (doItemCapture && event.getEntity() instanceof EntityItem) {
            ItemStack stack = ((EntityItem)event.getEntity()).func_92059_d();
            capturedDrops.add(stack);
            event.setCanceled(true);
        }
    }

    public static AEOCrawlerTask startCrawlerTask(World world, EntityPlayer player, ItemStack stack, BlockPos coords, int steps, boolean leaves, boolean force, Set<BlockPos> posChecked) {
        AEOCrawlerTask swapper = new AEOCrawlerTask(world, player, stack, coords, steps, leaves, force, posChecked);
        int dim = world.field_73011_w.getDimension();
        if (!crawlerTasks.containsKey(dim)) {
            crawlerTasks.put(dim, new ArrayList());
        }
        crawlerTasks.get(dim).add(swapper);
        return swapper;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.phase == TickEvent.Phase.END && crawlerTasks.containsKey(dim = event.world.field_73011_w.getDimension())) {
            List<AEOCrawlerTask> swappers = crawlerTasks.get(dim);
            ArrayList<AEOCrawlerTask> swappersSafe = new ArrayList<AEOCrawlerTask>(swappers);
            swappers.clear();
            for (AEOCrawlerTask s : swappersSafe) {
                if (s == null) continue;
                s.tick();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerMine(PlayerInteractEvent.LeftClickBlock event) {
        if (!ConfigHandler.bedrockBreaker || event.getFace() == null || event.getWorld().field_72995_K || event.getItemStack().func_190926_b() || event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        if (state.func_185887_b(world, event.getPos()) <= -1.0f && event.getItemStack().func_77973_b() == ModItems.infinity_pickaxe && (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f) && event.getItemStack().func_77978_p() != null && event.getItemStack().func_77978_p().func_74767_n("hammer")) {
            ModItems.infinity_pickaxe.onBlockStartBreak(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND), event.getPos(), event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void handleExtraLuck(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack mainHand = event.getHarvester().func_184586_b(EnumHand.MAIN_HAND);
        if (!mainHand.func_190926_b() && mainHand.func_77973_b() == ModItems.infinity_pickaxe) {
            AvaritiaEventHandler.applyLuck(event, 4);
        }
    }

    public static void applyLuck(BlockEvent.HarvestDropsEvent event, int multiplier) {
        if (event.getState().func_185904_a() == Material.field_151576_e) {
            ArrayList<ItemStack> adds = new ArrayList<ItemStack>();
            ArrayList<ItemStack> removals = new ArrayList<ItemStack>();
            block0: for (ItemStack drop : event.getDrops()) {
                int[] iDs;
                if (drop.func_77973_b() != Item.func_150898_a((Block)event.getState().func_177230_c()) && !(drop.func_77973_b() instanceof ItemBlock)) {
                    drop.func_190920_e(Math.min(drop.func_190916_E() * multiplier, drop.func_77976_d()));
                    continue;
                }
                if (!ConfigHandler.fracturedOres || drop.func_77973_b() != Item.func_150898_a((Block)event.getState().func_177230_c())) continue;
                ItemFracturedOre fracturedOre = ModItems.fractured_ore;
                for (int id : iDs = OreDictionary.getOreIDs((ItemStack)drop)) {
                    String oreName = OreDictionary.getOreName((int)id);
                    if (!oreName.startsWith("ore")) continue;
                    adds.add(fracturedOre.getStackForOre(drop, Math.min(drop.func_190916_E() * (multiplier + 1), drop.func_77976_d())));
                    removals.add(drop);
                    continue block0;
                }
            }
            event.getDrops().addAll(adds);
            event.getDrops().removeAll(removals);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ItemSwordInfinity) {
            for (int x = 0; x < event.getToolTip().size(); ++x) {
                if (!((String)event.getToolTip().get(x)).contains(I18n.func_74838_a((String)"attribute.name.generic.attackDamage")) && !((String)event.getToolTip().get(x)).contains(I18n.func_74838_a((String)"Attack Damage"))) continue;
                event.getToolTip().set(x, TextFormatting.BLUE + "+" + TextUtils.makeFabulous(I18n.func_74838_a((String)"tip.infinity")) + " " + TextFormatting.BLUE + I18n.func_74838_a((String)"attribute.name.generic.attackDamage"));
                return;
            }
        }
    }

    @SubscribeEvent
    public void onGetHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == ModItems.infinity_sword && player.func_184587_cr()) {
            event.setCanceled(true);
        }
        if (AvaritiaEventHandler.isInfinite(player) && !event.getSource().field_76373_n.equals("infinity")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (AvaritiaEventHandler.isInfinite(player) && !event.getSource().field_76373_n.equals("infinity")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        if (event.isRecentlyHit() && event.getEntityLiving() instanceof EntitySkeleton && event.getSource().func_76346_g() instanceof EntityPlayer && !(player = (EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.skull_sword) {
            if (event.getDrops().isEmpty()) {
                this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 1));
            } else {
                int skulls = 0;
                for (int i = 0; i < event.getDrops().size(); ++i) {
                    EntityItem drop = (EntityItem)event.getDrops().get(i);
                    ItemStack stack = drop.func_92059_d();
                    if (stack.func_77973_b() != Items.field_151144_bL) continue;
                    if (stack.func_77952_i() == 1) {
                        ++skulls;
                        continue;
                    }
                    if (stack.func_77952_i() != 0) continue;
                    ++skulls;
                    stack.func_77964_b(1);
                }
                if (skulls == 0) {
                    this.addDrop(event, new ItemStack(Items.field_151144_bL, 1, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public void diggity(PlayerEvent.BreakSpeed event) {
        ItemStack held;
        if (!(event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() || (held = event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() != ModItems.infinity_pickaxe && held.func_77973_b() != ModItems.infinity_shovel)) {
            if (!event.getEntityLiving().field_70122_E) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (!event.getEntityLiving().func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)event.getEntityLiving())) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (held.func_77978_p() != null && (held.func_77978_p().func_74767_n("hammer") || held.func_77978_p().func_74767_n("destroyer"))) {
                event.setNewSpeed(event.getNewSpeed() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void canHarvest(PlayerEvent.HarvestCheck event) {
        ItemStack held;
        if (!event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (held = event.getEntityLiving().func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() == ModItems.infinity_shovel && event.getTargetBlock().func_185904_a() == Material.field_151576_e && held.func_77978_p() != null && held.func_77978_p().func_74767_n("destroyer") && AvaritiaEventHandler.isGarbageBlock(event.getTargetBlock().func_177230_c())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private static boolean isGarbageBlock(Block block) {
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1))) {
            String ore = OreDictionary.getOreName((int)id);
            if (!ore.equals("cobblestone") && !ore.equals("stone") && !ore.equals("netherrack")) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && AvaritiaEventHandler.isInfinite(player = (EntityPlayer)event.getEntityLiving()) && !event.getSource().func_76355_l().equals("infinity")) {
            event.setCanceled(true);
            player.func_70606_j(player.func_110138_aP());
        }
    }

    private void addDrop(LivingDropsEvent event, ItemStack drop) {
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        entityitem.func_174869_p();
        event.getDrops().add(entityitem);
    }

    @SubscribeEvent
    public void clusterClustererererer(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() != null && event.getItem().func_92059_d().func_77973_b() == ModItems.matter_cluster) {
            ItemStack stack = event.getItem().func_92059_d();
            EntityPlayer player = event.getEntityPlayer();
            for (ItemStack slot : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b()) break;
                if (slot.func_77973_b() != ModItems.matter_cluster) continue;
                ItemMatterCluster.mergeClusters(stack, slot);
            }
        }
    }
}

