/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.ChangePacket;
import assets.recipehandler.GuiEventHandler;
import assets.recipehandler.Proxy;
import assets.recipehandler.RecipeCommand;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class ClientEventHandler
extends Proxy {
    private boolean switchKey = false;
    private boolean cycleButton = true;
    public static boolean cornerText = false;
    public static boolean creativeCraft = false;
    public static boolean onlyNecessary = false;
    public static int xOffset = 0;
    public static int yOffset = 0;
    private KeyBinding key;
    private boolean pressed = false;

    @Override
    public void setup(Configuration config) {
        super.setup(config);
        this.switchKey = config.getBoolean("Enable Switch Key", "general", this.switchKey, "Can be modified in controls menu");
        this.cycleButton = config.getBoolean("Enable Cycle Button", "general", this.cycleButton, "Rendered in the crafting GUI");
        cornerText = config.getBoolean("Render Text Tooltip", "general", cornerText, "Rendered in the Top Right Corner of the screen");
        if (this.cycleButton) {
            Property property = config.get("client", "Cycle Button Horizontal Offset", 0);
            property.setComment("Offset for button from its default position, negative values to the left, positive to the right [default: 0]");
            xOffset = property.getInt();
            property = config.get("client", "Cycle Button Vertical Offset", 0);
            property.setComment("Offset for button from its default position, negative values to under, positive to over [default: 0]");
            yOffset = property.getInt();
            onlyNecessary = config.getBoolean("Limit Button To Conflict", "client", onlyNecessary, "Only render button in case of conflict");
        }
        creativeCraft = config.getBoolean("Enable Craft In Creative Inventory", "client", creativeCraft, "Shows craft space in creative inventory tab");
    }

    @Override
    public void register() {
        super.register();
        if (this.switchKey) {
            this.key = new KeyBinding("RecipeSwitch", (IKeyConflictContext)KeyConflictContext.GUI, 78, "key.categories.gui");
            ClientRegistry.registerKeyBinding((KeyBinding)this.key);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.cycleButton) {
            MinecraftForge.EVENT_BUS.register((Object)GuiEventHandler.INSTANCE);
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new RecipeCommand("recipes_client", true));
    }

    @Nullable
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Nullable
    Container getContainer() {
        return this.getPlayer() != null ? this.getPlayer().field_71070_bA : null;
    }

    @Override
    public void scheduleTask(final ChangePacket runner) {
        FMLClientHandler.instance().getClient().func_152344_a(new Runnable(){

            @Override
            public void run() {
                Slot result;
                Container container;
                InventoryCrafting crafting;
                if (!runner.stack().func_190926_b() && (crafting = ClientEventHandler.this.craftingHandler.getCraftingMatrix(container = ClientEventHandler.this.getContainer())) != null && (result = ClientEventHandler.this.craftingHandler.getResultSlot(container, crafting, runner.slot())) != null) {
                    result.func_75215_d(runner.stack());
                    if (runner.isShift()) {
                        ClientEventHandler.this.craftingHandler.setRecipeIndex(runner.index());
                        ClientEventHandler.this.sendShift(crafting, result);
                    }
                }
            }
        });
    }

    @Override
    public void sendShift(InventoryCrafting crafting, Slot slot) {
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer && GuiScreen.func_146272_n()) {
            GuiContainer screen = (GuiContainer)FMLClientHandler.instance().getClient().field_71462_r;
            ItemStack temp = FMLClientHandler.instance().getClient().field_71442_b.func_187098_a(screen.field_147002_h.field_75152_c, slot.field_75222_d, 0, ClickType.QUICK_MOVE, this.getPlayer());
            ItemStack result = this.craftingHandler.findCraftResult(crafting, ClientEventHandler.getWorld());
            if (!slot.func_75216_d() && !result.func_190926_b() && temp.func_190926_b()) {
                this.sendToServer(slot.field_75222_d, result, true);
            }
        }
    }

    public void sendToServer(int slot, ItemStack itemStack, boolean shift) {
        ChangePacket packet = new ChangePacket(slot, itemStack, this.craftingHandler.getRecipeIndex());
        if (shift) {
            packet.setShift();
        }
        this.network.sendToServer(packet.toProxy(Side.SERVER));
    }

    @Nullable
    public static World getWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Text event) {
        int result;
        if (cornerText && this.getPlayer() != null && FMLClientHandler.instance().getClient().field_71462_r != null && (result = this.craftingHandler.getNumberOfCraft(this.getContainer(), ClientEventHandler.getWorld())) > 1) {
            event.getRight().add(I18n.func_135052_a((String)"handler.found.text", (Object[])new Object[]{result}));
        }
    }

    @SubscribeEvent
    public void keyDown(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (this.key != null && Keyboard.getEventKey() == this.key.func_151463_i() && this.getPlayer() != null) {
            if (Keyboard.getEventKeyState()) {
                if (!this.pressed) {
                    this.pressed = true;
                    this.pressed();
                }
            } else if (this.pressed) {
                this.pressed = false;
            }
        }
    }

    @SubscribeEvent
    public void mouseDown(GuiScreenEvent.MouseInputEvent.Post event) {
        if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && GuiScreen.func_146272_n()) {
            if (this.getPlayer() == null) {
                return;
            }
            Slot result = null;
            if (event.getGui() instanceof GuiContainer) {
                Slot slot = ((GuiContainer)event.getGui()).getSlotUnderMouse();
                if (!(slot instanceof SlotCrafting)) {
                    return;
                }
                result = slot;
            }
            if (this.craftingHandler.getNumberOfCraft(this.getContainer(), ClientEventHandler.getWorld()) < 2) {
                return;
            }
            InventoryCrafting craft = this.craftingHandler.getCraftingMatrix(this.getContainer());
            if (craft != null) {
                ItemStack res;
                if (result == null) {
                    result = this.craftingHandler.getResultSlot(this.getContainer(), craft, 0);
                }
                if (result != null && !(res = this.craftingHandler.findCraftResult(craft, ClientEventHandler.getWorld())).func_190926_b() && !ItemStack.func_77989_b((ItemStack)res, (ItemStack)result.func_75211_c())) {
                    this.sendToServer(result.field_75222_d, res, true);
                }
            }
        }
    }

    public void pressed() {
        Slot slot;
        ItemStack res;
        InventoryCrafting craft = this.craftingHandler.getCraftingMatrix(this.getContainer());
        if (craft != null && !(res = this.craftingHandler.findNextMatchingRecipe(craft, ClientEventHandler.getWorld())).func_190926_b() && (slot = this.craftingHandler.getResultSlot(this.getContainer(), craft, 0)) != null && !ItemStack.func_77989_b((ItemStack)res, (ItemStack)slot.func_75211_c())) {
            this.sendToServer(slot.field_75222_d, res, false);
        }
    }
}

