/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng.grid;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.EssentiaFilter;

public class EssentiaContainerAdapter
implements IMEInventoryHandler<IAEEssentiaStack> {
    private IAspectContainer container;
    private EssentiaFilter config;

    public EssentiaContainerAdapter(IAspectContainer container, EssentiaFilter config) {
        this.container = container;
        this.config = config;
    }

    public IAEEssentiaStack injectItems(IAEEssentiaStack input, Actionable type, IActionSource src) {
        if (input == null || !input.isMeaningful()) {
            return input;
        }
        if (this.container.doesContainerAccept(input.getAspect())) {
            int notAdded = this.container.addToContainer(input.getAspect(), (int)input.getStackSize());
            if (type == Actionable.SIMULATE) {
                this.container.takeFromContainer(input.getAspect(), (int)input.getStackSize() - notAdded);
            }
            if (notAdded > 0) {
                return (IAEEssentiaStack)input.setStackSize(notAdded);
            }
            return null;
        }
        return input;
    }

    public IAEEssentiaStack extractItems(IAEEssentiaStack request, Actionable mode, IActionSource src) {
        if (request == null || !request.isMeaningful()) {
            return null;
        }
        if (this.container.containerContains(request.getAspect()) <= 0) {
            return null;
        }
        Aspect aspect = request.getAspect();
        int max = (int)Math.min((long)this.container.containerContains(aspect), request.getStackSize());
        if (mode == Actionable.SIMULATE) {
            return AEUtil.getAEStackFromAspect(aspect, max);
        }
        boolean worked = this.container.takeFromContainer(aspect, max);
        if (!worked) {
            return null;
        }
        return (IAEEssentiaStack)request.setStackSize(max);
    }

    public IItemList<IAEEssentiaStack> getAvailableItems(IItemList<IAEEssentiaStack> out) {
        if (this.container == null) {
            return out;
        }
        for (Aspect aspect : this.container.getAspects().getAspects()) {
            out.add((IAEStack)AEUtil.getAEStackFromAspect(aspect, this.container.containerContains(aspect)));
        }
        return out;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEEssentiaStack input) {
        return false;
    }

    public boolean canAccept(IAEEssentiaStack input) {
        if (this.container == null) {
            return false;
        }
        return this.container.doesContainerAccept(input.getAspect()) && this.config.isInFilter(input.getAspect());
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IStorageChannel<IAEEssentiaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }
}

