/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RouterIterator<T extends GenericTileEntity>
implements Iterator<T> {
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final Class<T> clazz;
    private int facingIdx = 0;
    private T foundRouter = null;

    Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, (long)EnumFacing.field_82609_l.length, 16), false);
    }

    RouterIterator(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Class<T> clazz) {
        this.world = world;
        this.pos = pos;
        this.clazz = clazz;
        this.findNext();
    }

    private void findNext() {
        this.foundRouter = null;
        while (this.facingIdx != -1) {
            TileEntity te;
            BlockPos routerPos = this.pos.func_177972_a(EnumFacing.field_82609_l[this.facingIdx]);
            ++this.facingIdx;
            if (this.facingIdx >= EnumFacing.field_82609_l.length) {
                this.facingIdx = -1;
            }
            if (!this.clazz.isInstance(te = this.world.func_175625_s(routerPos))) continue;
            this.foundRouter = (GenericTileEntity)te;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.foundRouter != null;
    }

    @Override
    public T next() {
        T f = this.foundRouter;
        this.findNext();
        return f;
    }
}

