/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.proxy;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.foamfix.shared.FoamFixShared;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.LoliReflector;
import zone.rong.loliasm.bakedquad.LoliVertexDataPool;
import zone.rong.loliasm.client.screenshot.ScreenshotListener;
import zone.rong.loliasm.client.sprite.FramesTextureData;
import zone.rong.loliasm.common.modfixes.qmd.QMDEventHandler;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.core.LoliTransformer;
import zone.rong.loliasm.proxy.CommonProxy;

@Mod.EventBusSubscriber(modid="loliasm", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final List<Runnable> refreshAfterModels = new ArrayList<Runnable>();
    public static final boolean flushTinkerSpriteFrameTextureData;
    public static boolean canReload;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (LoliConfig.instance.releaseSpriteFramesCache) {
            MinecraftForge.EVENT_BUS.register(FramesTextureData.class);
        }
        if (Loader.isModLoaded((String)"qmd") && LoliConfig.instance.optimizeQMDBeamRenderer) {
            MinecraftForge.EVENT_BUS.register(QMDEventHandler.class);
        }
        if (LoliConfig.instance.copyScreenshotToClipboard) {
            MinecraftForge.EVENT_BUS.register(ScreenshotListener.class);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        if (!Loader.isModLoaded((String)"jei")) {
            this.releaseSpriteFramesCache();
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        super.loadComplete(event);
        if (Loader.isModLoaded((String)"jei")) {
            this.releaseSpriteFramesCache();
        }
        if (!LoliTransformer.isOptifineInstalled && LoliConfig.instance.vertexDataCanonicalization) {
            LoliLogger.instance.info("{} total quads processed. {} unique vertex data array in LoliVertexDataPool, {} vertex data arrays deduplicated altogether during game load.", (Object)LoliVertexDataPool.getDeduplicatedCount(), (Object)LoliVertexDataPool.getSize(), (Object)(LoliVertexDataPool.getDeduplicatedCount() - LoliVertexDataPool.getSize()));
            MinecraftForge.EVENT_BUS.register(LoliVertexDataPool.class);
        }
    }

    private void releaseSpriteFramesCache() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
            if (predicate.test(VanillaResourceType.MODELS)) {
                refreshAfterModels.forEach(Runnable::run);
                if (LoliConfig.instance.releaseSpriteFramesCache) {
                    canReload = false;
                    try {
                        for (TextureAtlasSprite sprite : LoliReflector.resolveFieldGetter(TextureMap.class, "mapRegisteredSprites", "field_110574_e").invoke(Minecraft.func_71410_x().func_147117_R()).values()) {
                            if (sprite.func_130098_m() || !flushTinkerSpriteFrameTextureData && sprite instanceof AbstractColoredTexture) continue;
                            sprite.func_110968_a((List)new FramesTextureData(sprite));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    canReload = true;
                }
                if (!LoliTransformer.isOptifineInstalled && LoliConfig.instance.vertexDataCanonicalization) {
                    LoliVertexDataPool.invalidate();
                }
            }
        }));
    }

    static {
        boolean static$flushTinkerSpriteFrameTextureData = true;
        if (Loader.isModLoaded((String)"tconstruct") && Loader.isModLoaded((String)"foamfix") && FoamFixShared.config.clDynamicItemModels) {
            static$flushTinkerSpriteFrameTextureData = false;
        }
        flushTinkerSpriteFrameTextureData = static$flushTinkerSpriteFrameTextureData;
        canReload = false;
    }
}

