/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.core;

import betterwithmods.module.gameplay.Gameplay;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.LoliReflector;
import zone.rong.loliasm.api.LoliStringPool;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.core.LoliLoadingPlugin;
import zone.rong.loliasm.patches.BakedQuadFactoryPatch;
import zone.rong.loliasm.patches.BakedQuadPatch;
import zone.rong.loliasm.patches.BakedQuadRetexturedPatch;
import zone.rong.loliasm.patches.UnpackedBakedQuadPatch;

public class LoliTransformer
implements IClassTransformer {
    public static boolean isOptifineInstalled;
    public static boolean squashBakedQuads;
    Multimap<String, Function<byte[], byte[]>> transformations;

    public LoliTransformer() {
        LoliLogger.instance.info("The lolis are now preparing to bytecode manipulate your game.");
        isOptifineInstalled = LoliReflector.doesClassExist("optifine.OptiFineForgeTweaker");
        if (squashBakedQuads && (squashBakedQuads = !isOptifineInstalled)) {
            LoliLogger.instance.info("Optifine is installed. BakedQuads won't be squashed as it is incompatible with OptiFine.");
        }
        this.transformations = MultimapBuilder.hashKeys((int)30).arrayListValues(1).build();
        if (LoliLoadingPlugin.isClient) {
            if (squashBakedQuads) {
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuad", BakedQuadPatch::rewriteBakedQuad);
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuadRetextured", BakedQuadRetexturedPatch::patchBakedQuadRetextured);
                this.addTransformation("net.minecraftforge.client.model.pipeline.UnpackedBakedQuad", UnpackedBakedQuadPatch::rewriteUnpackedBakedQuad);
                this.addTransformation("net.minecraftforge.client.model.pipeline.UnpackedBakedQuad$Builder", UnpackedBakedQuadPatch::rewriteUnpackedBakedQuad$Builder);
                this.addTransformation("zone.rong.loliasm.bakedquad.BakedQuadFactory", BakedQuadFactoryPatch::patchCreateMethod);
                for (String classThatExtendBakedQuad : LoliConfig.instance.classesThatExtendBakedQuad) {
                    this.addTransformation(classThatExtendBakedQuad, this::extendSupportingBakedQuadInstead);
                }
            } else if (LoliConfig.instance.vertexDataCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.BakedQuad", this::canonicalizeVertexData);
            }
            if (LoliConfig.instance.modelConditionCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ICondition", this::canonicalBoolConditions);
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionOr", bytes -> this.canonicalPredicatedConditions((byte[])bytes, true));
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionAnd", bytes -> this.canonicalPredicatedConditions((byte[])bytes, false));
                this.addTransformation("net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue", this::canonicalPropertyValueConditions);
            }
            if (LoliConfig.instance.resourceLocationCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.block.model.ModelResourceLocation", this::canonicalizeResourceLocationStrings);
            }
            if (LoliConfig.instance.stripInstancedRandomFromSoundEventAccessor) {
                this.addTransformation("net.minecraft.client.audio.SoundEventAccessor", this::removeInstancedRandom);
            }
            if (LoliConfig.instance.optimizeRegistries) {
                this.addTransformation("net.minecraft.client.audio.SoundRegistry", this::removeDupeMapFromSoundRegistry);
                this.addTransformation("net.minecraftforge.client.model.ModelLoader", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.block.statemap.StateMapperBase", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.BlockModelShapes", this::optimizeDataStructures);
                this.addTransformation("net.minecraft.client.renderer.block.statemap.BlockStateMapper", this::optimizeDataStructures);
            }
            if (LoliConfig.instance.optimizeSomeRendering) {
                this.addTransformation("net.minecraft.client.renderer.RenderGlobal", bytes -> this.fixEnumFacingValuesClone((byte[])bytes, LoliLoadingPlugin.isDeobf ? "setupTerrain" : "func_174970_a"));
            }
            if (LoliConfig.instance.stripUnnecessaryLocalsInRenderHelper) {
                this.addTransformation("net.minecraft.client.renderer.RenderHelper", this::stripLocalsInEnableStandardItemLighting);
            }
            if (LoliConfig.instance.spriteNameCanonicalization) {
                this.addTransformation("net.minecraft.client.renderer.texture.TextureAtlasSprite", this::canonicalizeSpriteNames);
            }
        }
        if (LoliConfig.instance.resourceLocationCanonicalization) {
            this.addTransformation("net.minecraft.util.ResourceLocation", this::canonicalizeResourceLocationStrings);
        }
        if (LoliConfig.instance.optimizeRegistries) {
            this.addTransformation("net.minecraft.util.registry.RegistrySimple", this::removeValuesArrayFromRegistrySimple);
        }
        if (LoliConfig.instance.nbtTagStringBackingStringCanonicalization) {
            this.addTransformation("net.minecraft.nbt.NBTTagString", this::nbtTagStringRevamp);
        }
        if (LoliConfig.instance.packageStringCanonicalization) {
            this.addTransformation("net.minecraftforge.fml.common.discovery.ModCandidate", this::removePackageField);
        }
        if (LoliConfig.instance.asmDataStringCanonicalization) {
            this.addTransformation("net.minecraftforge.fml.common.discovery.ASMDataTable$ASMData", this::deduplicateASMDataStrings);
        }
        if (LoliConfig.instance.stripNearUselessItemStackFields) {
            this.addTransformation("net.minecraft.item.ItemStack", this::stripItemStackFields);
        }
        if (LoliConfig.instance.optimizeFurnaceRecipeStore) {
            this.addTransformation("net.minecraft.item.crafting.FurnaceRecipes", this::improveFurnaceRecipes);
        }
        if (LoliConfig.instance.fixAmuletHolderCapability) {
            this.addTransformation("hellfirepvp.astralsorcery.common.enchantment.amulet.PlayerAmuletHandler", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "attachAmuletItemCapability"));
        }
        if (LoliConfig.instance.labelCanonicalization) {
            this.addTransformation("mezz.jei.suffixtree.Edge", this::deduplicateEdgeLabels);
        }
        if (LoliConfig.instance.bwmBlastingOilOptimization) {
            this.addTransformation("betterwithmods.event.BlastingOilEvent", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "onPlayerTakeDamage", "onHitGround"));
            this.addTransformation("betterwithmods.common.items.ItemMaterial", this::injectBlastingOilEntityItemUpdate);
        }
        if (LoliConfig.instance.optimizeQMDBeamRenderer) {
            this.addTransformation("lach_01298.qmd.render.entity.BeamRenderer", bytes -> this.stripSubscribeEventAnnotation((byte[])bytes, "renderBeamEffects"));
        }
        this.addTransformation("net.minecraft.nbt.NBTTagCompound", bytes -> this.nbtTagCompound$replaceDefaultHashMap((byte[])bytes, LoliConfig.instance.optimizeNBTTagCompoundBackingMap, LoliConfig.instance.nbtBackingMapStringCanonicalization));
    }

    public void addTransformation(String key, Function<byte[], byte[]> value) {
        LoliLogger.instance.info("Adding class {} to the transformation queue", (Object)key);
        this.transformations.put((Object)key, value);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Collection getBytes = this.transformations.get((Object)transformedName);
        if (getBytes != null) {
            byte[] transformedByteArray = bytes;
            for (Function func : getBytes) {
                transformedByteArray = (byte[])func.apply(transformedByteArray);
            }
            return transformedByteArray;
        }
        return bytes;
    }

    private byte[] extendSupportingBakedQuadInstead(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (node.superName.equals("net/minecraft/client/renderer/block/model/BakedQuad")) {
            node.superName = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
        }
        ObjectOpenHashSet fieldsToLookOutFor = new ObjectOpenHashSet((Object[])new String[]{"face", "applyDiffuseLighting", "tintIndex"});
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode instruction : method.instructions) {
                if (method.name.equals("<init>") && instruction instanceof MethodInsnNode) {
                    MethodInsnNode methodNode = (MethodInsnNode)instruction;
                    if (methodNode.getOpcode() != 183 || !methodNode.owner.equals("net/minecraft/client/renderer/block/model/BakedQuad")) continue;
                    methodNode.owner = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
                    continue;
                }
                if (!(instruction instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.owner.equals("net/minecraft/client/renderer/block/model/BakedQuad") || !fieldsToLookOutFor.contains(fieldNode.name)) continue;
                fieldNode.owner = "zone/rong/loliasm/bakedquad/SupportingBakedQuad";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalizeResourceLocationStrings(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("(I[Ljava/lang/String;)V")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof MethodInsnNode) || instruction.getOpcode() != 182 || !((MethodInsnNode)instruction).name.equals("toLowerCase")) continue;
                LoliLogger.instance.info("Injecting calls in {}{} to canonicalize strings", (Object)node.name, (Object)method.name);
                iter.previous();
                iter.previous();
                iter.remove();
                iter.next();
                iter.set(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "lowerCaseAndCanonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalBoolConditions(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<clinit>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof TypeInsnNode) || instruction.getOpcode() != 187) continue;
                boolean bool = ((TypeInsnNode)instruction).desc.endsWith("$1");
                LoliLogger.instance.info("Canonizing {} IConditions", (Object)(bool ? "TRUE" : "FALSE"));
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.remove();
                iter.add(new FieldInsnNode(178, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", bool ? "TRUE" : "FALSE", "Lnet/minecraft/client/renderer/block/model/multipart/ICondition;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalPredicatedConditions(byte[] bytes, boolean or) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String getPredicate = LoliLoadingPlugin.isDeobf ? "getPredicate" : "func_188118_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(getPredicate)) continue;
            String conditions = LoliLoadingPlugin.isDeobf ? "conditions" : (or ? "field_188127_c" : "field_188121_c");
            LoliLogger.instance.info("Transforming {}::getPredicate to canonicalize different IConditions", (Object)node.name);
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, conditions, "Ljava/lang/Iterable;"));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", or ? "orCache" : "andCache", "(Ljava/lang/Iterable;Lnet/minecraft/block/state/BlockStateContainer;)Lcom/google/common/base/Predicate;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalPropertyValueConditions(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String getPredicate = LoliLoadingPlugin.isDeobf ? "getPredicate" : "func_188118_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(getPredicate)) continue;
            LoliLogger.instance.info("Transforming {}::getPredicate to canonicalize different PropertyValueConditions", (Object)node.name);
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, LoliLoadingPlugin.isDeobf ? "key" : "field_188125_d", "Ljava/lang/String;"));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, LoliLoadingPlugin.isDeobf ? "value" : "field_188126_e", "Ljava/lang/String;"));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(178, node.name, LoliLoadingPlugin.isDeobf ? "SPLITTER" : "field_188124_c", "Lcom/google/common/base/Splitter;"));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/conditions/CanonicalConditions", "propertyValueCache", "(Lnet/minecraft/block/state/BlockStateContainer;Ljava/lang/String;Ljava/lang/String;Lcom/google/common/base/Splitter;)Lcom/google/common/base/Predicate;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            method.localVariables.clear();
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] cacheMultipartBakedModels(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String makeMultipartModel = LoliLoadingPlugin.isDeobf ? "makeMultipartModel" : "func_188647_a";
        for (MethodNode method : node.methods) {
            if (!method.name.equals(makeMultipartModel)) continue;
            LoliLogger.instance.info("Transforming {}::makeMultipartModel", (Object)node.name);
            String builderSelectors = LoliLoadingPlugin.isDeobf ? "builderSelectors" : "field_188649_a";
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, builderSelectors, "Ljava/util/Map;"));
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/client/models/MultipartBakedModelCache", "makeMultipartModel", "(Ljava/util/Map;)Lnet/minecraft/client/renderer/block/model/MultipartBakedModel;", false));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeValuesArrayFromRegistrySimple(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String values = LoliLoadingPlugin.isDeobf ? "values" : "field_186802_b";
        node.fields.removeIf(f -> f.name.equals(values));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeDupeMapFromSoundRegistry(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String soundRegistry = LoliLoadingPlugin.isDeobf ? "soundRegistry" : "field_148764_a";
        node.fields.removeIf(f -> f.name.equals(soundRegistry));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] improveFurnaceRecipes(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            boolean isExperienceList = false;
            LoliLogger.instance.info("Improving FurnaceRecipes. Lookups are now a lot faster.");
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (!(instruction instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInstruction = (MethodInsnNode)instruction;
                if (!methodInstruction.owner.equals("com/google/common/collect/Maps")) continue;
                iter.remove();
                if (!isExperienceList) {
                    iter.add(new TypeInsnNode(187, "it/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap"));
                    iter.add(new InsnNode(89));
                    iter.add(new FieldInsnNode(178, "zone/rong/loliasm/api/HashingStrategies", "FURNACE_INPUT_HASH", "Lit/unimi/dsi/fastutil/Hash$Strategy;"));
                    iter.add(new MethodInsnNode(183, "it/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap", "<init>", "(Lit/unimi/dsi/fastutil/Hash$Strategy;)V", false));
                    isExperienceList = true;
                    continue;
                }
                iter.add(new TypeInsnNode(187, "it/unimi/dsi/fastutil/objects/Object2FloatOpenHashMap"));
                iter.add(new InsnNode(89));
                iter.add(new MethodInsnNode(183, "it/unimi/dsi/fastutil/objects/Object2FloatOpenHashMap", "<init>", "()V", false));
                iter.next();
                iter.add(new VarInsnNode(25, 0));
                iter.add(new FieldInsnNode(180, "net/minecraft/item/crafting/FurnaceRecipes", LoliLoadingPlugin.isDeobf ? "experienceList" : "field_77605_c", "Ljava/util/Map;"));
                iter.add(new TypeInsnNode(192, "it/unimi/dsi/fastutil/objects/Object2FloatFunction"));
                iter.add(new LdcInsnNode((Object)Float.valueOf(0.0f)));
                iter.add(new MethodInsnNode(185, "it/unimi/dsi/fastutil/objects/Object2FloatFunction", "defaultReturnValue", "(F)V", true));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removeInstancedRandom(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.fields.removeIf(f -> f.desc.equals("Ljava/util/Random;"));
        for (MethodNode method : node.methods) {
            AbstractInsnNode instruction;
            ListIterator iter;
            if (method.name.equals("<init>")) {
                iter = method.instructions.iterator();
                while (iter.hasNext()) {
                    instruction = (AbstractInsnNode)iter.next();
                    if (!(instruction instanceof TypeInsnNode)) continue;
                    TypeInsnNode newNode = (TypeInsnNode)instruction;
                    if (!newNode.desc.equals("java/util/Random")) continue;
                    iter.previous();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                    iter.next();
                    iter.remove();
                }
                continue;
            }
            if (!method.name.equals(LoliLoadingPlugin.isDeobf ? "cloneEntry" : "func_148720_g")) continue;
            iter = method.instructions.iterator();
            while (iter.hasNext()) {
                instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180 || !((FieldInsnNode)instruction).desc.equals("Ljava/util/Random;")) continue;
                iter.previous();
                iter.remove();
                iter.next();
                iter.remove();
                iter.next();
                iter.remove();
                iter.add(new MethodInsnNode(184, "java/util/concurrent/ThreadLocalRandom", "current", "()Ljava/util/concurrent/ThreadLocalRandom;", false));
                iter.add(new IntInsnNode(21, 1));
                iter.add(new MethodInsnNode(182, "java/util/concurrent/ThreadLocalRandom", "nextInt", "(I)I", false));
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] nbtTagCompound$replaceDefaultHashMap(byte[] bytes, boolean optimizeMap, boolean canonicalizeString) {
        if (!optimizeMap && !canonicalizeString) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 184) continue;
                iter.set(new TypeInsnNode(187, canonicalizeString ? "zone/rong/loliasm/api/datastructures/canonical/AutoCanonizingArrayMap" : "it/unimi/dsi/fastutil/objects/Object2ObjectArrayMap"));
                iter.add(new InsnNode(89));
                iter.add(new MethodInsnNode(183, canonicalizeString ? "zone/rong/loliasm/api/datastructures/canonical/AutoCanonizingArrayMap" : "it/unimi/dsi/fastutil/objects/Object2ObjectArrayMap", "<init>", "()V", false));
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] fixEnumFacingValuesClone(byte[] bytes, String methodMatch) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals(methodMatch)) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
                if (!methodInsnNode.name.equals("values") || !methodInsnNode.desc.equals("()[Lnet/minecraft/util/EnumFacing;")) continue;
                LoliLogger.instance.info("Transforming EnumFacing::values() to EnumFacing::VALUES in {}", (Object)node.name);
                iter.set(new FieldInsnNode(178, "net/minecraft/util/EnumFacing", LoliLoadingPlugin.isDeobf ? "VALUES" : "field_82609_l", "[Lnet/minecraft/util/EnumFacing;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] removePackageField(byte[] bytes) {
        try {
            Map packages = (Map)LoliReflector.getField(ClassLoader.class, "packages").get(Launch.classLoader);
            Set packageStrings = packages.keySet();
            packageStrings.forEach(LoliStringPool::canonicalize);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.fields.stream().filter(f -> f.name.equals("packages")).findFirst().ifPresent(f -> {
            f.desc = "Ljava/util/Set;";
            f.signature = "Ljava/util/Set<Ljava/lang/String;>;";
        });
        block2: for (MethodNode method : node.methods) {
            FieldInsnNode fieldNode;
            AbstractInsnNode instruction;
            ListIterator iter;
            if (method.name.equals("<init>") && method.desc.equals("(Ljava/io/File;Ljava/io/File;Lnet/minecraftforge/fml/common/discovery/ContainerType;ZZ)V")) {
                iter = method.instructions.iterator();
                while (iter.hasNext()) {
                    instruction = (AbstractInsnNode)iter.next();
                    if (instruction.getOpcode() != 181) continue;
                    fieldNode = (FieldInsnNode)instruction;
                    if (!fieldNode.name.equals("packages")) continue;
                    fieldNode.desc = "Ljava/util/Set;";
                    iter.previous();
                    iter.previous();
                    iter.set(new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "createHashSet", "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", false));
                    continue block2;
                }
                continue;
            }
            if (method.name.equals("addClassEntry")) {
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "foundClasses", "Ljava/util/Set;"));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "packages", "Ljava/util/Set;"));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/discovery/ModCandidate", "table", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;"));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "modCandidate$override$addClassEntry", "(Lnet/minecraftforge/fml/common/discovery/ModCandidate;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Lnet/minecraftforge/fml/common/discovery/ASMDataTable;)V", false));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                continue;
            }
            if (!method.name.equals("getContainedPackages")) continue;
            iter = method.instructions.iterator();
            while (iter.hasNext()) {
                instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 180) continue;
                fieldNode = (FieldInsnNode)instruction;
                fieldNode.desc = "Ljava/util/Set;";
                iter.add(new MethodInsnNode(184, "com/google/common/collect/Lists", "newArrayList", "(Ljava/lang/Iterable;)Ljava/util/ArrayList;", false));
                continue block2;
            }
        }
        ClassWriter writer = new ClassWriter(2);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] nbtTagStringRevamp(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("(Ljava/lang/String;)V")) continue;
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction.getOpcode() != 181) continue;
                method.instructions.insertBefore(instruction, (AbstractInsnNode)new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "nbtTagString$override$ctor", "(Ljava/lang/String;)Ljava/lang/String;", false));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripSubscribeEventAnnotation(byte[] bytes, String ... methodNames) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            for (String methodName : methodNames) {
                List annotations;
                if (!method.name.equals(methodName) || (annotations = method.visibleAnnotations) == null) continue;
                annotations.removeIf(a -> a.desc.equals("Lnet/minecraftforge/fml/common/eventhandler/SubscribeEvent;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripItemStackFields(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        String[] fields = new String[]{!LoliLoadingPlugin.isDeobf ? "field_82843_f" : "itemFrame", !LoliLoadingPlugin.isDeobf ? "field_179552_h" : "canDestroyCacheBlock", !LoliLoadingPlugin.isDeobf ? "field_179553_i" : "canDestroyCacheResult", !LoliLoadingPlugin.isDeobf ? "field_179550_j" : "canPlaceOnCacheBlock", !LoliLoadingPlugin.isDeobf ? "field_179551_k" : "canPlaceOnCacheResult"};
        node.fields.removeIf(f -> ArrayUtils.contains((Object[])fields, (Object)f.name));
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] stripLocalsInEnableStandardItemLighting(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals(LoliLoadingPlugin.isDeobf ? "enableStandardItemLighting" : "func_74519_b")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 56) continue;
                iter.remove();
                iter.previous();
                iter.remove();
                method.localVariables = null;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] deduplicateEdgeLabels(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") && !method.name.equals("setLabel")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181 || !((FieldInsnNode)instruction).name.equals("label")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "canonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] deduplicateASMDataStrings(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.name.equals("annotationName") && !fieldNode.name.equals("className")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/core/LoliHooks", "asmData$redirect$CtorStringsToIntern", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] canonicalizeSpriteNames(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.desc.equals("Ljava/lang/String")) continue;
                iter.previous();
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/api/LoliStringPool", "canonicalize", "(Ljava/lang/String;)Ljava/lang/String;", false));
                iter.next();
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] injectBlastingOilEntityItemUpdate(byte[] bytes) {
        if (!Gameplay.disableBlastingOilEvents) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            ClassWriter writer = new ClassWriter(2);
            node.accept((ClassVisitor)writer);
            MethodVisitor methodVisitor = writer.visitMethod(1, "onEntityItemUpdate", "(Lnet/minecraft/entity/item/EntityItem;)Z", null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(184, "zone/rong/loliasm/common/modfixes/betterwithmods/BWMBlastingOilOptimization", "inject$ItemMaterial$onEntityItemUpdate", "(Lnet/minecraft/entity/item/EntityItem;)Z", false);
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(2, 2);
            methodVisitor.visitEnd();
            writer.visitEnd();
            return writer.toByteArray();
        }
        return bytes;
    }

    private byte[] canonicalizeVertexData(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>") || !method.desc.equals("([IILnet/minecraft/util/EnumFacing;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;ZLnet/minecraft/client/renderer/vertex/VertexFormat;)V")) continue;
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iter.next();
                if (instruction.getOpcode() != 181) continue;
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                if (!fieldNode.desc.equals("[I")) continue;
                iter.previous();
                iter.add(new VarInsnNode(25, 0));
                iter.add(new MethodInsnNode(184, "zone/rong/loliasm/bakedquad/LoliVertexDataPool", "canonicalize", "([ILnet/minecraft/client/renderer/block/model/BakedQuad;)[I", false));
                method.maxStack = 3;
                continue block0;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] optimizeDataStructures(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("<init>")) continue;
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode methodNode = (MethodInsnNode)instruction;
                switch (methodNode.name) {
                    case "newIdentityHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createReferenceMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Reference2ObjectOpenHashMap;";
                        break;
                    }
                    case "newLinkedHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createArrayMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Object2ObjectArrayMap;";
                        break;
                    }
                    case "newHashMap": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createHashMap";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;";
                        break;
                    }
                    case "newHashSet": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createHashSet";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;";
                        break;
                    }
                    case "newIdentityHashSet": {
                        methodNode.owner = "zone/rong/loliasm/core/LoliHooks";
                        methodNode.name = "createReferenceSet";
                        methodNode.desc = "()Lit/unimi/dsi/fastutil/objects/ReferenceOpenHashSet;";
                    }
                }
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        squashBakedQuads = LoliConfig.instance.squashBakedQuads;
    }
}

