/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.core;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.SystemUtils;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.UnsafeLolis;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.spark.LoliSparker;

@IFMLLoadingPlugin.Name(value="LoliASM")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class LoliLoadingPlugin
implements IFMLLoadingPlugin {
    public static final String VERSION = "4.4";
    public static final boolean isDeobf = FMLLaunchHandler.isDeobfuscatedEnvironment();
    public static final boolean isVMOpenJ9;
    public static final boolean isClient;

    public LoliLoadingPlugin() {
        LoliLogger.instance.info("Lolis are on the {}-side.", (Object)(isClient ? "client" : "server"));
        LoliLogger.instance.info("Lolis are preparing and loading in mixins since Rongmario's too lazy to write pure ASM at times despite the mod being called 'LoliASM'");
        if (LoliConfig.instance.sparkProfileCoreModLoading) {
            LoliSparker.start("coremod");
        }
        if (LoliConfig.instance.sparkProfileEntireGameLoad) {
            LoliSparker.start("game");
        }
        if (LoliConfig.instance.removeForgeSecurityManager) {
            UnsafeLolis.removeFMLSecurityManager();
        }
        boolean needToDGSFFFF = isVMOpenJ9 && SystemUtils.IS_JAVA_1_8;
        int buildAppendIndex = SystemUtils.JAVA_VERSION.indexOf("_");
        if (needToDGSFFFF && buildAppendIndex != -1 && (needToDGSFFFF = Integer.parseInt(SystemUtils.JAVA_VERSION.substring(buildAppendIndex + 1)) < 265)) {
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.equals("-Xjit:disableGuardedStaticFinalFieldFolding")) continue;
                needToDGSFFFF = false;
                break;
            }
            if (needToDGSFFFF) {
                LoliLogger.instance.fatal("LoliASM notices that you're using Eclipse OpenJ9 {}!", (Object)SystemUtils.JAVA_VERSION);
                LoliLogger.instance.fatal("This OpenJ9 version is outdated and contains a critical bug: https://github.com/eclipse-openj9/openj9/issues/8353");
                LoliLogger.instance.fatal("Either use '-Xjit:disableGuardedStaticFinalFieldFolding' as part of your java arguments, or update OpenJ9!");
            }
        }
        MixinBootstrap.init();
        Mixins.addConfiguration("mixins.internal.json");
        Mixins.addConfiguration("mixins.vanities.json");
        if (LoliConfig.instance.optimizeRegistries) {
            Mixins.addConfiguration("mixins.registries.json");
        }
        if (LoliConfig.instance.stripNearUselessItemStackFields) {
            Mixins.addConfiguration("mixins.stripitemstack.json");
        }
        if (LoliConfig.instance.lockCodeCanonicalization) {
            Mixins.addConfiguration("mixins.lockcode.json");
        }
        if (LoliConfig.instance.optimizeFurnaceRecipeStore) {
            Mixins.addConfiguration("mixins.recipes.json");
        }
        if (LoliConfig.instance.quickerEnableUniversalBucketCheck) {
            Mixins.addConfiguration("mixins.misc_fluidregistry.json");
        }
        if (LoliConfig.instance.fixFillBucketEventNullPointerException || LoliConfig.instance.fixTileEntityOnLoadCME) {
            Mixins.addConfiguration("mixins.forgefixes.json");
        }
        if (isClient) {
            if (LoliConfig.instance.reuseBucketQuads) {
                Mixins.addConfiguration("mixins.bucket.json");
            }
            if (LoliConfig.instance.optimizeSomeRendering) {
                Mixins.addConfiguration("mixins.rendering.json");
            }
            if (LoliConfig.instance.moreModelManagerCleanup) {
                Mixins.addConfiguration("mixins.datastructures_modelmanager.json");
            }
            if (LoliConfig.instance.releaseScreenshotCache) {
                Mixins.addConfiguration("mixins.screenshot.json");
            }
        }
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return "zone.rong.loliasm.core.LoliFMLCallHook";
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return "zone.rong.loliasm.core.LoliTransformer";
    }

    static {
        if (!isDeobf && (LoliConfig.instance.sparkProfileCoreModLoading || LoliConfig.instance.sparkProfileEntireGameLoad)) {
            File modsFolder = new File(Launch.minecraftHome, "mods");
            for (File file : modsFolder.listFiles()) {
                if (file.isDirectory()) continue;
                File toAddToCp = null;
                try (ZipFile jar2 = new ZipFile(file);){
                    ZipEntry sparkProto = jar2.getEntry("spark/spark.proto");
                    if (sparkProto != null) {
                        toAddToCp = file;
                    }
                }
                catch (IOException jar2) {
                    // empty catch block
                }
                if (toAddToCp == null) continue;
                try {
                    Launch.classLoader.addURL(toAddToCp.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        isVMOpenJ9 = SystemUtils.JAVA_VM_NAME.toLowerCase(Locale.ROOT).contains("openj9");
        isClient = FMLLaunchHandler.side() == Side.CLIENT;
    }
}

