/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.config.annotation.Ignore;
import zone.rong.loliasm.config.annotation.Since;

public class LoliConfig {
    public static final LoliConfig instance = new LoliConfig();
    private Configuration configuration;
    public boolean squashBakedQuads;
    public boolean logClassesThatCallBakedQuadCtor;
    public boolean reuseBucketQuads;
    public String[] classesThatCallBakedQuadCtor;
    public String[] classesThatExtendBakedQuad;
    public boolean cleanupLaunchClassLoaderEarly;
    public boolean cleanupLaunchClassLoaderLate;
    public boolean noResourceCache;
    public boolean noClassCache;
    public boolean weakResourceCache;
    public boolean weakClassCache;
    public boolean disablePackageManifestMap;
    public boolean cleanCachesOnGameLoad;
    public boolean resourceLocationCanonicalization;
    public boolean modelConditionCanonicalization;
    public boolean nbtTagStringBackingStringCanonicalization;
    public boolean nbtBackingMapStringCanonicalization;
    public boolean packageStringCanonicalization;
    public boolean lockCodeCanonicalization;
    public boolean spriteNameCanonicalization;
    public boolean asmDataStringCanonicalization;
    public boolean vertexDataCanonicalization;
    public boolean filePermissionsCacheCanonicalization;
    public boolean optimizeFMLRemapper;
    public boolean optimizeRegistries;
    public boolean optimizeNBTTagCompoundBackingMap;
    public boolean optimizeFurnaceRecipeStore;
    public boolean stripNearUselessItemStackFields;
    public boolean moreModelManagerCleanup;
    public boolean releaseSpriteFramesCache;
    public boolean optimizeSomeRendering;
    public boolean stripUnnecessaryLocalsInRenderHelper;
    public boolean quickerEnableUniversalBucketCheck;
    public boolean stripInstancedRandomFromSoundEventAccessor;
    public boolean classCaching;
    public boolean copyScreenshotToClipboard;
    public boolean releaseScreenshotCache;
    public boolean fixBlockIEBaseArrayIndexOutOfBoundsException;
    public boolean cleanupChickenASMClassHierarchyManager;
    public boolean optimizeAmuletRelatedFunctions;
    public boolean labelCanonicalization;
    public boolean skipCraftTweakerRecalculatingSearchTrees;
    public boolean bwmBlastingOilOptimization;
    public boolean optimizeQMDBeamRenderer;
    public boolean repairEvilCraftEIOCompat;
    public boolean optimizeArcaneLockRendering;
    public boolean fixAmuletHolderCapability;
    public boolean fixFillBucketEventNullPointerException;
    public boolean fixTileEntityOnLoadCME;
    public boolean removeForgeSecurityManager;
    public boolean fasterEntitySpawnPreparation;
    public boolean sparkProfileEntireGameLoad;
    public boolean sparkProfileCoreModLoading;
    public boolean sparkProfileConstructionStage;
    public boolean sparkProfilePreInitializationStage;
    public boolean sparkProfileInitializationStage;
    public boolean sparkProfilePostInitializationStage;
    public boolean sparkProfileLoadCompleteStage;
    public boolean includeAllThreadsWhenProfiling;
    public boolean sparkSummarizeHeapSpaceAfterGameLoads;

    private void initialize() {
        this.configuration = new Configuration(new File(Launch.minecraftHome, "config" + File.separator + "loliasm.cfg"));
        this.load();
    }

    public void load() {
        this.squashBakedQuads = this.getBoolean("squashBakedQuads", "bakedquad", "Saves RAM by removing BakedQuad instance variables, redirecting BakedQuad creation to specific BakedQuad child classes. This will be forcefully turned off when Optifine is installed as it is incompatible", true);
        this.classesThatCallBakedQuadCtor = this.getStringArray("classesThatCallBakedQuadCtor", "bakedquad", "Classes where BakedQuad::new calls need to be redirected. As of 3.2, this should be done automatically, while the changes will show in the next launch", "net.minecraft.client.renderer.block.model.FaceBakery");
        this.classesThatExtendBakedQuad = this.getStringArray("classesThatExtendBakedQuad", "bakedquad", "Classes that extend BakedQuad need to be handled separately. This should be done automatically, while the changes will show in the next launch", "");
        this.logClassesThatCallBakedQuadCtor = this.getBoolean("logClassesThatCallBakedQuadCtor", "bakedquad", "Log classes that need their BakedQuad::new calls redirected", true);
        this.reuseBucketQuads = this.getBoolean("reuseBucketQuads", "bakedquad", "Allows bucket models to re-use UnpackedBakedQuads", true);
        this.cleanupLaunchClassLoaderEarly = this.getBoolean("cleanupLaunchClassLoaderEarly", "launchwrapper", "Cleanup some redundant data structures in LaunchClassLoader at the earliest point possible (when LoliASM is loaded). Helpful for those that don't have enough RAM to load into the game. This can induce slowdowns while loading the game in exchange for more available RAM", false);
        this.cleanupLaunchClassLoaderLate = this.getBoolean("cleanupLaunchClassLoaderLate", "launchwrapper", "Cleanup some redundant data structures in LaunchClassLoader at the latest point possible (when the game reaches the Main Screen). This is for those that have enough RAM to load the game and do not want any slowdowns while loading. Note: if 'cleanupLaunchClassLoaderEarly' is 'true', this option will be ignored", true);
        this.noResourceCache = this.getBoolean("noResourceCache", "launchwrapper", "Disabling caching of resources (Class Bytes). This will induce slowdowns to game/world loads in exchange for more available RAM", false);
        this.noClassCache = this.getBoolean("noClassCache", "launchwrapper", "Disabling caching of classes. This will induce major slowdowns to game/world loads in exchange for more available RAM", false);
        this.weakResourceCache = this.getBoolean("weakResourceCache", "launchwrapper", "Weaken the caching of resources (Class Bytes). This allows the GC to free up more space when the caches are no longer needed. If 'noResourceCache' is 'true', this option will be ignored. This option coincides with Foamfix's 'weakenResourceCache' option", true);
        this.weakClassCache = this.getBoolean("weakClassCache", "launchwrapper", "Weaken the caching of classes. This allows the GC to free up more space when the caches are no longer needed. If 'noClassCache' is 'true', this option will be ignored", true);
        this.disablePackageManifestMap = this.getBoolean("disablePackageManifestMap", "launchwrapper", "Disable the unusused Package Manifest map. This option coincides with Foamfix's 'removePackageManifestMap' option", true);
        this.cleanCachesOnGameLoad = this.getBoolean("cleanCachesOnGameLoad", "launchwrapper", "Invalidate and clean cache entries when the game finishes loading (onto the main screen). Loading into the first world may take longer. This option wouldn't do anything if 'cleanupLaunchClassLoaderLate' is 'true'", false);
        this.resourceLocationCanonicalization = this.getBoolean("resourceLocationCanonicalization", "canonicalization", "Deduplicate ResourceLocation and ModelResourceLocation instances", true);
        this.modelConditionCanonicalization = this.getBoolean("modelConditionCanonicalization", "canonicalization", "Deduplicate Model Conditions. Enable this if you do not have Foamfix installed", false);
        this.nbtTagStringBackingStringCanonicalization = this.getBoolean("nbtTagStringBackingStringCanonicalization", "canonicalization", "Deduplicate Strings in NBTTagString", true);
        this.nbtBackingMapStringCanonicalization = this.getBoolean("nbtBackingMapStringCanonicalization", "canonicalization", "Deduplicate String keys in NBTTagCompound", true);
        this.packageStringCanonicalization = this.getBoolean("packageStringCanonicalization", "canonicalization", "Deduplicate package strings when Forge gathers them when mod candidates are loaded", true);
        this.lockCodeCanonicalization = this.getBoolean("lockCodeCanonicalization", "canonicalization", "Deduplicate LockCode when reading from NBT", true);
        this.spriteNameCanonicalization = this.getBoolean("spriteNameCanonicalization", "canonicalization", "Deduplicate TextureAtlasSprite's names", true);
        this.asmDataStringCanonicalization = this.getBoolean("asmDataStringCanonicalization", "canonicalization", "Deduplicate ASMData related Strings", true);
        this.vertexDataCanonicalization = this.getBoolean("vertexDataCanonicalization", "canonicalization", "EXPERIMENTAL: Deduplicate BakedQuad's Vertex Data array. If you see any artifacting in-game, turn this off and report it on github", true);
        this.filePermissionsCacheCanonicalization = this.getBoolean("filePermissionsCacheCanonicalization", "canonicalization", "Deduplicate Java's FilePermission cache's names within SecureClassLoader", true);
        this.optimizeFMLRemapper = this.getBoolean("optimizeFMLRemapper", "remapper", "Optimizing Forge's Remapper for not storing redundant entries", true);
        this.optimizeRegistries = this.getBoolean("optimizeRegistries", "datastructures", "Optimizes registries", true);
        this.optimizeNBTTagCompoundBackingMap = this.getBoolean("optimizeNBTTagCompoundBackingMap", "datastructures", "Optimize NBTTagCompound's backing map structure", true);
        this.optimizeFurnaceRecipeStore = this.getBoolean("optimizeFurnaceRecipeStore", "datastructures", "Optimizing FurnaceRecipes. FastFurnace will see very little benefit when this option is turned on", true);
        this.stripNearUselessItemStackFields = this.getBoolean("stripNearUselessItemStackFields", "datastructures", "EXPERIMENTAL: Strips ItemStack of some of its fields as it stores some near-useless references", true);
        this.moreModelManagerCleanup = this.getBoolean("moreModelManagerCleanup", "datastructures", "Clears and trims ModelManager data structures after models are loaded and baked", true);
        this.releaseSpriteFramesCache = this.getBoolean("releaseSpriteFramesCache", "textures", "Releases TextureAtlasSprite's framesTextureData. Won't touch custom TextureAtlasSprite implementations", true);
        this.optimizeSomeRendering = this.getBoolean("optimizeSomeRendering", "rendering", "Optimizes some rendering features, not game-breaking; however, negligible at times", true);
        this.stripUnnecessaryLocalsInRenderHelper = this.getBoolean("stripUnnecessaryLocalsInRenderHelper", "rendering", "Strip unnecessary locals in RenderHelper::enableStandardItemLighting, no idea why it's there", true);
        this.quickerEnableUniversalBucketCheck = this.getBoolean("quickerEnableUniversalBucketCheck", "misc", "Optimizes FluidRegistry::enableUniversalBucket check", true);
        this.stripInstancedRandomFromSoundEventAccessor = this.getBoolean("stripInstancedRandomFromSoundEventAccessor", "misc", "Strips the boring instanced Random object from SoundEventAccessors and uses ThreadLocalRandom instead", true);
        this.classCaching = this.getBoolean("classCaching", "misc", "[W.I.P] - EXPERIMENTAL: Yet another attempt at caching classes between loads", false);
        this.copyScreenshotToClipboard = this.getBoolean("copyScreenshotToClipboard", "misc", "Copy image after screenshotting to clipboard", false);
        this.releaseScreenshotCache = this.getBoolean("releaseScreenshotCache", "misc", "For some reason Mojang decided to cache int buffers and arrays after a screenshot is taken, this makes sure they're never cached", true);
        this.fixBlockIEBaseArrayIndexOutOfBoundsException = this.getBoolean("fixBlockIEBaseArrayIndexOutOfBoundsException", "modfixes", "When Immersive Engineering is installed, sometimes it or it's addons can induce an ArrayIndexOutOfBoundsException in BlockIEBase#getPushReaction. This option will be ignored when IE isn't installed", true);
        this.cleanupChickenASMClassHierarchyManager = this.getBoolean("cleanupChickenASMClassHierarchyManager", "modfixes", "EXPERIMENTAL: When ChickenASM (Library of CodeChickenLib and co.) is installed, ClassHierarchyManager can cache a lot of Strings and seem to be unused in any transformation purposes. This clears ClassHierarchyManager of those redundant strings. This option will be ignored when ChickenASM isn't installed", true);
        this.optimizeAmuletRelatedFunctions = this.getBoolean("optimizeAmuletRelatedFunctions", "modfixes", "Optimizes Astral Sorcery's Resplendent Prism related functions. This option will be ignored when Astral Sorcery isn't installed", true);
        this.labelCanonicalization = this.getBoolean("labelCanonicalization", "modfixes", "When Just Enough Items is installed, it deduplicates strings in the generated generalized suffix trees' edge labels. This option will be ignored when Just Enough Items isn't installed", true);
        this.skipCraftTweakerRecalculatingSearchTrees = this.getBoolean("skipCraftTweakerRecalculatingSearchTrees", "modfixes", "When CraftTweaker is installed, large modpacks tend to stall in the last stage of loading, when CraftTweaker inexplicably recalculates search trees. This option will be ignored when CraftTweaker isn't installed", true);
        this.bwmBlastingOilOptimization = this.getBoolean("bwmBlastingOilOptimization", "modfixes", "When Better with Mods is installed, optimize Blasting Oil related events. The original implementation harms server performance at any given moment. This option will be ignored when Better with Mods isn't installed", true);
        this.optimizeQMDBeamRenderer = this.getBoolean("optimizeQMDBeamRenderer", "modfixes", "When QMD is installed, optimize its BeamRenderer. The original implementation harms client performance heavily (takes ~5% of each tick time). This option will be ignored when QMD isn't installed", true);
        this.repairEvilCraftEIOCompat = this.getBoolean("repairEvilCraftEIOCompat", "modfixes", "When EvilCraft Compat + EnderIO is installed, repair the compatibility module", true);
        this.optimizeArcaneLockRendering = this.getBoolean("optimizeArcaneLockRendering", "modfixes", "When Electroblob's Wizardry is installed, optimize the search for arcane locked tile entities to render", true);
        this.fixAmuletHolderCapability = this.getBoolean("fixAmuletHolderCapability", "capability", "Fixes Astral Sorcery applying AmuletHolderCapability to large amount of ItemStacks when it isn't needed. This option will be ignored when Astral Sorcery isn't installed", true);
        this.fixFillBucketEventNullPointerException = this.getBoolean("fixFillBucketEventNullPointerException", "forgefixes", "Fixes Forge's mistake of annotating FillBucketEvent#getFilledBucket as @Nonnull when the contract isn't fulfilled nor checked. First discovered here: https://github.com/Divine-Journey-2/main/issues/295", true);
        this.fixTileEntityOnLoadCME = this.getBoolean("fixTileEntityOnLoadCME", "forgefixes", "Fixes a vanilla-forge code interaction bug leading to a possible ConcurrentModificationException/StackOverflowError crash. First discovered here: https://github.com/GregTechCE/GregTech/issues/1256", true);
        this.removeForgeSecurityManager = this.getBoolean("removeForgeSecurityManager", "forgefixes", "EXPERIMENTAL: Forcibly remove Forge's FMLSecurityManager that adds very very slight overheads in calls that requires permission checks", false);
        this.fasterEntitySpawnPreparation = this.getBoolean("fasterEntitySpawnPreparation", "forgefixes", "Fixes Forge's EntityEntry calling a slow Constructor::newInstance call every time an entity spawns, it is replaced with a fast Function::get generated from LambdaMetafactory#metafactory", true);
        this.sparkProfileEntireGameLoad = this.getBoolean("sparkProfileEntireGameLoad", "spark", "When Spark is installed, profile the loading of the game in its entirety", false);
        this.sparkProfileCoreModLoading = this.getBoolean("sparkProfileCoreModLoading", "spark", "When Spark is installed, profile the loading of coremods, but only those that load after LoliASM", false);
        this.sparkProfileConstructionStage = this.getBoolean("sparkProfileConstructionStage", "spark", "When Spark is installed, profile the loading of FMLConstructionEvent stage", false);
        this.sparkProfilePreInitializationStage = this.getBoolean("sparkProfilePreInitializationStage", "spark", "When Spark is installed, profile the loading of FMLPreInitializationEvent stage", false);
        this.sparkProfileInitializationStage = this.getBoolean("sparkProfileInitializationStage", "spark", "When Spark is installed, profile the loading of FMLInitializationEvent stage", false);
        this.sparkProfilePostInitializationStage = this.getBoolean("sparkProfilePostInitializationStage", "spark", "When Spark is installed, profile the loading of FMLPostInitializationEvent stage", false);
        this.sparkProfileLoadCompleteStage = this.getBoolean("sparkProfileLoadCompleteStage", "spark", "When Spark is installed, profile the loading of FMLLoadCompleteEvent stage", false);
        this.includeAllThreadsWhenProfiling = this.getBoolean("includeAllThreadsWhenProfiling", "spark", "Allow LoliASM's Spark profiling to include all threads that are present", true);
        this.sparkSummarizeHeapSpaceAfterGameLoads = this.getBoolean("sparkSummarizeHeapSpaceAfterGameLoads", "spark", "When Spark is installed, summarize the heap space (/spark heapsummary) when the game finishes loading", false);
        this.configuration.save();
    }

    public void editClassesThatCallBakedQuadCtor(Class<?> clazz) {
        Property prop = this.configuration.getCategory("bakedquad").get("classesThatCallBakedQuadCtor");
        ObjectOpenHashSet classes = new ObjectOpenHashSet((Object[])prop.getStringList());
        if (classes.add(clazz.getName())) {
            prop.set(classes.toArray(new String[0]));
            this.configuration.save();
            LoliLogger.instance.warn("{} added to classesThatCallBakedQuadCtor list in loliasm.cfg", (Object)clazz.getName());
        }
    }

    public void editClassesThatExtendBakedQuad(Class<?> clazz) {
        Property prop = this.configuration.getCategory("bakedquad").get("classesThatExtendBakedQuad");
        ObjectOpenHashSet classes = new ObjectOpenHashSet((Object[])prop.getStringList());
        if (classes.add(clazz.getName())) {
            prop.set(classes.toArray(new String[0]));
            this.configuration.save();
            LoliLogger.instance.warn("{} added to classesThatExtendBakedQuad list in loliasm.cfg", (Object)clazz.getName());
        }
    }

    private boolean setBoolean(String name, String category, boolean newValue) {
        Property prop = this.configuration.getCategory(category).get(name);
        prop.set(newValue);
        return newValue;
    }

    private String[] setStringArray(String name, String category, String ... newValues) {
        Property prop = this.configuration.getCategory(category).get(name);
        prop.set(newValues);
        return newValues;
    }

    private boolean getBoolean(String name, String category, String description, boolean defaultValue) {
        Property prop = this.configuration.get(category, name, defaultValue);
        prop.setDefaultValue(defaultValue);
        prop.setComment(description + " - <default: " + defaultValue + ">");
        prop.setRequiresMcRestart(true);
        prop.setShowInGui(true);
        prop.setLanguageKey("loliasm.config." + name);
        return prop.getBoolean(defaultValue);
    }

    private String[] getStringArray(String name, String category, String description, String ... defaultValue) {
        Property prop = this.configuration.get(category, name, defaultValue);
        prop.setDefaultValues(defaultValue);
        prop.setComment(description + " - <default: " + Arrays.toString(defaultValue) + ">");
        prop.setRequiresMcRestart(true);
        prop.setShowInGui(true);
        prop.setLanguageKey("loliasm.config." + name);
        return prop.getStringList();
    }

    static {
        instance.initialize();
        File oldConfigFile = new File(Launch.minecraftHome, "config" + File.separator + "loliasm.json");
        if (oldConfigFile.exists()) {
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().addDeserializationExclusionStrategy(new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes f) {
                    return f.getAnnotation(Ignore.class) != null;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            }).create();
            try (FileReader reader = new FileReader(oldConfigFile);){
                Data oldConfig = (Data)gson.fromJson((Reader)reader, Data.class);
                LoliConfig.instance.squashBakedQuads = instance.setBoolean("squashBakedQuads", "bakedquad", oldConfig.bakedQuadsSquasher);
                LoliConfig.instance.classesThatCallBakedQuadCtor = instance.setStringArray("classesThatCallBakedQuadCtor", "bakedquad", oldConfig.bakedQuadPatchClasses);
                LoliConfig.instance.logClassesThatCallBakedQuadCtor = instance.setBoolean("logClassesThatCallBakedQuadCtor", "bakedquad", oldConfig.logClassesThatNeedPatching);
                LoliConfig.instance.cleanupLaunchClassLoaderLate = instance.setBoolean("cleanupLaunchClassLoaderLate", "launchwrapper", oldConfig.cleanupLaunchClassLoader);
                LoliConfig.instance.cleanupLaunchClassLoaderLate = instance.setBoolean("cleanupLaunchClassLoaderLate", "launchwrapper", oldConfig.cleanupLaunchClassLoader);
                LoliConfig.instance.optimizeFMLRemapper = instance.setBoolean("optimizeFMLRemapper", "remapper", oldConfig.remapperMemorySaver);
                LoliConfig.instance.optimizeRegistries = instance.setBoolean("optimizeRegistries", "datastructures", oldConfig.optimizeDataStructures);
                LoliConfig.instance.optimizeFurnaceRecipeStore = instance.setBoolean("optimizeFurnaceRecipeStore", "datastructures", oldConfig.optimizeFurnaceRecipes);
                LoliConfig.instance.optimizeSomeRendering = instance.setBoolean("optimizeSomeRendering", "rendering", oldConfig.optimizeBitsOfRendering);
                LoliConfig.instance.quickerEnableUniversalBucketCheck = instance.setBoolean("quickerEnableUniversalBucketCheck", "misc", oldConfig.miscOptimizations);
                LoliConfig.instance.stripInstancedRandomFromSoundEventAccessor = instance.setBoolean("stripInstancedRandomFromSoundEventAccessor", "misc", oldConfig.miscOptimizations);
                LoliConfig.instance.fixBlockIEBaseArrayIndexOutOfBoundsException = instance.setBoolean("fixBlockIEBaseArrayIndexOutOfBoundsException", "modfixes", oldConfig.modFixes);
                LoliConfig.instance.configuration.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            oldConfigFile.delete();
        }
    }

    @Deprecated
    public static class Data {
        final String VERSION;
        @Ignore
        final String bakedQuadsSquasherComment = "Saves memory by optimizing BakedQuads with creation of new BakedQuad classes to squash variables down.";
        @Since(value="1.0")
        public final boolean bakedQuadsSquasher;
        @Ignore
        final String logClassesThatNeedPatchingComment = "Turn this on to log any callers using old BakedQuads constructors. Check logs and put them in the 'bakedQuadPatchClasses' list.";
        @Since(value="1.0")
        public final boolean logClassesThatNeedPatching;
        @Ignore
        final String bakedQuadPatchClassesComment = "List any classes using old BakedQuad constructors. 'logClassesThatNeedPatching' is crucial in identifying the classes.";
        @Since(value="1.0")
        public final String[] bakedQuadPatchClasses;
        @Ignore
        final String cleanupLaunchClassLoaderComment = "Experimental: Saves memory from cleaning out redundant caches in Mojang's LaunchClassLoader. Will impact loading time by a bit.";
        @Since(value="2.0")
        public final boolean cleanupLaunchClassLoader;
        @Ignore
        final String remapperMemorySaverComment = "Experimental: Saves memory by canonizing strings cached in the remapper. May impact loading time by a little.";
        @Since(value="2.0")
        public final boolean remapperMemorySaver;
        @Ignore
        final String canonicalizeObjectsComment = "Experimental: Saves memory by pooling different Object instances and deduplicating them from different locations such as ResourceLocations, IBakedModels.";
        @Since(value="2.0")
        public final boolean canonicalizeObjects;
        @Ignore
        final String optimizeDataStructuresComment = "Saves memory by optimizing various data structures around Minecraft, MinecraftForge and mods.";
        @Since(value="2.0")
        public final boolean optimizeDataStructures;
        @Ignore
        final String optimizeFurnaceRecipesComment = "Saves memory and furnace recipe search time by optimizing FurnaceRecipes' algorithm.";
        @Since(value="2.0")
        public final boolean optimizeFurnaceRecipes;
        @Ignore
        final String optimizeBitsOfRenderingComment = "Optimizes certain aspects of the Client/Rendering Thread.";
        @Since(value="2.3")
        public final boolean optimizeBitsOfRendering;
        @Ignore
        final String miscOptimizationsComment = "Other optimization tweaks. Nothing that is experimental or has breaking changes would be classed under this.";
        @Since(value="2.3.1")
        public final boolean miscOptimizations;
        @Ignore
        final String modFixesComment = "Various mod fixes and optimizations.";
        @Since(value="2.4")
        public final boolean modFixes;

        public Data(String version, boolean bakedQuadsSquasher, boolean logClassesThatNeedPatching, String[] bakedQuadPatchClasses, boolean cleanupLaunchClassLoader, boolean remapperMemorySaver, boolean canonicalizeObjects, boolean optimizeDataStructures, boolean optimizeFurnaceRecipes, boolean optimizeBitsOfRendering, boolean miscOptimizations, boolean modFixes) {
            this.VERSION = version;
            this.bakedQuadsSquasher = bakedQuadsSquasher;
            this.logClassesThatNeedPatching = logClassesThatNeedPatching;
            this.bakedQuadPatchClasses = bakedQuadPatchClasses;
            this.cleanupLaunchClassLoader = cleanupLaunchClassLoader;
            this.remapperMemorySaver = remapperMemorySaver;
            this.canonicalizeObjects = canonicalizeObjects;
            this.optimizeDataStructures = optimizeDataStructures;
            this.optimizeFurnaceRecipes = optimizeFurnaceRecipes;
            this.optimizeBitsOfRendering = optimizeBitsOfRendering;
            this.miscOptimizations = miscOptimizations;
            this.modFixes = modFixes;
        }
    }
}

