/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.stripitemstack.mixins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    private NBTTagCompound field_77990_d;
    @Unique
    private static final Cache<ItemStack, Pair<Block, Boolean>> canPlaceCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    @Unique
    private static final Cache<ItemStack, Pair<Block, Boolean>> canDestroyCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();
    @Unique
    private static Map<ItemStack, EntityItemFrame> itemFrames;

    @Shadow
    public abstract boolean func_77942_o();

    @Overwrite
    public boolean func_82839_y() {
        return itemFrames != null && itemFrames.containsKey(this);
    }

    @Overwrite
    public void func_82842_a(EntityItemFrame frame) {
        if (itemFrames == null) {
            itemFrames = new Reference2ReferenceOpenHashMap();
        }
        itemFrames.put((ItemStack)this, frame);
    }

    @Nullable
    @Overwrite
    public EntityItemFrame func_82836_z() {
        return itemFrames == null ? null : itemFrames.get(this);
    }

    @Overwrite
    public boolean func_179547_d(Block blockIn) {
        Pair placeInfo = (Pair)canPlaceCache.getIfPresent((Object)this);
        if (placeInfo != null && placeInfo.getLeft() == blockIn) {
            return (Boolean)placeInfo.getRight();
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9)) {
            NBTTagList nbttaglist = this.field_77990_d.func_150295_c("CanPlaceOn", 8);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                Block block = Block.func_149684_b((String)nbttaglist.func_150307_f(i));
                if (block != blockIn) continue;
                canPlaceCache.put((Object)((ItemStack)this), (Object)Pair.of((Object)blockIn, (Object)true));
                return true;
            }
        }
        canPlaceCache.put((Object)((ItemStack)this), (Object)Pair.of((Object)blockIn, (Object)false));
        return false;
    }

    @Overwrite
    public boolean func_179544_c(Block blockIn) {
        Pair destroyInfo = (Pair)canDestroyCache.getIfPresent((Object)this);
        if (destroyInfo != null && destroyInfo.getLeft() == blockIn) {
            return (Boolean)destroyInfo.getRight();
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9)) {
            NBTTagList nbttaglist = this.field_77990_d.func_150295_c("CanDestroy", 8);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                Block block = Block.func_149684_b((String)nbttaglist.func_150307_f(i));
                if (block != blockIn) continue;
                canDestroyCache.put((Object)((ItemStack)this), (Object)Pair.of((Object)blockIn, (Object)true));
                return true;
            }
        }
        canDestroyCache.put((Object)((ItemStack)this), (Object)Pair.of((Object)blockIn, (Object)false));
        return false;
    }
}

