/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.internal.mixins;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.ThreadContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import zone.rong.loliasm.config.LoliConfig;
import zone.rong.loliasm.spark.LoliSparker;

@Mixin(value={LoadController.class}, priority=-1000, remap=false)
public abstract class LoadControllerMixin {
    @Shadow(remap=false)
    private ModContainer activeContainer;

    @Shadow(remap=false)
    @Nullable
    protected abstract ModContainer findActiveContainerFromStack();

    @Nullable
    @Overwrite
    public ModContainer activeContainer() {
        if (this.activeContainer == null) {
            String modId = ThreadContext.get((String)"mod");
            if (Strings.isNullOrEmpty((String)modId)) {
                return this.findActiveContainerFromStack();
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modId);
            return container == null ? this.findActiveContainerFromStack() : container;
        }
        return this.activeContainer;
    }

    @Inject(method={"distributeStateMessage(Lnet/minecraftforge/fml/common/LoaderState;[Ljava/lang/Object;)V"}, at={@At(value="HEAD")})
    private void injectBeforeDistributingState(LoaderState state, Object[] eventData, CallbackInfo ci) {
        if (!Loader.isModLoaded((String)"spark")) {
            return;
        }
        switch (state) {
            case CONSTRUCTING: {
                if (LoliConfig.instance.sparkProfileCoreModLoading) {
                    LoliSparker.stop("coremod");
                }
                if (!LoliConfig.instance.sparkProfileConstructionStage) break;
                LoliSparker.start(LoaderState.CONSTRUCTING.toString());
                break;
            }
            case PREINITIALIZATION: {
                if (!LoliConfig.instance.sparkProfilePreInitializationStage) break;
                LoliSparker.start(LoaderState.PREINITIALIZATION.toString());
                break;
            }
            case INITIALIZATION: {
                if (!LoliConfig.instance.sparkProfileInitializationStage) break;
                LoliSparker.start(LoaderState.INITIALIZATION.toString());
                break;
            }
            case POSTINITIALIZATION: {
                if (!LoliConfig.instance.sparkProfilePostInitializationStage) break;
                LoliSparker.start(LoaderState.POSTINITIALIZATION.toString());
                break;
            }
            case AVAILABLE: {
                if (!LoliConfig.instance.sparkProfileLoadCompleteStage) break;
                LoliSparker.start(LoaderState.AVAILABLE.toString());
            }
        }
    }

    @Inject(method={"distributeStateMessage(Lnet/minecraftforge/fml/common/LoaderState;[Ljava/lang/Object;)V"}, at={@At(value="RETURN")})
    private void injectAfterDistributingState(LoaderState state, Object[] eventData, CallbackInfo ci) {
        if (!Loader.isModLoaded((String)"spark")) {
            return;
        }
        switch (state) {
            case CONSTRUCTING: {
                if (!LoliConfig.instance.sparkProfileConstructionStage) break;
                LoliSparker.stop(LoaderState.CONSTRUCTING.toString());
                break;
            }
            case PREINITIALIZATION: {
                if (!LoliConfig.instance.sparkProfilePreInitializationStage) break;
                LoliSparker.stop(LoaderState.PREINITIALIZATION.toString());
                break;
            }
            case INITIALIZATION: {
                if (!LoliConfig.instance.sparkProfileInitializationStage) break;
                LoliSparker.stop(LoaderState.INITIALIZATION.toString());
                break;
            }
            case POSTINITIALIZATION: {
                if (!LoliConfig.instance.sparkProfilePostInitializationStage) break;
                LoliSparker.stop(LoaderState.POSTINITIALIZATION.toString());
                break;
            }
            case AVAILABLE: {
                if (LoliConfig.instance.sparkProfileLoadCompleteStage) {
                    LoliSparker.stop(LoaderState.AVAILABLE.toString());
                }
                if (!LoliConfig.instance.sparkProfileEntireGameLoad) break;
                LoliSparker.stop("game");
            }
        }
    }
}

