/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.sprite;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import zone.rong.loliasm.LoliLogger;
import zone.rong.loliasm.proxy.ClientProxy;

public class FramesTextureData
extends ArrayList<int[][]> {
    public static Set<WeakReference<TextureAtlasSprite>> scheduledToReleaseCache;
    private final WeakReference<TextureAtlasSprite> weakSprite;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && scheduledToReleaseCache != null) {
            for (WeakReference<TextureAtlasSprite> weakRef : scheduledToReleaseCache) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)weakRef.get();
                if (sprite == null) continue;
                try {
                    sprite.func_130103_l();
                }
                catch (NullPointerException e) {
                    LoliLogger.instance.error("NullPointerException: Trying to clear {}'s FramesTextureData but unable to!", (Object)sprite.func_94215_i());
                }
            }
            scheduledToReleaseCache = null;
        }
    }

    public FramesTextureData(TextureAtlasSprite sprite) {
        this.weakSprite = new WeakReference<TextureAtlasSprite>(sprite);
    }

    @Override
    public int[][] get(int index) {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            if (scheduledToReleaseCache == null) {
                scheduledToReleaseCache = new ObjectArraySet();
            }
            scheduledToReleaseCache.add(this.weakSprite);
        }
        return (int[][])super.get(index);
    }

    @Override
    public int size() {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            if (scheduledToReleaseCache == null) {
                scheduledToReleaseCache = new ObjectArraySet();
            }
            scheduledToReleaseCache.add(this.weakSprite);
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        if (ClientProxy.canReload && super.isEmpty()) {
            this.load();
            if (scheduledToReleaseCache == null) {
                scheduledToReleaseCache = new ObjectArraySet();
            }
            scheduledToReleaseCache.add(this.weakSprite);
        }
        return super.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.trimToSize();
    }

    private void load() {
        ResourceLocation location = this.getLocation();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.weakSprite.get();
        if (sprite.hasCustomLoader(resourceManager, location)) {
            sprite.load(resourceManager, location, rl -> textureMap.func_110572_b(rl.toString()));
        } else {
            try (IResource resource = resourceManager.func_110536_a(location);){
                sprite.func_188539_a(resource, Minecraft.func_71410_x().field_71474_y.field_151442_I + 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ResourceLocation getLocation() {
        String[] parts = ResourceLocation.func_177516_a((String)((TextureAtlasSprite)this.weakSprite.get()).func_94215_i());
        return new ResourceLocation(parts[0], String.format("%s/%s%s", Minecraft.func_71410_x().func_147117_R().getBasePath(), parts[1], ".png"));
    }
}

