/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.models.bucket.mixins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import zone.rong.loliasm.bakedquad.BakedQuadFactory;
import zone.rong.loliasm.client.models.bucket.LoliBakedDynBucket;

@Mixin(value={ModelDynBucket.class}, remap=false)
public abstract class ModelDynBucketMixin
implements IModel {
    @Shadow
    @Final
    private static float NORTH_Z_COVER;
    @Shadow
    @Final
    private static float SOUTH_Z_COVER;
    @Shadow
    @Final
    private static float NORTH_Z_FLUID;
    @Shadow
    @Final
    private static float SOUTH_Z_FLUID;
    @Unique
    private static final Reference2ObjectOpenHashMap<TextureAtlasSprite, Int2ObjectMap<Collection<BakedQuad>>> partQuads;
    @Shadow
    @Final
    private boolean flipGas;
    @Shadow
    @Final
    @Nullable
    private Fluid fluid;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation baseLocation;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation liquidLocation;
    @Shadow
    @Final
    @Nullable
    private ResourceLocation coverLocation;
    @Unique
    private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap;
    @Unique
    private Pair<TextureAtlasSprite, List<BakedQuad>> bucketInfo;

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.transformMap == null) {
            this.transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((IModelState)state));
        }
        if (this.flipGas && this.fluid != null && this.fluid.isLighterThanAir()) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        TextureAtlasSprite particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            if (this.bucketInfo == null) {
                IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
                this.bucketInfo = Pair.of((Object)model.func_177554_e(), (Object)model.func_188616_a(null, null, 0L));
            }
            builder.addAll((Iterable)this.bucketInfo.getRight());
            particleSprite = (TextureAtlasSprite)this.bucketInfo.getLeft();
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = bakedTextureGetter.apply(this.liquidLocation);
            Int2ObjectMap tintIndex = (Int2ObjectMap)partQuads.computeIfAbsent((Object)fluidSprite, k -> new Int2ObjectArrayMap(1));
            Collection parts = (Collection)tintIndex.get(this.fluid.getColor());
            if (parts == null) {
                parts = Stream.of(ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)NORTH_Z_FLUID, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor(), (int)1), ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)SOUTH_Z_FLUID, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor(), (int)1)).flatMap(Collection::stream).map(ubq -> BakedQuadFactory.create(ubq.func_178209_a(), ubq.func_178211_c(), ubq.func_178210_d(), ubq.func_187508_a(), ubq.shouldApplyDiffuseLighting(), ubq.getFormat())).collect(Collectors.toList());
                tintIndex.put(this.fluid.getColor(), (Object)parts);
            }
            builder.addAll((Iterable)parts);
            particleSprite = fluidSprite;
        }
        if (this.coverLocation != null) {
            TextureAtlasSprite cover = bakedTextureGetter.apply(this.coverLocation);
            Int2ObjectMap innerMap = (Int2ObjectMap)partQuads.get((Object)cover);
            if (innerMap == null) {
                innerMap = Int2ObjectMaps.singleton((int)-1, Lists.newArrayList((Object[])new UnpackedBakedQuad[]{ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)NORTH_Z_COVER, (TextureAtlasSprite)cover, (EnumFacing)EnumFacing.NORTH, (int)-1, (int)2), ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)SOUTH_Z_COVER, (TextureAtlasSprite)cover, (EnumFacing)EnumFacing.SOUTH, (int)-1, (int)2)}).stream().map(ubq -> BakedQuadFactory.create(ubq.func_178209_a(), ubq.func_178211_c(), ubq.func_178210_d(), ubq.func_187508_a(), ubq.shouldApplyDiffuseLighting(), ubq.getFormat())).collect(Collectors.toList()));
                partQuads.put((Object)cover, (Object)innerMap);
            }
            builder.addAll((Iterable)innerMap.get(-1));
            if (particleSprite == null) {
                particleSprite = cover;
            }
        }
        return new LoliBakedDynBucket((ModelDynBucket)this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, format, this.transformMap, transform.isIdentity());
    }

    static {
        partQuads = new Reference2ObjectOpenHashMap();
    }
}

