/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.models.bucket;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class LoliBakedDynBucket
extends BakedItemModel {
    private final ModelDynBucket parent;
    private final VertexFormat format;
    private final Cache<String, IBakedModel> bucketVariants;

    public LoliBakedDynBucket(ModelDynBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, boolean untransformed) {
        super(quads, particle, transforms, (ItemOverrideList)LoliBakedDynBucketOverrdeList.INSTANCE, untransformed);
        this.parent = parent;
        this.format = format;
        this.bucketVariants = CacheBuilder.newBuilder().weakValues().build();
    }

    private static final class LoliBakedDynBucketOverrdeList
    extends ItemOverrideList {
        private static final LoliBakedDynBucketOverrdeList INSTANCE = new LoliBakedDynBucketOverrdeList();

        private LoliBakedDynBucketOverrdeList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack == null) {
                return originalModel;
            }
            LoliBakedDynBucket bakedModel = (LoliBakedDynBucket)originalModel;
            try {
                return (IBakedModel)bakedModel.bucketVariants.get((Object)fluidStack.getFluid().getName(), () -> this.bake(bakedModel, fluidStack.getFluid().getName()));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return this.bake(bakedModel, fluidStack.getFluid().getName());
            }
        }

        private IBakedModel bake(LoliBakedDynBucket bakedModel, String fluidName) {
            ModelDynBucket parent = bakedModel.parent.process(ImmutableMap.of((Object)"fluid", (Object)fluidName));
            return parent.bake((IModelState)new SimpleModelState(bakedModel.transforms), bakedModel.format, ModelLoader.defaultTextureGetter());
        }
    }
}

