/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import snownee.kiwi.tile.TileBase;

public class TileInventoryBase
extends TileBase {
    public final StackHandler stacks;

    public TileInventoryBase(int slot) {
        this(slot, Items.field_190931_a.func_77639_j());
    }

    public TileInventoryBase(int slot, int stackLimit) {
        this.stacks = new StackHandler(slot, stackLimit);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.stacks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Items", 10)) {
            this.stacks.deserializeNBT(compound.func_74775_l("Items"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Items", (NBTBase)this.stacks.serializeNBT());
        return compound;
    }

    @Override
    protected void readPacketData(NBTTagCompound data) {
        this.stacks.deserializeNBT(data.func_74775_l("Items"));
    }

    @Override
    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74782_a("Items", (NBTBase)this.stacks.serializeNBT());
        return data;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void onContentsChanged(int slot) {
        this.refresh();
    }

    public class StackHandler
    extends ItemStackHandler {
        private final int stackLimit;

        @Deprecated
        StackHandler(TileInventoryBase tile, int slot, int stackLimit) {
            this(slot, stackLimit);
        }

        StackHandler(int slot, int stackLimit) {
            super(slot);
            this.stackLimit = stackLimit;
        }

        public int getSlotLimit(int slot) {
            return this.stackLimit;
        }

        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileInventoryBase.this.isItemValidForSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileInventoryBase.this.onContentsChanged(slot);
        }
    }
}

