/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.kiwi.IModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.block.IModBlock;
import snownee.kiwi.item.IModItem;
import snownee.kiwi.item.ItemModBlock;
import snownee.kiwi.potion.PotionMod;

@Mod.EventBusSubscriber(modid="kiwi")
public class KiwiManager {
    public static final HashMap<ResourceLocation, IModule> MODULES = new HashMap();
    public static final HashSet<ResourceLocation> ENABLED_MODULES = new HashSet();
    public static Map<IModBlock, String> BLOCKS = new HashMap<IModBlock, String>();
    public static Map<IModItem, String> ITEMS = new HashMap<IModItem, String>();
    public static Map<PotionMod, String> POTIONS = new HashMap<PotionMod, String>();

    private KiwiManager() {
    }

    public static void addInstance(ResourceLocation resourceLocation, IModule module) {
        if (MODULES.containsKey(resourceLocation)) {
            Kiwi.logger.error("Found a duplicate module name, skipping.");
        } else {
            MODULES.put(resourceLocation, module);
            ENABLED_MODULES.add(resourceLocation);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Map map = Loader.instance().getIndexedModList();
        BLOCKS.forEach((block, modid) -> {
            Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
            block.register((String)modid);
            event.getRegistry().register((IForgeRegistryEntry)block.cast());
        });
        Loader.instance().setActiveModContainer(null);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Map map = Loader.instance().getIndexedModList();
        ITEMS.forEach((item, modid) -> {
            Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
            item.register((String)modid);
            event.getRegistry().register((IForgeRegistryEntry)item.cast());
        });
        BLOCKS.forEach((block, modid) -> {
            if (block.getItemSubtypeAmount() > 0) {
                Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
                ItemModBlock item = new ItemModBlock((IModBlock)block);
                item.setRegistryName(block.getRegistryName());
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        });
        Loader.instance().setActiveModContainer(null);
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        Map map = Loader.instance().getIndexedModList();
        POTIONS.forEach((potion, modid) -> {
            Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
            potion.register((String)modid);
            event.getRegistry().register((IForgeRegistryEntry)potion);
        });
        Loader.instance().setActiveModContainer(null);
    }

    @SubscribeEvent
    public static void registerPotionEffects(RegistryEvent.Register<PotionType> event) {
        Map map = Loader.instance().getIndexedModList();
        POTIONS.forEach((potion, modid) -> {
            Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
            Collection<PotionType> types = potion.getPotionTypes();
            for (PotionType type : types) {
                event.getRegistry().register(type.setRegistryName(modid, type.func_185174_b("")));
            }
        });
        Loader.instance().setActiveModContainer(null);
    }
}

